/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.ArrayList;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.indices.SystemIndices;

public class SystemIndexMetadataUpgradeService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(SystemIndexMetadataUpgradeService.class);
    private final SystemIndices systemIndices;
    private final ClusterService clusterService;
    private volatile boolean updateTaskPending = false;
    private volatile long triggeredVersion = -1L;

    public SystemIndexMetadataUpgradeService(SystemIndices systemIndices, ClusterService clusterService) {
        this.systemIndices = systemIndices;
        this.clusterService = clusterService;
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (!(this.updateTaskPending || !event.localNodeMaster() || event.previousState().nodes().isLocalNodeElectedMaster() && event.state().metadata().indices() == event.previousState().metadata().indices())) {
            long triggerV;
            final Map<String, IndexMetadata> indexMetadataMap = event.state().metadata().indices();
            final Map<String, IndexMetadata> previousIndices = event.previousState().metadata().indices();
            this.triggeredVersion = triggerV = event.state().version();
            this.clusterService.threadPool().executor("management").execute(new AbstractRunnable(){

                @Override
                protected void doRun() {
                    if (SystemIndexMetadataUpgradeService.this.triggeredVersion != triggerV) {
                        return;
                    }
                    for (Map.Entry cursor : indexMetadataMap.entrySet()) {
                        IndexMetadata indexMetadata;
                        if (cursor.getValue() == previousIndices.get(cursor.getKey()) || !SystemIndexMetadataUpgradeService.this.requiresUpdate(indexMetadata = (IndexMetadata)cursor.getValue())) continue;
                        SystemIndexMetadataUpgradeService.this.updateTaskPending = true;
                        SystemIndexMetadataUpgradeService.this.submitUnbatchedTask("system_index_metadata_upgrade_service {system metadata change}", new SystemIndexMetadataUpdateTask());
                        break;
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    logger.error("unexpected exception on checking for metadata upgrades", (Throwable)e);
                    assert (false) : e;
                }
            });
        }
    }

    boolean requiresUpdate(IndexMetadata indexMetadata) {
        boolean shouldBeSystem = this.shouldBeSystem(indexMetadata);
        if (shouldBeSystem != indexMetadata.isSystem()) {
            return true;
        }
        if (shouldBeSystem) {
            return this.isVisible(indexMetadata) || this.hasVisibleAlias(indexMetadata);
        }
        return false;
    }

    boolean isVisible(IndexMetadata indexMetadata) {
        return indexMetadata.getSettings().getAsBoolean("index.hidden", false) == false;
    }

    boolean shouldBeSystem(IndexMetadata indexMetadata) {
        return this.systemIndices.isSystemIndex(indexMetadata.getIndex()) || this.systemIndices.isSystemIndexBackingDataStream(indexMetadata.getIndex().getName());
    }

    boolean hasVisibleAlias(IndexMetadata indexMetadata) {
        return indexMetadata.getAliases().values().stream().anyMatch(a -> Boolean.FALSE.equals(a.isHidden()));
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    SystemIndexMetadataUpdateTask getTask() {
        return new SystemIndexMetadataUpdateTask();
    }

    public class SystemIndexMetadataUpdateTask
    extends ClusterStateUpdateTask {
        @Override
        public ClusterState execute(ClusterState currentState) throws Exception {
            Map<String, IndexMetadata> indexMetadataMap = currentState.metadata().indices();
            ArrayList<IndexMetadata> updatedMetadata = new ArrayList<IndexMetadata>();
            for (Map.Entry<String, IndexMetadata> entry : indexMetadataMap.entrySet()) {
                IndexMetadata indexMetadata = entry.getValue();
                boolean shouldBeSystem = SystemIndexMetadataUpgradeService.this.shouldBeSystem(indexMetadata);
                IndexMetadata.Builder builder = IndexMetadata.builder(indexMetadata);
                boolean updated = false;
                if (shouldBeSystem != indexMetadata.isSystem()) {
                    builder.system(!indexMetadata.isSystem());
                    updated = true;
                }
                if (shouldBeSystem && SystemIndexMetadataUpgradeService.this.isVisible(indexMetadata)) {
                    builder.settings(Settings.builder().put(indexMetadata.getSettings()).put("index.hidden", true));
                    builder.settingsVersion(builder.settingsVersion() + 1L);
                    updated = true;
                }
                if (shouldBeSystem && SystemIndexMetadataUpgradeService.this.hasVisibleAlias(indexMetadata)) {
                    for (AliasMetadata aliasMetadata : indexMetadata.getAliases().values()) {
                        if (!Boolean.FALSE.equals(aliasMetadata.isHidden())) continue;
                        builder.removeAlias(aliasMetadata.alias());
                        builder.putAlias(AliasMetadata.builder(aliasMetadata.alias()).filter(aliasMetadata.filter()).indexRouting(aliasMetadata.indexRouting()).isHidden(true).searchRouting(aliasMetadata.searchRouting()).writeIndex(aliasMetadata.writeIndex()));
                    }
                }
                if (!updated) continue;
                updatedMetadata.add(builder.build());
            }
            if (!updatedMetadata.isEmpty()) {
                Metadata.Builder builder = Metadata.builder(currentState.metadata());
                updatedMetadata.forEach(idxMeta -> builder.put((IndexMetadata)idxMeta, true));
                return ClusterState.builder(currentState).metadata(builder).build();
            }
            return currentState;
        }

        @Override
        public void onFailure(Exception e) {
            SystemIndexMetadataUpgradeService.this.updateTaskPending = false;
            logger.error("failed to update system index metadata", (Throwable)e);
        }

        @Override
        public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
            SystemIndexMetadataUpgradeService.this.updateTaskPending = false;
        }
    }
}

