/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.node;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.core.Nullable;

public class DiscoveryNodeFilters {
    public static final Set<String> SINGLE_NODE_NAMES = Set.of("_id", "_name", "name");
    static final Set<String> NON_ATTRIBUTE_NAMES = Set.of("_ip", "_host_ip", "_publish_ip", "host", "_id", "_name", "name");
    private final Map<String, String[]> filters;
    private final OpType opType;
    @Nullable
    private final DiscoveryNodeFilters withoutTierPreferences;

    public static void validateIpValue(String propertyKey, List<String> values) {
        if (values != null && (propertyKey.endsWith("._ip") || propertyKey.endsWith("._host_ip") || propertyKey.endsWith("_publish_ip"))) {
            for (String value : values) {
                if (Regex.isSimpleMatchPattern(value) || InetAddresses.isInetAddress(value)) continue;
                throw new IllegalArgumentException("invalid IP address [" + value + "] for [" + propertyKey + "]");
            }
        }
    }

    public static DiscoveryNodeFilters buildFromKeyValues(OpType opType, Map<String, List<String>> filters) {
        HashMap<String, String[]> bFilters = new HashMap<String, String[]>();
        for (Map.Entry<String, List<String>> entry : filters.entrySet()) {
            String[] values = (String[])entry.getValue().toArray(String[]::new);
            if (values.length <= 0 || entry.getKey() == null) continue;
            bFilters.put(entry.getKey(), values);
        }
        if (bFilters.isEmpty()) {
            return null;
        }
        return new DiscoveryNodeFilters(opType, bFilters);
    }

    private DiscoveryNodeFilters(OpType opType, Map<String, String[]> filters) {
        this.opType = opType;
        this.filters = Map.copyOf(filters);
        this.withoutTierPreferences = DiscoveryNodeFilters.doTrimTier(this);
    }

    private static boolean matchByIP(String[] values, @Nullable String hostIp, @Nullable String publishIp) {
        for (String ipOrHost : values) {
            boolean matchIp;
            String value = InetAddresses.isInetAddress(ipOrHost) ? NetworkAddress.format(InetAddresses.forString(ipOrHost)) : ipOrHost;
            boolean bl = matchIp = Regex.simpleMatch(value, hostIp) || Regex.simpleMatch(value, publishIp);
            if (!matchIp) continue;
            return matchIp;
        }
        return false;
    }

    @Nullable
    public static DiscoveryNodeFilters trimTier(@Nullable DiscoveryNodeFilters original) {
        return original == null ? null : original.withoutTierPreferences;
    }

    private static DiscoveryNodeFilters doTrimTier(DiscoveryNodeFilters original) {
        if (!original.filters.containsKey("_tier_preference")) {
            return original;
        }
        HashMap<String, String[]> newFilters = new HashMap<String, String[]>(original.filters);
        String[] removed = (String[])newFilters.remove("_tier_preference");
        assert (removed != null);
        return newFilters.isEmpty() ? null : new DiscoveryNodeFilters(original.opType, newFilters);
    }

    public boolean match(DiscoveryNode node) {
        for (Map.Entry<String, String[]> entry : this.filters.entrySet()) {
            int n;
            String attr = entry.getKey();
            String[] values = entry.getValue();
            if ("_ip".equals(attr)) {
                String publishAddress = null;
                if (node.getAddress() instanceof TransportAddress) {
                    publishAddress = NetworkAddress.format(node.getAddress().address().getAddress());
                }
                boolean match = DiscoveryNodeFilters.matchByIP(values, node.getHostAddress(), publishAddress);
                if (this.opType == OpType.AND) {
                    if (match) continue;
                    return false;
                }
                if (!match || this.opType != OpType.OR) continue;
                return true;
            }
            if ("_host_ip".equals(attr)) {
                boolean match = DiscoveryNodeFilters.matchByIP(values, node.getHostAddress(), null);
                if (this.opType == OpType.AND) {
                    if (match) continue;
                    return false;
                }
                if (!match || this.opType != OpType.OR) continue;
                return true;
            }
            if ("_publish_ip".equals(attr)) {
                String address = null;
                if (node.getAddress() instanceof TransportAddress) {
                    address = NetworkAddress.format(node.getAddress().address().getAddress());
                }
                boolean match = DiscoveryNodeFilters.matchByIP(values, address, null);
                if (this.opType == OpType.AND) {
                    if (match) continue;
                    return false;
                }
                if (!match || this.opType != OpType.OR) continue;
                return true;
            }
            if ("_host".equals(attr)) {
                String[] address = values;
                int n2 = address.length;
                for (n = 0; n < n2; ++n) {
                    String value = address[n];
                    if (Regex.simpleMatch(value, node.getHostName()) || Regex.simpleMatch(value, node.getHostAddress())) {
                        if (this.opType != OpType.OR) continue;
                        return true;
                    }
                    if (this.opType != OpType.AND) continue;
                    return false;
                }
                continue;
            }
            if ("_id".equals(attr)) {
                String[] address = values;
                int n3 = address.length;
                for (n = 0; n < n3; ++n) {
                    String value = address[n];
                    if (node.getId().equals(value)) {
                        if (this.opType != OpType.OR) continue;
                        return true;
                    }
                    if (this.opType != OpType.AND) continue;
                    return false;
                }
                continue;
            }
            if ("_name".equals(attr) || "name".equals(attr)) {
                String[] address = values;
                int n4 = address.length;
                for (n = 0; n < n4; ++n) {
                    String value = address[n];
                    if (Regex.simpleMatch(value, node.getName())) {
                        if (this.opType != OpType.OR) continue;
                        return true;
                    }
                    if (this.opType != OpType.AND) continue;
                    return false;
                }
                continue;
            }
            String nodeAttributeValue = node.getAttributes().get(attr);
            if (nodeAttributeValue == null) {
                if (this.opType != OpType.AND) continue;
                return false;
            }
            String[] stringArray = values;
            n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String value = stringArray[i];
                if (Regex.simpleMatch(value, nodeAttributeValue)) {
                    if (this.opType != OpType.OR) continue;
                    return true;
                }
                if (this.opType != OpType.AND) continue;
                return false;
            }
        }
        return this.opType != OpType.OR;
    }

    public boolean isOnlyAttributeValueFilter() {
        return !this.filters.keySet().stream().anyMatch(NON_ATTRIBUTE_NAMES::contains);
    }

    public boolean isSingleNodeFilter() {
        return this.withoutTierPreferences != null && this.withoutTierPreferences.isSingleNodeFilterInternal();
    }

    private boolean isSingleNodeFilterInternal() {
        return this.filters.size() == 1 && NON_ATTRIBUTE_NAMES.contains(this.filters.keySet().iterator().next()) && (this.filters.values().iterator().next().length == 1 || this.opType == OpType.AND) || this.filters.size() > 1 && this.opType == OpType.AND && NON_ATTRIBUTE_NAMES.containsAll(this.filters.keySet());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int entryCount = this.filters.size();
        for (Map.Entry<String, String[]> entry : this.filters.entrySet()) {
            String attr = entry.getKey();
            String[] values = entry.getValue();
            sb.append(attr);
            sb.append(":\"");
            int valueCount = values.length;
            for (String value : values) {
                sb.append(value);
                if (valueCount > 1) {
                    sb.append(" ").append(this.opType.toString()).append(" ");
                }
                --valueCount;
            }
            sb.append("\"");
            if (entryCount > 1) {
                sb.append(",");
            }
            --entryCount;
        }
        return sb.toString();
    }

    public static enum OpType {
        AND,
        OR;

    }
}

