/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.routing.ShardRouting;

public record ShardAssignment(Set<String> nodeIds, int total, int unassigned, int ignored) {
    public ShardAssignment {
        assert (total > 0) : "Shard assignment should not be empty";
        assert (nodeIds.size() + unassigned == total) : "Shard assignment should account for all shards";
    }

    public boolean isIgnored(boolean primary) {
        return primary ? this.total == this.ignored : this.ignored > 0;
    }

    public static ShardAssignment ofAssignedShards(List<ShardRouting> routings) {
        assert (routings.stream().allMatch(ShardRouting::started)) : routings;
        LinkedHashSet nodeIds = routings.stream().map(ShardRouting::currentNodeId).collect(Collectors.toCollection(LinkedHashSet::new));
        return new ShardAssignment(Collections.unmodifiableSet(nodeIds), routings.size(), 0, 0);
    }
}

