/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.elasticsearch.Build;
import org.elasticsearch.Version;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public final class ReferenceDocs
extends Enum<ReferenceDocs> {
    public static final /* enum */ ReferenceDocs INITIAL_MASTER_NODES = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs DISCOVERY_TROUBLESHOOTING = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs UNSTABLE_CLUSTER_TROUBLESHOOTING = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs LAGGING_NODE_TROUBLESHOOTING = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs SHARD_LOCK_TROUBLESHOOTING = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs CONCURRENT_REPOSITORY_WRITERS = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs ARCHIVE_INDICES = new ReferenceDocs();
    private static final Map<String, String> linksBySymbol;
    static final String UNRELEASED_VERSION_COMPONENT = "master";
    static final String VERSION_COMPONENT;
    private static final /* synthetic */ ReferenceDocs[] $VALUES;

    public static ReferenceDocs[] values() {
        return (ReferenceDocs[])$VALUES.clone();
    }

    public static ReferenceDocs valueOf(String name) {
        return Enum.valueOf(ReferenceDocs.class, name);
    }

    static Map<String, String> readLinksBySymbol(InputStream inputStream) throws Exception {
        try (XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, inputStream);){
            Map result = parser.map(LinkedHashMap::new, XContentParser::text);
            Iterator iterator = result.keySet().iterator();
            for (int i = 0; i < ReferenceDocs.values().length; ++i) {
                String expected = ReferenceDocs.values()[i].name();
                if (!iterator.hasNext()) {
                    throw new IllegalStateException("ran out of values at index " + i + ": expecting " + expected);
                }
                String actual = (String)iterator.next();
                if (actual.equals(expected)) continue;
                throw new IllegalStateException("mismatch at index " + i + ": found " + actual + " but expected " + expected);
            }
            if (iterator.hasNext()) {
                throw new IllegalStateException("found unexpected extra value: " + (String)iterator.next());
            }
            Map map = result;
            return map;
        }
    }

    static String getVersionComponent(Version version, boolean isSnapshot) {
        return isSnapshot && version.revision == 0 ? UNRELEASED_VERSION_COMPONENT : version.major + "." + version.minor;
    }

    public String toString() {
        return "https://www.elastic.co/guide/en/elasticsearch/reference/" + VERSION_COMPONENT + "/" + linksBySymbol.get(this.name());
    }

    @SuppressForbidden(reason="reads resource from jar")
    private static InputStream readFromJarResourceUrl(URL source) throws IOException {
        if (source == null) {
            throw new FileNotFoundException("links resource not found at [" + source + "]");
        }
        return source.openStream();
    }

    private static /* synthetic */ ReferenceDocs[] $values() {
        return new ReferenceDocs[]{INITIAL_MASTER_NODES, DISCOVERY_TROUBLESHOOTING, UNSTABLE_CLUSTER_TROUBLESHOOTING, LAGGING_NODE_TROUBLESHOOTING, SHARD_LOCK_TROUBLESHOOTING, CONCURRENT_REPOSITORY_WRITERS, ARCHIVE_INDICES};
    }

    static {
        $VALUES = ReferenceDocs.$values();
        try (InputStream resourceStream = ReferenceDocs.readFromJarResourceUrl(ReferenceDocs.class.getResource("reference-docs-links.json"));){
            linksBySymbol = Map.copyOf(ReferenceDocs.readLinksBySymbol(resourceStream));
        }
        catch (Exception e) {
            assert (false) : e;
            throw new IllegalStateException("could not read links resource", e);
        }
        VERSION_COMPONENT = ReferenceDocs.getVersionComponent(Version.CURRENT, Build.CURRENT.isSnapshot());
    }
}

