/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.DeleteResult;
import org.elasticsearch.common.blobstore.support.BlobMetadata;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.core.CheckedConsumer;

public abstract class FilterBlobContainer
implements BlobContainer {
    private final BlobContainer delegate;

    public FilterBlobContainer(BlobContainer delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    protected abstract BlobContainer wrapChild(BlobContainer var1);

    @Override
    public BlobPath path() {
        return this.delegate.path();
    }

    @Override
    public boolean blobExists(String blobName) throws IOException {
        return this.delegate.blobExists(blobName);
    }

    @Override
    public InputStream readBlob(String blobName) throws IOException {
        return this.delegate.readBlob(blobName);
    }

    @Override
    public InputStream readBlob(String blobName, long position, long length) throws IOException {
        return this.delegate.readBlob(blobName, position, length);
    }

    @Override
    public long readBlobPreferredLength() {
        return this.delegate.readBlobPreferredLength();
    }

    @Override
    public void writeBlob(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        this.delegate.writeBlob(blobName, inputStream, blobSize, failIfAlreadyExists);
    }

    @Override
    public void writeMetadataBlob(String blobName, boolean failIfAlreadyExists, boolean atomic, CheckedConsumer<OutputStream, IOException> writer) throws IOException {
        this.delegate.writeMetadataBlob(blobName, failIfAlreadyExists, atomic, writer);
    }

    @Override
    public void writeBlobAtomic(String blobName, BytesReference bytes, boolean failIfAlreadyExists) throws IOException {
        this.delegate.writeBlobAtomic(blobName, bytes, failIfAlreadyExists);
    }

    @Override
    public DeleteResult delete() throws IOException {
        return this.delegate.delete();
    }

    @Override
    public void deleteBlobsIgnoringIfNotExists(Iterator<String> blobNames) throws IOException {
        this.delegate.deleteBlobsIgnoringIfNotExists(blobNames);
    }

    @Override
    public Map<String, BlobMetadata> listBlobs() throws IOException {
        return this.delegate.listBlobs();
    }

    @Override
    public Map<String, BlobContainer> children() throws IOException {
        return this.delegate.children().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.wrapChild((BlobContainer)e.getValue())));
    }

    @Override
    public Map<String, BlobMetadata> listBlobsByPrefix(String blobNamePrefix) throws IOException {
        return this.delegate.listBlobsByPrefix(blobNamePrefix);
    }
}

