/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.io.IOException;
import java.text.ParseException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.geo.SpatialPoint;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.ShapeType;
import org.elasticsearch.geometry.utils.GeometryValidator;
import org.elasticsearch.geometry.utils.StandardValidator;
import org.elasticsearch.geometry.utils.WellKnownText;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public abstract class BoundingBox<T extends SpatialPoint>
implements ToXContentFragment,
Writeable {
    static final ParseField TOP_RIGHT_FIELD = new ParseField("top_right", new String[0]);
    static final ParseField BOTTOM_LEFT_FIELD = new ParseField("bottom_left", new String[0]);
    static final ParseField TOP_FIELD = new ParseField("top", new String[0]);
    static final ParseField BOTTOM_FIELD = new ParseField("bottom", new String[0]);
    static final ParseField LEFT_FIELD = new ParseField("left", new String[0]);
    static final ParseField RIGHT_FIELD = new ParseField("right", new String[0]);
    static final ParseField WKT_FIELD = new ParseField("wkt", new String[0]);
    public static final ParseField BOUNDS_FIELD = new ParseField("bounds", new String[0]);
    public static final ParseField TOP_LEFT_FIELD = new ParseField("top_left", new String[0]);
    public static final ParseField BOTTOM_RIGHT_FIELD = new ParseField("bottom_right", new String[0]);
    protected final T topLeft;
    protected final T bottomRight;

    public BoundingBox(T topLeft, T bottomRight) {
        this.topLeft = topLeft;
        this.bottomRight = bottomRight;
    }

    public boolean isUnbounded() {
        return Double.isNaN(this.left()) || Double.isNaN(this.top()) || Double.isNaN(this.right()) || Double.isNaN(this.bottom());
    }

    public T topLeft() {
        return this.topLeft;
    }

    public T bottomRight() {
        return this.bottomRight;
    }

    public final double top() {
        return this.topLeft.getY();
    }

    public final double bottom() {
        return this.bottomRight.getY();
    }

    public final double left() {
        return this.topLeft.getX();
    }

    public final double right() {
        return this.bottomRight.getX();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragment(builder);
        builder.endObject();
        return builder;
    }

    public abstract XContentBuilder toXContentFragment(XContentBuilder var1) throws IOException;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundingBox that = (BoundingBox)o;
        return this.topLeft.equals(that.topLeft) && this.bottomRight.equals(that.bottomRight);
    }

    public int hashCode() {
        return Objects.hash(this.topLeft, this.bottomRight);
    }

    public String toString() {
        return "BBOX (" + this.left() + ", " + this.right() + ", " + this.top() + ", " + this.bottom() + ")";
    }

    protected static abstract class BoundsParser<T extends BoundingBox<? extends SpatialPoint>> {
        protected double top = Double.NaN;
        protected double bottom = Double.NaN;
        protected double left = Double.NaN;
        protected double right = Double.NaN;
        protected Rectangle envelope = null;
        final XContentParser parser;

        protected BoundsParser(XContentParser parser) {
            this.parser = parser;
        }

        public T parseBoundingBox() throws IOException, ElasticsearchParseException {
            XContentParser.Token token = this.parser.currentToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new ElasticsearchParseException("failed to parse bounding box. Expected start object but found [{}]", token);
            }
            while ((token = this.parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    SpatialPoint point;
                    String currentFieldName = this.parser.currentName();
                    this.parser.nextToken();
                    if (WKT_FIELD.match(currentFieldName, this.parser.getDeprecationHandler())) {
                        try {
                            Geometry geometry = WellKnownText.fromWKT((GeometryValidator)StandardValidator.instance((boolean)true), (boolean)true, (String)this.parser.text());
                            if (!ShapeType.ENVELOPE.equals((Object)geometry.type())) {
                                throw new ElasticsearchParseException("failed to parse WKT bounding box. [" + geometry.type() + "] found. expected [" + ShapeType.ENVELOPE + "]", new Object[0]);
                            }
                            this.envelope = (Rectangle)geometry;
                            continue;
                        }
                        catch (IllegalArgumentException | ParseException e) {
                            throw new ElasticsearchParseException("failed to parse WKT bounding box", (Throwable)e, new Object[0]);
                        }
                    }
                    if (TOP_FIELD.match(currentFieldName, this.parser.getDeprecationHandler())) {
                        this.top = this.parser.doubleValue();
                        continue;
                    }
                    if (BOTTOM_FIELD.match(currentFieldName, this.parser.getDeprecationHandler())) {
                        this.bottom = this.parser.doubleValue();
                        continue;
                    }
                    if (LEFT_FIELD.match(currentFieldName, this.parser.getDeprecationHandler())) {
                        this.left = this.parser.doubleValue();
                        continue;
                    }
                    if (RIGHT_FIELD.match(currentFieldName, this.parser.getDeprecationHandler())) {
                        this.right = this.parser.doubleValue();
                        continue;
                    }
                    if (TOP_LEFT_FIELD.match(currentFieldName, this.parser.getDeprecationHandler())) {
                        point = this.parsePointWith(this.parser, GeoUtils.EffectivePoint.TOP_LEFT);
                        this.top = point.getY();
                        this.left = point.getX();
                        continue;
                    }
                    if (BOTTOM_RIGHT_FIELD.match(currentFieldName, this.parser.getDeprecationHandler())) {
                        point = this.parsePointWith(this.parser, GeoUtils.EffectivePoint.BOTTOM_RIGHT);
                        this.bottom = point.getY();
                        this.right = point.getX();
                        continue;
                    }
                    if (TOP_RIGHT_FIELD.match(currentFieldName, this.parser.getDeprecationHandler())) {
                        point = this.parsePointWith(this.parser, GeoUtils.EffectivePoint.TOP_RIGHT);
                        this.top = point.getY();
                        this.right = point.getX();
                        continue;
                    }
                    if (BOTTOM_LEFT_FIELD.match(currentFieldName, this.parser.getDeprecationHandler())) {
                        point = this.parsePointWith(this.parser, GeoUtils.EffectivePoint.BOTTOM_LEFT);
                        this.bottom = point.getY();
                        this.left = point.getX();
                        continue;
                    }
                    throw new ElasticsearchParseException("failed to parse bounding box. unexpected field [{}]", currentFieldName);
                }
                throw new ElasticsearchParseException("failed to parse bounding box. field name expected but [{}] found", token);
            }
            if (this.envelope != null) {
                if (!(Double.isNaN(this.top) && Double.isNaN(this.bottom) && Double.isNaN(this.left) && Double.isNaN(this.right))) {
                    throw new ElasticsearchParseException("failed to parse bounding box. Conflicting definition found using well-known text and explicit corners.", new Object[0]);
                }
                return this.createWithEnvelope();
            }
            return this.createWithBounds();
        }

        protected abstract T createWithEnvelope();

        protected abstract T createWithBounds();

        protected abstract SpatialPoint parsePointWith(XContentParser var1, GeoUtils.EffectivePoint var2) throws IOException;
    }
}

