/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import java.lang.reflect.InvocationTargetException;
import org.elasticsearch.common.inject.ConstructionProxy;
import org.elasticsearch.common.inject.MembersInjectorImpl;
import org.elasticsearch.common.inject.SingleParameterInjector;
import org.elasticsearch.common.inject.internal.ConstructionContext;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.ErrorsException;
import org.elasticsearch.common.inject.internal.InternalContext;

class ConstructorInjector<T> {
    private final SingleParameterInjector<?>[] parameterInjectors;
    private final ConstructionProxy<T> constructionProxy;
    private final MembersInjectorImpl<T> membersInjector;

    ConstructorInjector(ConstructionProxy<T> constructionProxy, SingleParameterInjector<?>[] parameterInjectors, MembersInjectorImpl<T> membersInjector) {
        this.constructionProxy = constructionProxy;
        this.parameterInjectors = parameterInjectors;
        this.membersInjector = membersInjector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object construct(Errors errors, InternalContext context, Class<?> expectedType) throws ErrorsException {
        ConstructionContext constructionContext = context.getConstructionContext(this);
        if (constructionContext.isConstructing()) {
            return constructionContext.createProxy(errors, expectedType);
        }
        Object t = constructionContext.getCurrentReference();
        if (t != null) {
            return t;
        }
        try {
            Object parameters;
            constructionContext.startConstruction();
            try {
                parameters = SingleParameterInjector.getAll(errors, context, this.parameterInjectors);
                t = this.constructionProxy.newInstance(parameters);
                constructionContext.setProxyDelegates(t);
            }
            finally {
                constructionContext.finishConstruction();
            }
            constructionContext.setCurrentReference(t);
            this.membersInjector.injectMembers(t, errors, context);
            this.membersInjector.notifyListeners(t, errors);
            parameters = t;
            return parameters;
        }
        catch (InvocationTargetException userException) {
            Throwable cause = userException.getCause() != null ? userException.getCause() : userException;
            throw errors.withSource(this.constructionProxy.getInjectionPoint()).errorInjectingConstructor(cause).toException();
        }
        finally {
            constructionContext.removeCurrentReference();
        }
    }
}

