/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class NoRewriteMatchNoDocsQuery
extends Query {
    private final String reason;

    public NoRewriteMatchNoDocsQuery(String reason) {
        this.reason = reason;
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new Weight(this){

            public Explanation explain(LeafReaderContext context, int doc) {
                return Explanation.noMatch((String)NoRewriteMatchNoDocsQuery.this.reason, (Explanation[])new Explanation[0]);
            }

            public Scorer scorer(LeafReaderContext context) {
                return null;
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }

            public int count(LeafReaderContext context) {
                return 0;
            }
        };
    }

    public String toString(String field) {
        return "NoRewriteMatchNoDocsQuery(" + this.reason + ")";
    }

    public void visit(QueryVisitor visitor) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof NoRewriteMatchNoDocsQuery)) return false;
        NoRewriteMatchNoDocsQuery q = (NoRewriteMatchNoDocsQuery)((Object)obj);
        if (!Objects.equals(this.reason, q.reason)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hashCode(this.reason);
    }
}

