/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class StatelessSecureSettings
implements SecureSettings {
    static final String PREFIX = "insecure.";
    static final Setting.AffixSetting<String> STATELESS_SECURE_SETTINGS = Setting.prefixKeySetting("insecure.", key -> Setting.simpleString(key, Setting.Property.NodeScope));
    private final Settings settings;
    private final Set<String> names;

    private StatelessSecureSettings(Settings settings) {
        if (!DiscoveryNode.isStateless(settings)) {
            throw new IllegalArgumentException("StatelessSecureSettings are supported only in stateless");
        }
        this.settings = Settings.builder().put(settings, false).build();
        this.names = settings.keySet().stream().filter(key -> key.startsWith(PREFIX)).map(s -> s.replace(PREFIX, "")).collect(Collectors.toUnmodifiableSet());
    }

    public static Settings install(Settings settings) {
        StatelessSecureSettings statelessSecureSettings = new StatelessSecureSettings(settings);
        return Settings.builder().put(settings, false).setSecureSettings(statelessSecureSettings).build();
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public Set<String> getSettingNames() {
        return this.names;
    }

    @Override
    public SecureString getString(String setting) {
        return new SecureString(STATELESS_SECURE_SETTINGS.getConcreteSetting(PREFIX + setting).get(this.settings).toCharArray());
    }

    @Override
    public InputStream getFile(String setting) throws GeneralSecurityException {
        return new ByteArrayInputStream(STATELESS_SECURE_SETTINGS.getConcreteSetting(PREFIX + setting).get(this.settings).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public byte[] getSHA256Digest(String setting) {
        return MessageDigests.sha256().digest(STATELESS_SECURE_SETTINGS.getConcreteSetting(PREFIX + setting).get(this.settings).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        throw new IllegalStateException("Unsupported operation");
    }
}

