/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import org.apache.lucene.util.hppc.BitMixer;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.Releasable;

abstract class AbstractPagedHashMap
implements Releasable {
    static final float DEFAULT_MAX_LOAD_FACTOR = 0.6f;
    final BigArrays bigArrays;
    final float maxLoadFactor;
    long size;
    long maxSize;
    long mask;

    static long hash(long value) {
        return BitMixer.mix64((long)value);
    }

    AbstractPagedHashMap(long capacity, float maxLoadFactor, BigArrays bigArrays) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("capacity must be >= 0");
        }
        if (maxLoadFactor <= 0.0f || maxLoadFactor >= 1.0f) {
            throw new IllegalArgumentException("maxLoadFactor must be > 0 and < 1");
        }
        this.bigArrays = bigArrays;
        this.maxLoadFactor = maxLoadFactor;
        long buckets = 1L + (long)((float)capacity / maxLoadFactor);
        buckets = Math.max(1L, Long.highestOneBit(buckets - 1L) << 1);
        assert (buckets == Long.highestOneBit(buckets));
        this.maxSize = (long)((float)buckets * maxLoadFactor);
        assert (this.maxSize >= capacity);
        this.size = 0L;
        this.mask = buckets - 1L;
    }

    public long capacity() {
        return this.mask + 1L;
    }

    public long size() {
        return this.size;
    }

    static long slot(long hash, long mask) {
        return hash & mask;
    }

    static long nextSlot(long curSlot, long mask) {
        return curSlot + 1L & mask;
    }

    protected abstract void resize(long var1);

    protected abstract boolean used(long var1);

    protected abstract void removeAndAdd(long var1);

    protected final void grow() {
        long i;
        assert (this.size == this.maxSize);
        long prevSize = this.size;
        long buckets = this.capacity();
        long newBuckets = buckets << 1;
        assert (newBuckets == Long.highestOneBit(newBuckets)) : newBuckets;
        this.resize(newBuckets);
        this.mask = newBuckets - 1L;
        for (i = 0L; i < buckets; ++i) {
            if (!this.used(i)) continue;
            this.removeAndAdd(i);
        }
        for (i = buckets; i < newBuckets && this.used(i); ++i) {
            this.removeAndAdd(i);
        }
        assert (this.size == prevSize);
        this.maxSize = (long)((float)newBuckets * this.maxLoadFactor);
        assert (this.size < this.maxSize);
    }
}

