/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.concurrent.atomic.AtomicInteger;

public final class CountDown {
    private final AtomicInteger countDown;

    public CountDown(int count) {
        assert (count > 0) : "count must be positive";
        if (count < 0) {
            throw new IllegalArgumentException("count must be greater or equal to 0 but was: " + count);
        }
        this.countDown = new AtomicInteger(count);
    }

    private static int assertValidCount(int count) {
        assert (count >= 0) : count;
        return count;
    }

    public boolean countDown() {
        return this.countDown.getAndUpdate(current -> CountDown.assertValidCount(current) == 0 ? 0 : current - 1) == 1;
    }

    public boolean fastForward() {
        return CountDown.assertValidCount(this.countDown.getAndSet(0)) > 0;
    }

    public boolean isCountedDown() {
        return CountDown.assertValidCount(this.countDown.get()) == 0;
    }
}

