/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health.node;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.health.node.DiskHealthInfo;
import org.elasticsearch.health.node.HealthInfo;
import org.elasticsearch.health.node.selection.HealthNode;

public class HealthInfoCache
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(HealthInfoCache.class);
    private volatile ConcurrentHashMap<String, DiskHealthInfo> diskInfoByNode = new ConcurrentHashMap();

    private HealthInfoCache() {
    }

    public static HealthInfoCache create(ClusterService clusterService) {
        HealthInfoCache healthInfoCache = new HealthInfoCache();
        clusterService.addListener(healthInfoCache);
        return healthInfoCache;
    }

    public void updateNodeHealth(String nodeId, DiskHealthInfo diskHealthInfo) {
        this.diskInfoByNode.put(nodeId, diskHealthInfo);
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        DiscoveryNode currentHealthNode = HealthNode.findHealthNode(event.state());
        DiscoveryNode localNode = event.state().nodes().getLocalNode();
        if (currentHealthNode != null && localNode.getId().equals(currentHealthNode.getId())) {
            if (event.nodesRemoved()) {
                for (DiscoveryNode removedNode : event.nodesDelta().removedNodes()) {
                    this.diskInfoByNode.remove(removedNode.getId());
                }
            }
        } else if (!this.diskInfoByNode.isEmpty()) {
            logger.debug("Node [{}][{}] is no longer the health node, emptying the cache.", (Object)localNode.getName(), (Object)localNode.getId());
            this.diskInfoByNode = new ConcurrentHashMap();
        }
    }

    public HealthInfo getHealthInfo() {
        return new HealthInfo(Map.copyOf(this.diskInfoByNode));
    }
}

