/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health.node.action;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.health.node.action.HealthNodeNotDiscoveredException;
import org.elasticsearch.health.node.action.HealthNodeRequest;
import org.elasticsearch.health.node.selection.HealthNode;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public abstract class TransportHealthNodeAction<Request extends HealthNodeRequest, Response extends ActionResponse>
extends HandledTransportAction<Request, Response> {
    private static final Logger logger = LogManager.getLogger(TransportHealthNodeAction.class);
    public static final Setting<TimeValue> HEALTH_NODE_TRANSPORT_ACTION_TIMEOUT = Setting.timeSetting("health_node.transport_action_timeout", TimeValue.timeValueSeconds((long)5L), TimeValue.timeValueMillis((long)1L), Setting.Property.NodeScope, Setting.Property.Dynamic);
    protected final TransportService transportService;
    protected final ClusterService clusterService;
    protected final ThreadPool threadPool;
    protected final String executor;
    private TimeValue healthNodeTransportActionTimeout;
    private final Writeable.Reader<Response> responseReader;

    protected TransportHealthNodeAction(String actionName, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, Writeable.Reader<Request> request, Writeable.Reader<Response> response, String executor) {
        super(actionName, true, transportService, actionFilters, request);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.executor = executor;
        this.responseReader = response;
        this.healthNodeTransportActionTimeout = HEALTH_NODE_TRANSPORT_ACTION_TIMEOUT.get(clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(HEALTH_NODE_TRANSPORT_ACTION_TIMEOUT, newTimeout -> {
            this.healthNodeTransportActionTimeout = newTimeout;
        });
    }

    protected abstract void healthOperation(Task var1, Request var2, ClusterState var3, ActionListener<Response> var4) throws Exception;

    @Override
    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        ClusterState state = this.clusterService.state();
        logger.trace("starting to process request [{}] with cluster state version [{}]", request, (Object)state.version());
        if (this.isTaskCancelled(task)) {
            listener.onFailure(new TaskCancelledException("Task was cancelled"));
            return;
        }
        try {
            ClusterState clusterState = this.clusterService.state();
            final DiscoveryNode healthNode = HealthNode.findHealthNode(clusterState);
            DiscoveryNode localNode = clusterState.nodes().getLocalNode();
            if (healthNode == null) {
                listener.onFailure(new HealthNodeNotDiscoveredException());
            } else if (localNode.getId().equals(healthNode.getId())) {
                this.threadPool.executor(this.executor).execute(() -> {
                    try {
                        if (this.isTaskCancelled(task)) {
                            listener.onFailure(new TaskCancelledException("Task was cancelled"));
                        } else {
                            this.healthOperation(task, request, clusterState, listener);
                        }
                    }
                    catch (Exception e) {
                        listener.onFailure(e);
                    }
                });
            } else {
                logger.trace("forwarding request [{}] to health node [{}]", (Object)this.actionName, (Object)healthNode);
                ActionListenerResponseHandler handler = new ActionListenerResponseHandler<Response>(listener, this.responseReader){

                    @Override
                    public void handleException(TransportException exception) {
                        logger.trace(() -> Strings.format((String)"failure when forwarding request [%s] to health node [%s]", (Object[])new Object[]{TransportHealthNodeAction.this.actionName, healthNode}), (Throwable)exception);
                        this.listener.onFailure(exception);
                    }
                };
                if (task != null) {
                    this.transportService.sendChildRequest(healthNode, this.actionName, (TransportRequest)request, task, TransportRequestOptions.timeout(this.healthNodeTransportActionTimeout), handler);
                } else {
                    this.transportService.sendRequest(healthNode, this.actionName, (TransportRequest)request, handler);
                }
            }
        }
        catch (Exception e) {
            logger.trace(() -> Strings.format((String)"Failed to route/execute health node action %s", (Object[])new Object[]{this.actionName}), (Throwable)e);
            listener.onFailure(e);
        }
    }

    private boolean isTaskCancelled(Task task) {
        CancellableTask t;
        return task instanceof CancellableTask && (t = (CancellableTask)task).isCancelled();
    }
}

