/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import java.util.List;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.http.HttpResponse;
import org.elasticsearch.rest.ChunkedRestResponseBody;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;

public interface HttpRequest {
    public RestRequest.Method method();

    public String uri();

    public BytesReference content();

    public Map<String, List<String>> getHeaders();

    default public String header(String name) {
        List<String> values = this.getHeaders().get(name);
        if (values != null && !values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    public List<String> strictCookies();

    public HttpVersion protocolVersion();

    public HttpRequest removeHeader(String var1);

    public HttpResponse createResponse(RestStatus var1, BytesReference var2);

    public HttpResponse createResponse(RestStatus var1, ChunkedRestResponseBody var2);

    @Nullable
    public Exception getInboundException();

    public void release();

    public HttpRequest releaseAndCopy();

    public static enum HttpVersion {
        HTTP_1_0,
        HTTP_1_1;

    }
}

