/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.tsdb;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.elasticsearch.index.codec.tsdb.ForUtil;

public class DocValuesForUtil {
    private final ForUtil forUtil = new ForUtil();
    private final int blockSize;

    public DocValuesForUtil() {
        this(128);
    }

    public DocValuesForUtil(int blockSize) {
        this.blockSize = blockSize;
    }

    void encode(long[] in, int bitsPerValue, DataOutput out) throws IOException {
        if (bitsPerValue <= 24) {
            this.forUtil.encode(in, bitsPerValue, out);
        } else if (bitsPerValue <= 32) {
            DocValuesForUtil.collapse32(in);
            for (int i = 0; i < this.blockSize / 2; ++i) {
                out.writeLong(in[i]);
            }
        } else {
            for (long l : in) {
                out.writeLong(l);
            }
        }
    }

    void decode(int bitsPerValue, DataInput in, long[] out) throws IOException {
        if (bitsPerValue <= 24) {
            this.forUtil.decode(bitsPerValue, in, out);
        } else if (bitsPerValue <= 32) {
            in.readLongs(out, 0, this.blockSize / 2);
            DocValuesForUtil.expand32(out);
        } else {
            in.readLongs(out, 0, this.blockSize);
        }
    }

    private static void collapse32(long[] arr) {
        for (int i = 0; i < 64; ++i) {
            arr[i] = arr[i] << 32 | arr[64 + i];
        }
    }

    private static void expand32(long[] arr) {
        for (int i = 0; i < 64; ++i) {
            long l = arr[i];
            arr[i] = l >>> 32;
            arr[64 + i] = l & 0xFFFFFFFFL;
        }
    }
}

