/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.xcontent.XContentParser;

public abstract class AbstractPointGeometryFieldMapper<T>
extends AbstractGeometryFieldMapper<T> {
    protected final T nullValue;

    public static <T> FieldMapper.Parameter<T> nullValueParam(Function<FieldMapper, T> initializer, TriFunction<String, MappingParserContext, Object, T> parser, Supplier<T> def, FieldMapper.Serializer<T> serializer) {
        return new FieldMapper.Parameter<Object>("null_value", false, def, parser, initializer, serializer, Objects::toString);
    }

    protected AbstractPointGeometryFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, T nullValue, FieldMapper.CopyTo copyTo, AbstractGeometryFieldMapper.Parser<T> parser) {
        super(simpleName, mappedFieldType, ignoreMalformed, ignoreZValue, multiFields, copyTo, parser);
        this.nullValue = nullValue;
    }

    protected AbstractPointGeometryFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, AbstractGeometryFieldMapper.Parser<T> parser, OnScriptError onScriptError) {
        super(simpleName, mappedFieldType, multiFields, copyTo, parser, onScriptError);
        this.nullValue = null;
    }

    public T getNullValue() {
        return this.nullValue;
    }

    protected static abstract class PointParser<T>
    extends AbstractGeometryFieldMapper.Parser<T> {
        protected final String field;
        private final CheckedFunction<XContentParser, T, IOException> objectParser;
        private final T nullValue;
        private final boolean ignoreZValue;
        protected final boolean ignoreMalformed;

        protected PointParser(String field, CheckedFunction<XContentParser, T, IOException> objectParser, T nullValue, boolean ignoreZValue, boolean ignoreMalformed) {
            this.field = field;
            this.objectParser = objectParser;
            this.nullValue = nullValue == null ? null : this.validate(nullValue);
            this.ignoreZValue = ignoreZValue;
            this.ignoreMalformed = ignoreMalformed;
        }

        protected abstract T validate(T var1);

        protected abstract T createPoint(double var1, double var3);

        @Override
        public void parse(XContentParser parser, CheckedConsumer<T, IOException> consumer, Consumer<Exception> onMalformed) throws IOException {
            if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                XContentParser.Token token = parser.nextToken();
                if (token == XContentParser.Token.VALUE_NUMBER) {
                    double x = parser.doubleValue();
                    parser.nextToken();
                    double y = parser.doubleValue();
                    token = parser.nextToken();
                    if (token == XContentParser.Token.VALUE_NUMBER) {
                        if (!this.ignoreZValue) {
                            throw new ElasticsearchParseException("Exception parsing coordinates: found Z value [{}] but [ignore_z_value] parameter is [{}]", parser.doubleValue(), this.ignoreZValue);
                        }
                    } else if (token != XContentParser.Token.END_ARRAY) {
                        throw new ElasticsearchParseException("field type does not accept > 3 dimensions", new Object[0]);
                    }
                    T point = this.createPoint(x, y);
                    consumer.accept(this.validate(point));
                } else {
                    while (token != XContentParser.Token.END_ARRAY) {
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
                            if (this.nullValue != null) {
                                consumer.accept(this.nullValue);
                            }
                        } else {
                            this.parseAndConsumeFromObject(parser, consumer, onMalformed);
                        }
                        token = parser.nextToken();
                    }
                }
            } else if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
                if (this.nullValue != null) {
                    consumer.accept(this.nullValue);
                }
            } else {
                this.parseAndConsumeFromObject(parser, consumer, onMalformed);
            }
        }

        private void parseAndConsumeFromObject(XContentParser parser, CheckedConsumer<T, IOException> consumer, Consumer<Exception> onMalformed) {
            try {
                Object point = this.objectParser.apply((Object)parser);
                consumer.accept(this.validate(point));
            }
            catch (Exception e) {
                onMalformed.accept(e);
            }
        }
    }
}

