/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.Version;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.support.AbstractXContentParser;

public abstract class FieldMapper
extends Mapper
implements Cloneable {
    private static final Logger logger = LogManager.getLogger(FieldMapper.class);
    public static final Setting<Boolean> IGNORE_MALFORMED_SETTING = Setting.boolSetting("index.mapping.ignore_malformed", false, Setting.Property.IndexScope);
    public static final Setting<Boolean> COERCE_SETTING = Setting.boolSetting("index.mapping.coerce", false, Setting.Property.IndexScope);
    protected static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(FieldMapper.class);
    static final Parameter<?>[] EMPTY_PARAMETERS = new Parameter[0];
    protected final MappedFieldType mappedFieldType;
    protected final MultiFields multiFields;
    protected final CopyTo copyTo;
    protected final boolean hasScript;
    protected final OnScriptError onScriptError;

    protected FieldMapper(String simpleName, MappedFieldType mappedFieldType, MultiFields multiFields, CopyTo copyTo) {
        this(simpleName, mappedFieldType, multiFields, copyTo, false, null);
    }

    protected FieldMapper(String simpleName, MappedFieldType mappedFieldType, MultiFields multiFields, CopyTo copyTo, boolean hasScript, OnScriptError onScriptError) {
        super(simpleName);
        assert (!mappedFieldType.name().isEmpty());
        this.mappedFieldType = mappedFieldType;
        this.multiFields = multiFields;
        this.copyTo = Objects.requireNonNull(copyTo);
        this.hasScript = hasScript;
        this.onScriptError = onScriptError;
    }

    @Override
    public String name() {
        return this.fieldType().name();
    }

    @Override
    public String typeName() {
        return this.mappedFieldType.typeName();
    }

    public MappedFieldType fieldType() {
        return this.mappedFieldType;
    }

    public CopyTo copyTo() {
        return this.copyTo;
    }

    public MultiFields multiFields() {
        return this.multiFields;
    }

    public boolean ignoreMalformed() {
        return false;
    }

    public boolean parsesArrayValue() {
        return false;
    }

    public void parse(DocumentParserContext context) throws IOException {
        try {
            if (this.hasScript) {
                FieldMapper.throwIndexingWithScriptParam();
            }
            this.parseCreateField(context);
        }
        catch (Exception e) {
            this.rethrowAsMapperParsingException(context, e);
        }
        if (this.multiFields.mappers.length != 0) {
            this.doParseMultiFields(context);
        }
    }

    private void doParseMultiFields(DocumentParserContext context) throws IOException {
        context.path().add(this.simpleName());
        for (FieldMapper mapper : this.multiFields.mappers) {
            mapper.parse(context);
        }
        context.path().remove();
    }

    private static void throwIndexingWithScriptParam() {
        throw new IllegalArgumentException("Cannot index data directly into a field with a [script] parameter");
    }

    private void rethrowAsMapperParsingException(DocumentParserContext context, Exception e) {
        String valuePreview;
        try {
            XContentParser parser = context.parser();
            Object complexValue = AbstractXContentParser.readValue((XContentParser)parser, HashMap::new);
            valuePreview = complexValue == null ? "null" : complexValue.toString();
        }
        catch (Exception innerException) {
            throw new MapperParsingException("failed to parse field [{}] of type [{}] in {}. Could not parse field value preview,", (Throwable)e, this.fieldType().name(), this.fieldType().typeName(), context.documentDescription());
        }
        throw new MapperParsingException("failed to parse field [{}] of type [{}] in {}. Preview of field's value: '{}'", (Throwable)e, this.fieldType().name(), this.fieldType().typeName(), context.documentDescription(), valuePreview);
    }

    protected abstract void parseCreateField(DocumentParserContext var1) throws IOException;

    public final boolean hasScript() {
        return this.hasScript;
    }

    public final void executeScript(SearchLookup searchLookup, LeafReaderContext readerContext, int doc, DocumentParserContext documentParserContext) {
        try {
            this.indexScriptValues(searchLookup, readerContext, doc, documentParserContext);
        }
        catch (Exception e) {
            if (this.onScriptError == OnScriptError.CONTINUE) {
                documentParserContext.addIgnoredField(this.name());
            }
            throw new MapperParsingException("Error executing script on field [" + this.name() + "]", e);
        }
    }

    protected void indexScriptValues(SearchLookup searchLookup, LeafReaderContext readerContext, int doc, DocumentParserContext documentParserContext) {
        throw new UnsupportedOperationException("FieldMapper " + this.name() + " does not support [script]");
    }

    @Override
    public Iterator<Mapper> iterator() {
        return Iterators.forArray(this.multiFields.mappers);
    }

    @Override
    public final void validate(MappingLookup mappers) {
        if (this.copyTo() != null && !this.copyTo().copyToFields().isEmpty()) {
            if (mappers.isMultiField(this.name())) {
                throw new IllegalArgumentException("[copy_to] may not be used to copy from a multi-field: [" + this.name() + "]");
            }
            String sourceScope = mappers.nestedLookup().getNestedParent(this.name());
            for (String copyTo : this.copyTo().copyToFields()) {
                if (mappers.isMultiField(copyTo)) {
                    throw new IllegalArgumentException("[copy_to] may not be used to copy to a multi-field: [" + copyTo + "]");
                }
                if (mappers.isObjectField(copyTo)) {
                    throw new IllegalArgumentException("Cannot copy to field [" + copyTo + "] since it is mapped as an object");
                }
                String targetScope = mappers.nestedLookup().getNestedParent(copyTo);
                FieldMapper.checkNestedScopeCompatibility(sourceScope, targetScope);
            }
        }
        for (FieldMapper multiField : this.multiFields().mappers) {
            ((Mapper)multiField).validate(mappers);
        }
        this.doValidate(mappers);
    }

    protected void doValidate(MappingLookup mappers) {
    }

    private static void checkNestedScopeCompatibility(String source, String target) {
        boolean targetIsParentOfSource;
        if (source == null || target == null) {
            targetIsParentOfSource = target == null;
        } else {
            boolean bl = targetIsParentOfSource = source.equals(target) || source.startsWith(target + ".");
        }
        if (!targetIsParentOfSource) {
            throw new IllegalArgumentException("Illegal combination of [copy_to] and [nested] mappings: [copy_to] may only copy data to the current nested document or any of its parents, however one [copy_to] directive is trying to copy data from nested object [" + source + "] to [" + target + "]");
        }
    }

    public abstract Builder getMergeBuilder();

    @Override
    public final FieldMapper merge(Mapper mergeWith, MapperBuilderContext mapperBuilderContext) {
        if (mergeWith == this) {
            return this;
        }
        if (!(mergeWith instanceof FieldMapper)) {
            throw new IllegalArgumentException("mapper [" + this.name() + "] cannot be changed from type [" + this.contentType() + "] to [" + mergeWith.getClass().getSimpleName() + "]");
        }
        this.checkIncomingMergeType((FieldMapper)mergeWith);
        Builder builder = this.getMergeBuilder();
        if (builder == null) {
            return (FieldMapper)mergeWith;
        }
        Conflicts conflicts = new Conflicts(this.name());
        builder.merge((FieldMapper)mergeWith, conflicts, mapperBuilderContext);
        conflicts.check();
        return builder.build(mapperBuilderContext);
    }

    protected void checkIncomingMergeType(FieldMapper mergeWith) {
        if (!Objects.equals(this.getClass(), mergeWith.getClass())) {
            throw new IllegalArgumentException("mapper [" + this.name() + "] cannot be changed from type [" + this.contentType() + "] to [" + mergeWith.contentType() + "]");
        }
        if (!Objects.equals(this.contentType(), mergeWith.contentType())) {
            throw new IllegalArgumentException("mapper [" + this.name() + "] cannot be changed from type [" + this.contentType() + "] to [" + mergeWith.contentType() + "]");
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.simpleName());
        this.doXContentBody(builder, params);
        return builder.endObject();
    }

    protected void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("type", this.contentType());
        this.getMergeBuilder().toXContent(builder, params);
        this.multiFields.toXContent(builder, params);
        this.copyTo.toXContent(builder);
    }

    protected abstract String contentType();

    public Map<String, NamedAnalyzer> indexAnalyzers() {
        return Map.of();
    }

    public static BiConsumer<String, MappingParserContext> notInMultiFields(String type) {
        return (n, c) -> {
            if (c.isWithinMultiField()) {
                throw new MapperParsingException("Field [" + n + "] of type [" + type + "] can't be used in multifields");
            }
        };
    }

    public static final class MultiFields
    implements Iterable<FieldMapper>,
    ToXContent {
        private static final MultiFields EMPTY = new MultiFields(new FieldMapper[0]);
        private final FieldMapper[] mappers;

        public static MultiFields empty() {
            return EMPTY;
        }

        private MultiFields(FieldMapper[] mappers) {
            this.mappers = mappers;
            Arrays.sort(this.mappers, Comparator.comparing(FieldMapper::name));
        }

        public void parse(FieldMapper mainField, DocumentParserContext context, Supplier<DocumentParserContext> multiFieldContextSupplier) throws IOException {
            if (this.mappers.length == 0) {
                return;
            }
            context.path().add(mainField.simpleName());
            for (FieldMapper mapper : this.mappers) {
                mapper.parse(multiFieldContextSupplier.get());
            }
            context.path().remove();
        }

        @Override
        public Iterator<FieldMapper> iterator() {
            return Iterators.forArray(this.mappers);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.mappers.length != 0) {
                builder.startObject("fields");
                for (FieldMapper mapper : this.mappers) {
                    mapper.toXContent(builder, params);
                }
                builder.endObject();
            }
            return builder;
        }

        public static class Builder {
            private final Map<String, Function<MapperBuilderContext, FieldMapper>> mapperBuilders = new HashMap<String, Function<MapperBuilderContext, FieldMapper>>();

            public Builder add(org.elasticsearch.index.mapper.FieldMapper$Builder builder) {
                this.mapperBuilders.put(builder.name(), builder::build);
                return this;
            }

            public Builder add(FieldMapper mapper) {
                this.mapperBuilders.put(mapper.simpleName(), context -> mapper);
                return this;
            }

            public Builder update(FieldMapper toMerge, MapperBuilderContext context) {
                if (!this.mapperBuilders.containsKey(toMerge.simpleName())) {
                    this.add(toMerge);
                } else {
                    FieldMapper existing = this.mapperBuilders.get(toMerge.simpleName()).apply(context);
                    this.add(existing.merge(toMerge, context));
                }
                return this;
            }

            public boolean hasMultiFields() {
                return !this.mapperBuilders.isEmpty();
            }

            public MultiFields build(Mapper.Builder mainFieldBuilder, MapperBuilderContext context) {
                if (this.mapperBuilders.isEmpty()) {
                    return MultiFields.empty();
                }
                FieldMapper[] mappers = new FieldMapper[this.mapperBuilders.size()];
                context = context.createChildContext(mainFieldBuilder.name());
                int i = 0;
                for (Map.Entry<String, Function<MapperBuilderContext, FieldMapper>> entry : this.mapperBuilders.entrySet()) {
                    mappers[i++] = entry.getValue().apply(context);
                }
                return new MultiFields(mappers);
            }
        }
    }

    public static class CopyTo {
        private static final CopyTo EMPTY = new CopyTo(Collections.emptyList());
        private final List<String> copyToFields;

        public static CopyTo empty() {
            return EMPTY;
        }

        private CopyTo(List<String> copyToFields) {
            this.copyToFields = copyToFields;
        }

        public XContentBuilder toXContent(XContentBuilder builder) throws IOException {
            if (!this.copyToFields.isEmpty()) {
                builder.startArray("copy_to");
                for (String field : this.copyToFields) {
                    builder.value(field);
                }
                builder.endArray();
            }
            return builder;
        }

        public List<String> copyToFields() {
            return this.copyToFields;
        }

        public static class Builder {
            private final List<String> copyToBuilders = new ArrayList<String>();

            public Builder add(String field) {
                this.copyToBuilders.add(field);
                return this;
            }

            public boolean hasValues() {
                return !this.copyToBuilders.isEmpty();
            }

            public CopyTo build() {
                if (this.copyToBuilders.isEmpty()) {
                    return EMPTY;
                }
                return new CopyTo(Collections.unmodifiableList(this.copyToBuilders));
            }

            public void reset(CopyTo copyTo) {
                this.copyToBuilders.clear();
                this.copyToBuilders.addAll(copyTo.copyToFields);
            }
        }
    }

    public static abstract class Builder
    extends Mapper.Builder
    implements ToXContentFragment {
        protected final MultiFields.Builder multiFieldsBuilder = new MultiFields.Builder();
        protected final CopyTo.Builder copyTo = new CopyTo.Builder();
        private static final Set<String> DEPRECATED_PARAMS = Set.of("store", "meta", "index", "doc_values", "index_options", "similarity");

        protected Builder(String name) {
            super(name);
        }

        public Builder init(FieldMapper initializer) {
            for (Parameter<?> param : this.getParameters()) {
                param.init(initializer);
            }
            for (FieldMapper subField : initializer.multiFields.mappers) {
                this.multiFieldsBuilder.add(subField);
            }
            return this;
        }

        protected void merge(FieldMapper in, Conflicts conflicts, MapperBuilderContext mapperBuilderContext) {
            for (Parameter<?> param : this.getParameters()) {
                param.merge(in, conflicts);
            }
            MapperBuilderContext childContext = mapperBuilderContext.createChildContext(in.simpleName());
            for (FieldMapper newSubField : in.multiFields.mappers) {
                this.multiFieldsBuilder.update(newSubField, childContext);
            }
            this.copyTo.reset(in.copyTo);
            this.validate();
        }

        protected final void validate() {
            for (Parameter<?> param : this.getParameters()) {
                param.validate();
            }
        }

        protected abstract Parameter<?>[] getParameters();

        @Override
        public abstract FieldMapper build(MapperBuilderContext var1);

        protected void addScriptValidation(Parameter<Script> scriptParam, Parameter<Boolean> indexParam, Parameter<Boolean> docValuesParam) {
            scriptParam.addValidator(s -> {
                if (s != null && !((Boolean)indexParam.get()).booleanValue() && !((Boolean)docValuesParam.get()).booleanValue()) {
                    throw new MapperParsingException("Cannot define script on field with index:false and doc_values:false");
                }
                if (s != null && this.multiFieldsBuilder.hasMultiFields()) {
                    throw new MapperParsingException("Cannot define multifields on a field with a script");
                }
                if (s != null && this.copyTo.hasValues()) {
                    throw new MapperParsingException("Cannot define copy_to parameter on a field with a script");
                }
            });
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
            for (Parameter<?> parameter : this.getParameters()) {
                parameter.toXContent(builder, includeDefaults);
            }
            return builder;
        }

        public final void parse(String name, MappingParserContext parserContext, Map<String, Object> fieldNode) {
            Parameter<?>[] params = this.getParameters();
            Map<String, Parameter<?>> paramsMap = Maps.newHashMapWithExpectedSize(params.length);
            HashMap deprecatedParamsMap = new HashMap();
            for (Parameter<?> param : params) {
                paramsMap.put(param.name, param);
                for (String deprecatedName : param.deprecatedNames) {
                    deprecatedParamsMap.put(deprecatedName, param);
                }
            }
            String type = (String)fieldNode.remove("type");
            Iterator<Map.Entry<String, Object>> iterator = fieldNode.entrySet().iterator();
            block12: while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                switch (propName) {
                    case "fields": {
                        TypeParsers.parseMultiField(this.multiFieldsBuilder::add, name, parserContext, propName, propNode);
                        iterator.remove();
                        continue block12;
                    }
                    case "copy_to": {
                        TypeParsers.parseCopyFields(propNode).forEach(this.copyTo::add);
                        iterator.remove();
                        continue block12;
                    }
                    case "boost": {
                        if (parserContext.indexVersionCreated().onOrAfter(Version.V_8_0_0)) {
                            throw new MapperParsingException("Unknown parameter [boost] on mapper [" + name + "]");
                        }
                        deprecationLogger.warn(DeprecationCategory.API, "boost", "Parameter [boost] on field [{}] is deprecated and has no effect", name);
                        iterator.remove();
                        continue block12;
                    }
                }
                Parameter parameter = (Parameter)deprecatedParamsMap.get(propName);
                if (parameter != null) {
                    deprecationLogger.warn(DeprecationCategory.API, propName, "Parameter [{}] on mapper [{}] is deprecated, use [{}]", propName, name, parameter.name);
                } else {
                    parameter = (Parameter)paramsMap.get(propName);
                }
                if (parameter == null) {
                    if (parserContext.indexVersionCreated().isLegacyIndexVersion()) {
                        this.handleUnknownParamOnLegacyIndex(propName, propNode);
                        iterator.remove();
                        continue;
                    }
                    if (Builder.isDeprecatedParameter(propName, parserContext.indexVersionCreated())) {
                        deprecationLogger.warn(DeprecationCategory.API, propName, "Parameter [{}] has no effect on type [{}] and will be removed in future", propName, type);
                        iterator.remove();
                        continue;
                    }
                    if (parserContext.isFromDynamicTemplate() && parserContext.indexVersionCreated().before(Version.V_8_0_0)) {
                        deprecationLogger.warn(DeprecationCategory.API, propName, "Parameter [{}] is used in a dynamic template mapping and has no effect on type [{}]. Usage will result in an error in future major versions and should be removed.", propName, type);
                        iterator.remove();
                        continue;
                    }
                    throw new MapperParsingException("unknown parameter [" + propName + "] on mapper [" + name + "] of type [" + type + "]");
                }
                if (parameter.deprecated) {
                    deprecationLogger.warn(DeprecationCategory.API, propName, "Parameter [{}] is deprecated and will be removed in a future version", propName);
                }
                if (propNode == null && !parameter.acceptsNull) {
                    throw new MapperParsingException("[" + propName + "] on mapper [" + name + "] of type [" + type + "] must not have a [null] value");
                }
                parameter.parse(name, parserContext, propNode);
                iterator.remove();
            }
            this.validate();
        }

        protected void handleUnknownParamOnLegacyIndex(String propName, Object propNode) {
        }

        private static boolean isDeprecatedParameter(String propName, Version indexCreatedVersion) {
            if (indexCreatedVersion.onOrAfter(Version.V_8_0_0)) {
                return false;
            }
            return DEPRECATED_PARAMS.contains(propName);
        }
    }

    public static final class Conflicts {
        private final String mapperName;
        private final List<String> conflicts = new ArrayList<String>();

        Conflicts(String mapperName) {
            this.mapperName = mapperName;
        }

        public void addConflict(String parameter, String conflict) {
            this.conflicts.add("Conflict in parameter [" + parameter + "]: " + conflict);
        }

        void addConflict(String parameter, String existing, String toMerge) {
            this.conflicts.add("Cannot update parameter [" + parameter + "] from [" + existing + "] to [" + toMerge + "]");
        }

        void check() {
            if (this.conflicts.isEmpty()) {
                return;
            }
            String message = "Mapper for [" + this.mapperName + "] conflicts with existing mapper:\n\t" + String.join((CharSequence)"\n\t", this.conflicts);
            throw new IllegalArgumentException(message);
        }
    }

    public static final class Parameter<T>
    implements Supplier<T> {
        public final String name;
        private List<String> deprecatedNames = List.of();
        private final Supplier<T> defaultValue;
        private final TriFunction<String, MappingParserContext, Object, T> parser;
        private final Function<FieldMapper, T> initializer;
        private boolean acceptsNull = false;
        private Consumer<T> validator;
        private final Serializer<T> serializer;
        private SerializerCheck<T> serializerCheck = (includeDefaults, isConfigured, value) -> includeDefaults || isConfigured;
        private final Function<T, String> conflictSerializer;
        private boolean deprecated;
        private MergeValidator<T> mergeValidator;
        private T value;
        private boolean isSet;
        private List<Parameter<?>> requires = List.of();
        private List<Parameter<?>> precludes = List.of();

        public Parameter(String name, boolean updateable, Supplier<T> defaultValue, TriFunction<String, MappingParserContext, Object, T> parser, Function<FieldMapper, T> initializer, Serializer<T> serializer, Function<T, String> conflictSerializer) {
            this.name = name;
            this.defaultValue = Objects.requireNonNull(defaultValue);
            this.value = null;
            this.parser = parser;
            this.initializer = initializer;
            this.mergeValidator = updateable ? (previous, toMerge, conflicts) -> true : (previous, toMerge, conflicts) -> Objects.equals(previous, toMerge);
            this.serializer = serializer;
            this.conflictSerializer = conflictSerializer;
        }

        public T getValue() {
            return this.isSet ? this.value : this.getDefaultValue();
        }

        @Override
        public T get() {
            return this.getValue();
        }

        public T getDefaultValue() {
            return this.defaultValue.get();
        }

        public void setValue(T value) {
            this.isSet = true;
            this.value = value;
        }

        public boolean isConfigured() {
            return this.isSet && !Objects.equals(this.value, this.getDefaultValue());
        }

        public Parameter<T> acceptsNull() {
            this.acceptsNull = true;
            return this;
        }

        public boolean canAcceptNull() {
            return this.acceptsNull;
        }

        public Parameter<T> addDeprecatedName(String deprecatedName) {
            this.deprecatedNames = CollectionUtils.appendToCopyNoNullElements(this.deprecatedNames, deprecatedName);
            return this;
        }

        public Parameter<T> deprecated() {
            this.deprecated = true;
            return this;
        }

        public Parameter<T> addValidator(Consumer<T> validator) {
            this.validator = this.validator == null ? validator : this.validator.andThen(validator);
            return this;
        }

        public Parameter<T> setSerializerCheck(SerializerCheck<T> check) {
            this.serializerCheck = check;
            return this;
        }

        public Parameter<T> alwaysSerialize() {
            this.serializerCheck = (id, ic, v) -> true;
            return this;
        }

        public Parameter<T> neverSerialize() {
            this.serializerCheck = (id, ic, v) -> false;
            return this;
        }

        public Parameter<T> setMergeValidator(MergeValidator<T> mergeValidator) {
            this.mergeValidator = mergeValidator;
            return this;
        }

        public Parameter<T> requiresParameter(Parameter<?> ps) {
            this.requires = CollectionUtils.appendToCopyNoNullElements(this.requires, ps);
            return this;
        }

        public Parameter<T> precludesParameters(Parameter<?> ... ps) {
            this.precludes = CollectionUtils.appendToCopyNoNullElements(this.precludes, ps);
            return this;
        }

        void validate() {
            if (this.validator != null) {
                this.validator.accept(this.getValue());
            }
            if (this.isConfigured()) {
                for (Parameter<?> p : this.requires) {
                    if (p.isConfigured()) continue;
                    throw new IllegalArgumentException("Field [" + this.name + "] requires field [" + p.name + "] to be configured");
                }
                for (Parameter<?> p : this.precludes) {
                    if (!p.isConfigured()) continue;
                    throw new IllegalArgumentException("Field [" + p.name + "] cannot be set in conjunction with field [" + this.name + "]");
                }
            }
        }

        private void init(FieldMapper toInit) {
            this.setValue(this.initializer.apply(toInit));
        }

        public void parse(String field, MappingParserContext context, Object in) {
            this.setValue(this.parser.apply(field, context, in));
        }

        private void merge(FieldMapper toMerge, Conflicts conflicts) {
            T value = this.initializer.apply(toMerge);
            T current = this.getValue();
            if (this.mergeValidator.canMerge(current, value, conflicts)) {
                this.setValue(value);
            } else {
                conflicts.addConflict(this.name, this.conflictSerializer.apply(current), this.conflictSerializer.apply(value));
            }
        }

        protected void toXContent(XContentBuilder builder, boolean includeDefaults) throws IOException {
            T value = this.getValue();
            if (this.serializerCheck.check(includeDefaults, this.isConfigured(), value)) {
                this.serializer.serialize(builder, this.name, value);
            }
        }

        public static Parameter<Boolean> boolParam(String name, boolean updateable, Function<FieldMapper, Boolean> initializer, boolean defaultValue) {
            return new Parameter<Boolean>(name, updateable, defaultValue ? () -> true : () -> false, (n, c, o) -> XContentMapValues.nodeBooleanValue(o), initializer, XContentBuilder::field, Objects::toString);
        }

        public static Parameter<Boolean> boolParam(String name, boolean updateable, Function<FieldMapper, Boolean> initializer, Supplier<Boolean> defaultValue) {
            return new Parameter<Boolean>(name, updateable, defaultValue, (n, c, o) -> XContentMapValues.nodeBooleanValue(o), initializer, XContentBuilder::field, Objects::toString);
        }

        public static Parameter<Explicit<Boolean>> explicitBoolParam(String name, boolean updateable, Function<FieldMapper, Explicit<Boolean>> initializer, boolean defaultValue) {
            return new Parameter<Explicit<Boolean>>(name, updateable, defaultValue ? () -> Explicit.IMPLICIT_TRUE : () -> Explicit.IMPLICIT_FALSE, (n, c, o) -> Explicit.explicitBoolean(XContentMapValues.nodeBooleanValue(o)), initializer, (b, n, v) -> b.field(n, (Boolean)v.value()), v -> Boolean.toString((Boolean)v.value()));
        }

        public static Parameter<Integer> intParam(String name, boolean updateable, Function<FieldMapper, Integer> initializer, int defaultValue) {
            return new Parameter<Integer>(name, updateable, () -> defaultValue, (n, c, o) -> XContentMapValues.nodeIntegerValue(o), initializer, XContentBuilder::field, Objects::toString);
        }

        public static Parameter<String> stringParam(String name, boolean updateable, Function<FieldMapper, String> initializer, String defaultValue) {
            return Parameter.stringParam(name, updateable, initializer, defaultValue, XContentBuilder::field);
        }

        public static Parameter<String> stringParam(String name, boolean updateable, Function<FieldMapper, String> initializer, String defaultValue, Serializer<String> serializer) {
            return new Parameter<String>(name, updateable, defaultValue == null ? () -> null : () -> defaultValue, (n, c, o) -> XContentMapValues.nodeStringValue(o), initializer, serializer, Function.identity());
        }

        public static Parameter<List<String>> stringArrayParam(String name, boolean updateable, Function<FieldMapper, List<String>> initializer) {
            return new Parameter<List<String>>(name, updateable, List::of, (n, c, o) -> {
                List values = (List)o;
                ArrayList<String> strValues = new ArrayList<String>();
                for (Object item : values) {
                    strValues.add(item.toString());
                }
                return strValues;
            }, initializer, XContentBuilder::stringListField, Objects::toString);
        }

        public static <T extends Enum<T>> Parameter<T> enumParam(String name, boolean updateable, Function<FieldMapper, T> initializer, T defaultValue, Class<T> enumClass) {
            EnumSet<T> acceptedValues = EnumSet.allOf(enumClass);
            return Parameter.restrictedEnumParam(name, updateable, initializer, defaultValue, enumClass, acceptedValues);
        }

        public static <T extends Enum<T>> Parameter<T> restrictedEnumParam(String name, boolean updateable, Function<FieldMapper, T> initializer, T defaultValue, Class<T> enumClass, Set<T> acceptedValues) {
            assert (acceptedValues.size() > 0);
            return new Parameter<Enum>(name, updateable, () -> defaultValue, (n, c, o) -> {
                if (o == null) {
                    return defaultValue;
                }
                EnumSet<Enum> enumSet = EnumSet.allOf(enumClass);
                for (Enum t : enumSet) {
                    if (!t.toString().equals(o.toString())) continue;
                    return t;
                }
                throw new MapperParsingException("Unknown value [" + o + "] for field [" + name + "] - accepted values are " + acceptedValues);
            }, initializer, XContentBuilder::field, Objects::toString).addValidator(v -> {
                if (v != null && !acceptedValues.contains(v)) {
                    throw new MapperParsingException("Unknown value [" + v + "] for field [" + name + "] - accepted values are " + acceptedValues);
                }
            });
        }

        public static Parameter<NamedAnalyzer> analyzerParam(String name, boolean updateable, Function<FieldMapper, NamedAnalyzer> initializer, Supplier<NamedAnalyzer> defaultAnalyzer, Version indexCreatedVersion) {
            return new Parameter<NamedAnalyzer>(name, updateable, defaultAnalyzer, (n, c, o) -> {
                String analyzerName = o.toString();
                NamedAnalyzer a = c.getIndexAnalyzers().get(analyzerName);
                if (a == null) {
                    if (indexCreatedVersion.isLegacyIndexVersion()) {
                        logger.warn(() -> Strings.format((String)"Could not find analyzer [%s] of legacy index, falling back to default", (Object[])new Object[]{analyzerName}));
                        a = (NamedAnalyzer)((Object)((Object)defaultAnalyzer.get()));
                    } else {
                        throw new IllegalArgumentException("analyzer [" + analyzerName + "] has not been configured in mappings");
                    }
                }
                return a;
            }, initializer, (b, n, v) -> b.field(n, v.name()), NamedAnalyzer::name);
        }

        public static Parameter<NamedAnalyzer> analyzerParam(String name, boolean updateable, Function<FieldMapper, NamedAnalyzer> initializer, Supplier<NamedAnalyzer> defaultAnalyzer) {
            return Parameter.analyzerParam(name, updateable, initializer, defaultAnalyzer, Version.CURRENT);
        }

        public static Parameter<Map<String, String>> metaParam() {
            return new Parameter<Map<String, String>>("meta", true, Collections::emptyMap, (n, c, o) -> TypeParsers.parseMeta(n, o), m -> m.fieldType().meta(), XContentBuilder::stringStringMap, Objects::toString);
        }

        public static Parameter<Boolean> indexParam(Function<FieldMapper, Boolean> initializer, boolean defaultValue) {
            return Parameter.boolParam("index", false, initializer, defaultValue);
        }

        public static Parameter<Boolean> indexParam(Function<FieldMapper, Boolean> initializer, Supplier<Boolean> defaultValue) {
            return Parameter.boolParam("index", false, initializer, defaultValue);
        }

        public static Parameter<Boolean> storeParam(Function<FieldMapper, Boolean> initializer, boolean defaultValue) {
            return Parameter.boolParam("store", false, initializer, defaultValue);
        }

        public static Parameter<Boolean> docValuesParam(Function<FieldMapper, Boolean> initializer, boolean defaultValue) {
            return Parameter.boolParam("doc_values", false, initializer, defaultValue);
        }

        public static Parameter<Script> scriptParam(Function<FieldMapper, Script> initializer) {
            return new Parameter<Script>("script", false, () -> null, (n, c, o) -> {
                if (o == null) {
                    return null;
                }
                Script script = Script.parse(o);
                if (script.getType() == ScriptType.STORED) {
                    throw new IllegalArgumentException("stored scripts are not supported on field [" + n + "]");
                }
                return script;
            }, initializer, XContentBuilder::field, Objects::toString).acceptsNull();
        }

        public static Parameter<OnScriptError> onScriptErrorParam(Function<FieldMapper, OnScriptError> initializer, Parameter<Script> dependentScriptParam) {
            return Parameter.enumParam("on_script_error", true, initializer, OnScriptError.FAIL, OnScriptError.class).requiresParameter(dependentScriptParam);
        }
    }

    public static final class TypeParser
    implements Mapper.TypeParser {
        private final BiFunction<String, MappingParserContext, Builder> builderFunction;
        private final BiConsumer<String, MappingParserContext> contextValidator;
        private final Version minimumCompatibilityVersion;

        public TypeParser(BiFunction<String, MappingParserContext, Builder> builderFunction) {
            this(builderFunction, (n, c) -> {}, Version.CURRENT.minimumIndexCompatibilityVersion());
        }

        public TypeParser(BiFunction<String, MappingParserContext, Builder> builderFunction, Version minimumCompatibilityVersion) {
            this(builderFunction, (n, c) -> {}, minimumCompatibilityVersion);
        }

        public TypeParser(BiFunction<String, MappingParserContext, Builder> builderFunction, BiConsumer<String, MappingParserContext> contextValidator) {
            this(builderFunction, contextValidator, Version.CURRENT.minimumIndexCompatibilityVersion());
        }

        private TypeParser(BiFunction<String, MappingParserContext, Builder> builderFunction, BiConsumer<String, MappingParserContext> contextValidator, Version minimumCompatibilityVersion) {
            this.builderFunction = builderFunction;
            this.contextValidator = contextValidator;
            this.minimumCompatibilityVersion = minimumCompatibilityVersion;
        }

        @Override
        public Builder parse(String name, Map<String, Object> node, MappingParserContext parserContext) throws MapperParsingException {
            this.contextValidator.accept(name, parserContext);
            Builder builder = this.builderFunction.apply(name, parserContext);
            builder.parse(name, parserContext, node);
            return builder;
        }

        @Override
        public boolean supportsVersion(Version indexCreatedVersion) {
            return indexCreatedVersion.onOrAfter(this.minimumCompatibilityVersion);
        }
    }

    public static interface SerializerCheck<T> {
        public boolean check(boolean var1, boolean var2, T var3);
    }

    protected static interface MergeValidator<T> {
        public boolean canMerge(T var1, T var2, Conflicts var3);
    }

    public static interface Serializer<T> {
        public void serialize(XContentBuilder var1, String var2, T var3) throws IOException;
    }
}

