/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.sandbox.search.DocValuesTermsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.MinimizationOperations;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.Version;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.AutomatonQueries;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.SourceValueFetcherSortedBinaryIndexFieldData;
import org.elasticsearch.index.fielddata.StoredFieldSortedBinaryIndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.index.mapper.SortedSetDocValuesSyntheticFieldLoader;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.StringStoredFieldFieldLoader;
import org.elasticsearch.index.mapper.TextParams;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.similarity.SimilarityProvider;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.script.SortedSetDocValuesStringFieldScript;
import org.elasticsearch.script.StringFieldScript;
import org.elasticsearch.script.field.KeywordDocValuesField;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.FieldValues;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceProvider;
import org.elasticsearch.search.runtime.StringScriptFieldFuzzyQuery;
import org.elasticsearch.search.runtime.StringScriptFieldPrefixQuery;
import org.elasticsearch.search.runtime.StringScriptFieldRegexpQuery;
import org.elasticsearch.search.runtime.StringScriptFieldTermQuery;
import org.elasticsearch.search.runtime.StringScriptFieldWildcardQuery;
import org.elasticsearch.xcontent.XContentBuilder;

public final class KeywordFieldMapper
extends FieldMapper {
    private static final Logger logger = LogManager.getLogger(KeywordFieldMapper.class);
    public static final String CONTENT_TYPE = "keyword";
    private static final Version MINIMUM_COMPATIBILITY_VERSION = Version.fromString("5.0.0");
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.getIndexAnalyzers(), c.scriptCompiler(), c.indexVersionCreated()), MINIMUM_COMPATIBILITY_VERSION);
    private final boolean indexed;
    private final boolean hasDocValues;
    private final String indexOptions;
    private final FieldType fieldType;
    private final SimilarityProvider similarity;
    private final String normalizerName;
    private final boolean splitQueriesOnWhitespace;
    private final Script script;
    private final ScriptCompiler scriptCompiler;
    private final Version indexCreatedVersion;
    private final boolean storeIgnored;
    private final IndexAnalyzers indexAnalyzers;

    private static TextSearchInfo textSearchInfo(FieldType fieldType, @Nullable SimilarityProvider similarity, NamedAnalyzer searchAnalyzer, NamedAnalyzer searchQuoteAnalyzer) {
        TextSearchInfo textSearchInfo = new TextSearchInfo(fieldType, similarity, searchAnalyzer, searchQuoteAnalyzer);
        if (textSearchInfo.equals(Defaults.TEXT_SEARCH_INFO)) {
            return Defaults.TEXT_SEARCH_INFO;
        }
        return textSearchInfo;
    }

    private static KeywordFieldMapper toType(FieldMapper in) {
        return (KeywordFieldMapper)in;
    }

    private KeywordFieldMapper(String simpleName, FieldType fieldType, KeywordFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, boolean storeIgnored, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo, builder.script.get() != null, builder.onScriptError.getValue());
        assert (fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) <= 0);
        this.indexed = builder.indexed.getValue();
        this.hasDocValues = builder.hasDocValues.getValue();
        this.indexOptions = builder.indexOptions.getValue();
        this.fieldType = fieldType;
        this.similarity = builder.similarity.getValue();
        this.normalizerName = builder.normalizer.getValue();
        this.splitQueriesOnWhitespace = builder.splitQueriesOnWhitespace.getValue();
        this.script = builder.script.get();
        this.indexAnalyzers = builder.indexAnalyzers;
        this.scriptCompiler = builder.scriptCompiler;
        this.indexCreatedVersion = builder.indexCreatedVersion;
        this.storeIgnored = storeIgnored;
    }

    @Override
    public KeywordFieldType fieldType() {
        return (KeywordFieldType)super.fieldType();
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        String value = context.parser().textOrNull();
        this.indexValue(context, value == null ? this.fieldType().nullValue : value);
    }

    @Override
    protected void indexScriptValues(SearchLookup searchLookup, LeafReaderContext readerContext, int doc, DocumentParserContext documentParserContext) {
        this.fieldType().scriptValues.valuesForDoc(searchLookup, readerContext, doc, value -> this.indexValue(documentParserContext, (String)value));
    }

    private void indexValue(DocumentParserContext context, String value) {
        if (value == null) {
            return;
        }
        if (value.length() > this.fieldType().ignoreAbove()) {
            context.addIgnoredField(this.name());
            if (this.storeIgnored) {
                context.doc().add((IndexableField)new StoredField(this.originalName(), new BytesRef((CharSequence)value)));
            }
            return;
        }
        value = KeywordFieldMapper.normalizeValue(this.fieldType().normalizer(), this.name(), value);
        BytesRef binaryValue = new BytesRef((CharSequence)value);
        if (this.fieldType().isDimension()) {
            context.getDimensions().addString(this.fieldType().name(), binaryValue);
        }
        if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored() || this.fieldType().hasDocValues()) {
            if (binaryValue.length > 32766) {
                byte[] prefix = new byte[30];
                System.arraycopy(binaryValue.bytes, binaryValue.offset, prefix, 0, 30);
                String msg = "Document contains at least one immense term in field=\"" + this.fieldType().name() + "\" (whose UTF8 encoding is longer than the max length 32766), all of which were skipped. Please correct the analyzer to not produce such terms. The prefix of the first immense term is: '" + Arrays.toString(prefix) + "...'";
                throw new IllegalArgumentException(msg);
            }
            if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
                KeywordField field = new KeywordField(this.fieldType().name(), binaryValue, this.fieldType);
                context.doc().add((IndexableField)field);
                if (!this.fieldType().hasDocValues() && this.fieldType.omitNorms()) {
                    context.addToFieldNames(this.fieldType().name());
                }
            }
            if (this.fieldType().hasDocValues()) {
                context.doc().add((IndexableField)new SortedSetDocValuesField(this.fieldType().name(), binaryValue));
            }
        }
    }

    private static String normalizeValue(NamedAnalyzer normalizer, String field, String value) {
        String string;
        block11: {
            if (normalizer == Lucene.KEYWORD_ANALYZER) {
                return value;
            }
            TokenStream ts = normalizer.tokenStream(field, value);
            try {
                CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
                ts.reset();
                if (!ts.incrementToken()) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "The normalization token stream is expected to produce exactly 1 token, but got 0 for analyzer %s and input \"%s\"\n", new Object[]{normalizer, value}));
                }
                String newValue = termAtt.toString();
                if (ts.incrementToken()) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "The normalization token stream is expected to produce exactly 1 token, but got 2+ for analyzer %s and input \"%s\"\n", new Object[]{normalizer, value}));
                }
                ts.end();
                string = newValue;
                if (ts == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (ts != null) {
                        try {
                            ts.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            ts.close();
        }
        return string;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public Map<String, NamedAnalyzer> indexAnalyzers() {
        return Map.of(this.mappedFieldType.name(), this.fieldType().normalizer);
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.indexAnalyzers, this.scriptCompiler, this.indexCreatedVersion).dimension(this.fieldType().isDimension()).init(this);
    }

    @Override
    public void doValidate(MappingLookup lookup) {
        if (this.fieldType().isDimension() && null != lookup.nestedLookup().getNestedParent(this.name())) {
            throw new IllegalArgumentException("time_series_dimension can't be configured in nested field [" + this.name() + "]");
        }
    }

    boolean hasNormalizer() {
        return this.normalizerName != null;
    }

    private String originalName() {
        return this.name() + "._original";
    }

    @Override
    public SourceLoader.SyntheticFieldLoader syntheticFieldLoader() {
        return this.syntheticFieldLoader(this.simpleName());
    }

    protected SourceLoader.SyntheticFieldLoader syntheticFieldLoader(String simpleName) {
        if (this.hasScript()) {
            return SourceLoader.SyntheticFieldLoader.NOTHING;
        }
        if (!this.copyTo.copyToFields().isEmpty()) {
            throw new IllegalArgumentException("field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support synthetic source because it declares copy_to");
        }
        if (this.hasNormalizer()) {
            throw new IllegalArgumentException("field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support synthetic source because it declares a normalizer");
        }
        if (this.fieldType.stored()) {
            return new StringStoredFieldFieldLoader(this.name(), simpleName, this.fieldType().ignoreAbove == Integer.MAX_VALUE ? null : this.originalName()){

                @Override
                protected void write(XContentBuilder b, Object value) throws IOException {
                    BytesRef ref = (BytesRef)value;
                    b.utf8Value(ref.bytes, ref.offset, ref.length);
                }
            };
        }
        if (!this.hasDocValues) {
            throw new IllegalArgumentException("field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support synthetic source because it doesn't have doc values and isn't stored");
        }
        return new SortedSetDocValuesSyntheticFieldLoader(this.name(), simpleName, this.fieldType().ignoreAbove == Integer.MAX_VALUE ? null : this.originalName(), false){

            @Override
            protected BytesRef convert(BytesRef value) {
                return value;
            }

            @Override
            protected BytesRef preserve(BytesRef value) {
                return BytesRef.deepCopyOf((BytesRef)value);
            }
        };
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();
        public static TextSearchInfo TEXT_SEARCH_INFO;
        public static final int IGNORE_ABOVE = Integer.MAX_VALUE;

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.freeze();
            TEXT_SEARCH_INFO = new TextSearchInfo(FIELD_TYPE, null, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER);
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> KeywordFieldMapper.toType((FieldMapper)m).indexed, true);
        private final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> KeywordFieldMapper.toType((FieldMapper)m).hasDocValues, true);
        private final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> KeywordFieldMapper.toType((FieldMapper)m).fieldType.stored(), false);
        private final FieldMapper.Parameter<String> nullValue = FieldMapper.Parameter.stringParam("null_value", false, m -> KeywordFieldMapper.toType((FieldMapper)m).fieldType().nullValue, null).acceptsNull();
        private final FieldMapper.Parameter<Boolean> eagerGlobalOrdinals = FieldMapper.Parameter.boolParam("eager_global_ordinals", true, m -> KeywordFieldMapper.toType(m).fieldType().eagerGlobalOrdinals(), false);
        private final FieldMapper.Parameter<Integer> ignoreAbove = FieldMapper.Parameter.intParam("ignore_above", true, m -> KeywordFieldMapper.toType(m).fieldType().ignoreAbove(), Integer.MAX_VALUE);
        private final FieldMapper.Parameter<String> indexOptions = TextParams.keywordIndexOptions(m -> KeywordFieldMapper.toType((FieldMapper)m).indexOptions);
        private final FieldMapper.Parameter<Boolean> hasNorms = TextParams.norms(false, m -> !KeywordFieldMapper.toType((FieldMapper)m).fieldType.omitNorms());
        private final FieldMapper.Parameter<SimilarityProvider> similarity = TextParams.similarity(m -> KeywordFieldMapper.toType((FieldMapper)m).similarity);
        private final FieldMapper.Parameter<String> normalizer;
        private final FieldMapper.Parameter<Boolean> splitQueriesOnWhitespace = FieldMapper.Parameter.boolParam("split_queries_on_whitespace", true, m -> KeywordFieldMapper.toType((FieldMapper)m).splitQueriesOnWhitespace, false);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final FieldMapper.Parameter<Script> script = FieldMapper.Parameter.scriptParam(m -> KeywordFieldMapper.toType((FieldMapper)m).script);
        private final FieldMapper.Parameter<OnScriptError> onScriptError = FieldMapper.Parameter.onScriptErrorParam(m -> KeywordFieldMapper.toType((FieldMapper)m).onScriptError, this.script);
        private final FieldMapper.Parameter<Boolean> dimension;
        private final IndexAnalyzers indexAnalyzers;
        private final ScriptCompiler scriptCompiler;
        private final Version indexCreatedVersion;

        public Builder(String name, IndexAnalyzers indexAnalyzers, ScriptCompiler scriptCompiler, Version indexCreatedVersion) {
            super(name);
            this.indexAnalyzers = indexAnalyzers;
            this.scriptCompiler = Objects.requireNonNull(scriptCompiler);
            this.indexCreatedVersion = Objects.requireNonNull(indexCreatedVersion);
            this.normalizer = FieldMapper.Parameter.stringParam("normalizer", indexCreatedVersion.isLegacyIndexVersion(), m -> KeywordFieldMapper.toType((FieldMapper)m).normalizerName, null).acceptsNull();
            this.script.precludesParameters(this.nullValue);
            this.addScriptValidation(this.script, this.indexed, this.hasDocValues);
            this.dimension = TimeSeriesParams.dimensionParam(m -> KeywordFieldMapper.toType(m).fieldType().isDimension()).addValidator(v -> {
                if (!(!v.booleanValue() || this.indexed.getValue().booleanValue() && this.hasDocValues.getValue().booleanValue())) {
                    throw new IllegalArgumentException("Field [time_series_dimension] requires that [" + this.indexed.name + "] and [" + this.hasDocValues.name + "] are true");
                }
            }).precludesParameters(this.normalizer, this.ignoreAbove);
        }

        public Builder(String name, Version indexCreatedVersion) {
            this(name, null, ScriptCompiler.NONE, indexCreatedVersion);
        }

        public Builder ignoreAbove(int ignoreAbove) {
            this.ignoreAbove.setValue(ignoreAbove);
            return this;
        }

        Builder normalizer(String normalizerName) {
            this.normalizer.setValue(normalizerName);
            return this;
        }

        Builder nullValue(String nullValue) {
            this.nullValue.setValue(nullValue);
            return this;
        }

        public Builder docValues(boolean hasDocValues) {
            this.hasDocValues.setValue(hasDocValues);
            return this;
        }

        public Builder dimension(boolean dimension) {
            this.dimension.setValue(dimension);
            return this;
        }

        private FieldValues<String> scriptValues() {
            if (this.script.get() == null) {
                return null;
            }
            StringFieldScript.Factory scriptFactory = this.scriptCompiler.compile(this.script.get(), StringFieldScript.CONTEXT);
            return scriptFactory == null ? null : (lookup, ctx, doc, consumer) -> scriptFactory.newFactory(this.name, this.script.get().getParams(), lookup, OnScriptError.FAIL).newInstance(ctx).runForDoc(doc, consumer);
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.indexed, this.hasDocValues, this.stored, this.nullValue, this.eagerGlobalOrdinals, this.ignoreAbove, this.indexOptions, this.hasNorms, this.similarity, this.normalizer, this.splitQueriesOnWhitespace, this.script, this.onScriptError, this.meta, this.dimension};
        }

        private KeywordFieldType buildFieldType(MapperBuilderContext context, FieldType fieldType) {
            NamedAnalyzer normalizer = Lucene.KEYWORD_ANALYZER;
            NamedAnalyzer searchAnalyzer = Lucene.KEYWORD_ANALYZER;
            NamedAnalyzer quoteAnalyzer = Lucene.KEYWORD_ANALYZER;
            String normalizerName = this.normalizer.getValue();
            if (normalizerName != null) {
                assert (this.indexAnalyzers != null);
                normalizer = this.indexAnalyzers.getNormalizer(normalizerName);
                if (normalizer == null) {
                    if (this.indexCreatedVersion.isLegacyIndexVersion()) {
                        logger.warn(() -> Strings.format((String)"Could not find normalizer [%s] of legacy index, falling back to default", (Object[])new Object[]{normalizerName}));
                        normalizer = Lucene.KEYWORD_ANALYZER;
                    } else {
                        throw new MapperParsingException("normalizer [" + normalizerName + "] not found for field [" + this.name + "]");
                    }
                }
                searchAnalyzer = quoteAnalyzer = normalizer;
                if (this.splitQueriesOnWhitespace.getValue().booleanValue()) {
                    searchAnalyzer = this.indexAnalyzers.getWhitespaceNormalizer(normalizerName);
                }
            } else if (this.splitQueriesOnWhitespace.getValue().booleanValue()) {
                searchAnalyzer = Lucene.WHITESPACE_ANALYZER;
            }
            return new KeywordFieldType(context.buildFullName(this.name), fieldType, normalizer, searchAnalyzer, quoteAnalyzer, this, context.isSourceSynthetic());
        }

        @Override
        public KeywordFieldMapper build(MapperBuilderContext context) {
            FieldType fieldtype = new FieldType((IndexableFieldType)Defaults.FIELD_TYPE);
            fieldtype.setOmitNorms(this.hasNorms.getValue() == false);
            fieldtype.setIndexOptions(TextParams.toIndexOptions(this.indexed.getValue(), this.indexOptions.getValue()));
            fieldtype.setStored(this.stored.getValue().booleanValue());
            if (fieldtype.equals((Object)Defaults.FIELD_TYPE)) {
                fieldtype = Defaults.FIELD_TYPE;
            }
            return new KeywordFieldMapper(this.name, fieldtype, this.buildFieldType(context, fieldtype), this.multiFieldsBuilder.build(this, context), this.copyTo.build(), context.isSourceSynthetic(), this);
        }
    }

    public static final class KeywordFieldType
    extends StringFieldType {
        private final int ignoreAbove;
        private final String nullValue;
        private final NamedAnalyzer normalizer;
        private final boolean eagerGlobalOrdinals;
        private final FieldValues<String> scriptValues;
        private final boolean isDimension;
        private final boolean isSyntheticSource;

        public KeywordFieldType(String name, FieldType fieldType, NamedAnalyzer normalizer, NamedAnalyzer searchAnalyzer, NamedAnalyzer quoteAnalyzer, Builder builder, boolean isSyntheticSource) {
            super(name, fieldType.indexOptions() != IndexOptions.NONE && !builder.indexCreatedVersion.isLegacyIndexVersion(), fieldType.stored(), builder.hasDocValues.getValue(), KeywordFieldMapper.textSearchInfo(fieldType, builder.similarity.getValue(), searchAnalyzer, quoteAnalyzer), builder.meta.getValue());
            this.eagerGlobalOrdinals = builder.eagerGlobalOrdinals.getValue();
            this.normalizer = normalizer;
            this.ignoreAbove = builder.ignoreAbove.getValue();
            this.nullValue = builder.nullValue.getValue();
            this.scriptValues = builder.scriptValues();
            this.isDimension = builder.dimension.getValue();
            this.isSyntheticSource = isSyntheticSource;
        }

        public KeywordFieldType(String name, boolean isIndexed, boolean hasDocValues, Map<String, String> meta) {
            super(name, isIndexed, false, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.normalizer = Lucene.KEYWORD_ANALYZER;
            this.ignoreAbove = Integer.MAX_VALUE;
            this.nullValue = null;
            this.eagerGlobalOrdinals = false;
            this.scriptValues = null;
            this.isDimension = false;
            this.isSyntheticSource = false;
        }

        public KeywordFieldType(String name) {
            this(name, true, true, Collections.emptyMap());
        }

        public KeywordFieldType(String name, FieldType fieldType) {
            super(name, fieldType.indexOptions() != IndexOptions.NONE, false, false, KeywordFieldMapper.textSearchInfo(fieldType, null, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER), Collections.emptyMap());
            this.normalizer = Lucene.KEYWORD_ANALYZER;
            this.ignoreAbove = Integer.MAX_VALUE;
            this.nullValue = null;
            this.eagerGlobalOrdinals = false;
            this.scriptValues = null;
            this.isDimension = false;
            this.isSyntheticSource = false;
        }

        public KeywordFieldType(String name, NamedAnalyzer analyzer) {
            super(name, true, false, true, KeywordFieldMapper.textSearchInfo(Defaults.FIELD_TYPE, null, analyzer, analyzer), Collections.emptyMap());
            this.normalizer = Lucene.KEYWORD_ANALYZER;
            this.ignoreAbove = Integer.MAX_VALUE;
            this.nullValue = null;
            this.eagerGlobalOrdinals = false;
            this.scriptValues = null;
            this.isDimension = false;
            this.isSyntheticSource = false;
        }

        @Override
        public boolean isSearchable() {
            return this.isIndexed() || this.hasDocValues();
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (this.isIndexed()) {
                return super.termQuery(value, context);
            }
            return SortedSetDocValuesField.newSlowExactQuery((String)this.name(), (BytesRef)this.indexedValueForSearch(value));
        }

        @Override
        public Query termsQuery(Collection<?> values, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (this.isIndexed()) {
                return super.termsQuery(values, context);
            }
            BytesRef[] bytesRefs = (BytesRef[])values.stream().map(this::indexedValueForSearch).toArray(BytesRef[]::new);
            return new DocValuesTermsQuery(this.name(), bytesRefs);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (this.isIndexed()) {
                return super.rangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, context);
            }
            return SortedSetDocValuesField.newSlowRangeQuery((String)this.name(), (BytesRef)(lowerTerm == null ? null : this.indexedValueForSearch(lowerTerm)), (BytesRef)(upperTerm == null ? null : this.indexedValueForSearch(upperTerm)), (boolean)includeLower, (boolean)includeUpper);
        }

        @Override
        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, SearchExecutionContext context, @Nullable MultiTermQuery.RewriteMethod rewriteMethod) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (this.isIndexed()) {
                return super.fuzzyQuery(value, fuzziness, prefixLength, maxExpansions, transpositions, context, rewriteMethod);
            }
            return StringScriptFieldFuzzyQuery.build(new Script(""), ctx -> new SortedSetDocValuesStringFieldScript(this.name(), context.lookup(), ctx), this.name(), this.indexedValueForSearch(value).utf8ToString(), fuzziness.asDistance(BytesRefs.toString(value)), prefixLength, transpositions);
        }

        @Override
        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (this.isIndexed()) {
                return super.prefixQuery(value, method, caseInsensitive, context);
            }
            return new StringScriptFieldPrefixQuery(new Script(""), ctx -> new SortedSetDocValuesStringFieldScript(this.name(), context.lookup(), ctx), this.name(), this.indexedValueForSearch(value).utf8ToString(), caseInsensitive);
        }

        @Override
        public Query termQueryCaseInsensitive(Object value, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (this.isIndexed()) {
                return super.termQueryCaseInsensitive(value, context);
            }
            return new StringScriptFieldTermQuery(new Script(""), ctx -> new SortedSetDocValuesStringFieldScript(this.name(), context.lookup(), ctx), this.name(), this.indexedValueForSearch(value).utf8ToString(), true);
        }

        @Override
        public TermsEnum getTerms(boolean caseInsensitive, String string, SearchExecutionContext queryShardContext, String searchAfter) throws IOException {
            BytesRef searchBytes;
            IndexReader reader = queryShardContext.searcher().getTopReaderContext().reader();
            Terms terms = null;
            if (this.isIndexed()) {
                terms = MultiTerms.getTerms((IndexReader)reader, (String)this.name());
            } else if (this.hasDocValues()) {
                terms = SortedSetDocValuesTerms.getTerms(reader, this.name());
            }
            if (terms == null) {
                return null;
            }
            Automaton a = caseInsensitive ? AutomatonQueries.caseInsensitivePrefix(string) : Automata.makeString((String)string);
            a = Operations.concatenate((Automaton)a, (Automaton)Automata.makeAnyString());
            a = MinimizationOperations.minimize((Automaton)a, (int)Integer.MAX_VALUE);
            CompiledAutomaton automaton = new CompiledAutomaton(a);
            BytesRef bytesRef = searchBytes = searchAfter == null ? null : new BytesRef((CharSequence)searchAfter);
            if (automaton.type == CompiledAutomaton.AUTOMATON_TYPE.ALL) {
                Object result = terms.iterator();
                if (searchAfter != null) {
                    result = new SearchAfterTermsEnum((TermsEnum)result, searchBytes);
                }
                return result;
            }
            return terms.intersect(automaton, searchBytes);
        }

        @Override
        public String typeName() {
            return KeywordFieldMapper.CONTENT_TYPE;
        }

        @Override
        public boolean eagerGlobalOrdinals() {
            return this.eagerGlobalOrdinals;
        }

        NamedAnalyzer normalizer() {
            return this.normalizer;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            MappedFieldType.FielddataOperation operation = fieldDataContext.fielddataOperation();
            if (operation == MappedFieldType.FielddataOperation.SEARCH) {
                this.failIfNoDocValues();
                return this.fieldDataFromDocValues();
            }
            if (operation != MappedFieldType.FielddataOperation.SCRIPT) {
                throw new IllegalStateException("unknown operation [" + operation.name() + "]");
            }
            if (this.hasDocValues()) {
                return this.fieldDataFromDocValues();
            }
            if (this.isSyntheticSource) {
                if (!this.isStored()) {
                    throw new IllegalStateException("keyword field [" + this.name() + "] is only supported in synthetic _source index if it creates doc values or stored fields");
                }
                return (cache, breaker) -> new StoredFieldSortedBinaryIndexFieldData(this.name(), CoreValuesSourceType.KEYWORD, KeywordDocValuesField::new){

                    @Override
                    protected BytesRef storedToBytesRef(Object stored) {
                        return (BytesRef)stored;
                    }
                };
            }
            Set<String> sourcePaths = fieldDataContext.sourcePathsLookup().apply(this.name());
            return new SourceValueFetcherSortedBinaryIndexFieldData.Builder(this.name(), (ValuesSourceType)CoreValuesSourceType.KEYWORD, (ValueFetcher)this.sourceValueFetcher(sourcePaths), (SourceProvider)fieldDataContext.lookupSupplier().get(), KeywordDocValuesField::new);
        }

        private SortedSetOrdinalsIndexFieldData.Builder fieldDataFromDocValues() {
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), CoreValuesSourceType.KEYWORD, (dv, n) -> new KeywordDocValuesField(FieldData.toString(dv), n));
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            if (this.scriptValues != null) {
                return FieldValues.valueFetcher(this.scriptValues, context);
            }
            return this.sourceValueFetcher(context.isSourceEnabled() ? context.sourcePath(this.name()) : Collections.emptySet());
        }

        private SourceValueFetcher sourceValueFetcher(Set<String> sourcePaths) {
            return new SourceValueFetcher(sourcePaths, (Object)this.nullValue){

                @Override
                protected String parseSourceValue(Object value) {
                    String keywordValue = value.toString();
                    if (keywordValue.length() > ignoreAbove) {
                        return null;
                    }
                    return KeywordFieldMapper.normalizeValue(this.normalizer(), this.name(), keywordValue);
                }
            };
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }

        @Override
        protected BytesRef indexedValueForSearch(Object value) {
            if (this.getTextSearchInfo().searchAnalyzer() == Lucene.KEYWORD_ANALYZER) {
                return super.indexedValueForSearch(value);
            }
            if (value == null) {
                return null;
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return this.getTextSearchInfo().searchAnalyzer().normalize(this.name(), value.toString());
        }

        @Override
        public Query wildcardQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (this.isIndexed()) {
                return super.wildcardQuery(value, method, caseInsensitive, true, context);
            }
            value = this.getTextSearchInfo().searchAnalyzer() != null ? KeywordFieldType.normalizeWildcardPattern(this.name(), value, (Analyzer)this.getTextSearchInfo().searchAnalyzer()) : this.indexedValueForSearch(value).utf8ToString();
            return new StringScriptFieldWildcardQuery(new Script(""), ctx -> new SortedSetDocValuesStringFieldScript(this.name(), context.lookup(), ctx), this.name(), value, caseInsensitive);
        }

        @Override
        public Query normalizedWildcardQuery(String value, MultiTermQuery.RewriteMethod method, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (this.isIndexed()) {
                return super.normalizedWildcardQuery(value, method, context);
            }
            value = this.getTextSearchInfo().searchAnalyzer() != null ? KeywordFieldType.normalizeWildcardPattern(this.name(), value, (Analyzer)this.getTextSearchInfo().searchAnalyzer()) : this.indexedValueForSearch(value).utf8ToString();
            return new StringScriptFieldWildcardQuery(new Script(""), ctx -> new SortedSetDocValuesStringFieldScript(this.name(), context.lookup(), ctx), this.name(), value, false);
        }

        @Override
        public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, MultiTermQuery.RewriteMethod method, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (this.isIndexed()) {
                return super.regexpQuery(value, syntaxFlags, matchFlags, maxDeterminizedStates, method, context);
            }
            if (matchFlags != 0) {
                throw new IllegalArgumentException("Match flags not yet implemented [" + matchFlags + "]");
            }
            return new StringScriptFieldRegexpQuery(new Script(""), ctx -> new SortedSetDocValuesStringFieldScript(this.name(), context.lookup(), ctx), this.name(), this.indexedValueForSearch(value).utf8ToString(), syntaxFlags, matchFlags, maxDeterminizedStates);
        }

        @Override
        public MappedFieldType.CollapseType collapseType() {
            return MappedFieldType.CollapseType.KEYWORD;
        }

        public int ignoreAbove() {
            return this.ignoreAbove;
        }

        @Override
        public boolean isDimension() {
            return this.isDimension;
        }

        @Override
        public void validateMatchedRoutingPath() {
            if (!this.isDimension) {
                throw new IllegalArgumentException("All fields that match routing_path must be keywords with [time_series_dimension: true] and without the [script] parameter. [" + this.name() + "] was not [time_series_dimension: true].");
            }
            if (this.scriptValues != null) {
                throw new IllegalArgumentException("All fields that match routing_path must be keywords with [time_series_dimension: true] and without the [script] parameter. [" + this.name() + "] has a [script] parameter.");
            }
        }

        static class SortedSetDocValuesTerms
        extends Terms {
            private final SortedSetDocValues values;

            public static Terms getTerms(IndexReader r, String field) throws IOException {
                List leaves = r.leaves();
                if (leaves.size() == 1) {
                    SortedSetDocValues sortedSetDocValues = ((LeafReaderContext)leaves.get(0)).reader().getSortedSetDocValues(field);
                    if (sortedSetDocValues == null) {
                        return null;
                    }
                    return new SortedSetDocValuesTerms(sortedSetDocValues);
                }
                ArrayList<SortedSetDocValuesTerms> termsPerLeaf = new ArrayList<SortedSetDocValuesTerms>(leaves.size());
                ArrayList<ReaderSlice> slicePerLeaf = new ArrayList<ReaderSlice>(leaves.size());
                for (int leafIdx = 0; leafIdx < leaves.size(); ++leafIdx) {
                    LeafReaderContext ctx = (LeafReaderContext)leaves.get(leafIdx);
                    SortedSetDocValues sortedSetDocValues = ctx.reader().getSortedSetDocValues(field);
                    if (sortedSetDocValues == null) continue;
                    termsPerLeaf.add(new SortedSetDocValuesTerms(sortedSetDocValues));
                    slicePerLeaf.add(new ReaderSlice(ctx.docBase, r.maxDoc(), leafIdx));
                }
                if (termsPerLeaf.isEmpty()) {
                    return null;
                }
                return new MultiTerms(termsPerLeaf.toArray(EMPTY_ARRAY), slicePerLeaf.toArray(ReaderSlice.EMPTY_ARRAY));
            }

            SortedSetDocValuesTerms(SortedSetDocValues values) {
                this.values = values;
            }

            public TermsEnum iterator() throws IOException {
                return this.values.termsEnum();
            }

            public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
                if (startTerm == null) {
                    return this.values.intersect(compiled);
                }
                return super.intersect(compiled, startTerm);
            }

            public long size() throws IOException {
                throw new UnsupportedOperationException();
            }

            public long getSumTotalTermFreq() throws IOException {
                throw new UnsupportedOperationException();
            }

            public long getSumDocFreq() throws IOException {
                throw new UnsupportedOperationException();
            }

            public int getDocCount() throws IOException {
                throw new UnsupportedOperationException();
            }

            public boolean hasFreqs() {
                throw new UnsupportedOperationException();
            }

            public boolean hasOffsets() {
                throw new UnsupportedOperationException();
            }

            public boolean hasPositions() {
                throw new UnsupportedOperationException();
            }

            public boolean hasPayloads() {
                throw new UnsupportedOperationException();
            }
        }

        static final class SearchAfterTermsEnum
        extends FilteredTermsEnum {
            private final BytesRef afterRef;

            SearchAfterTermsEnum(TermsEnum tenum, BytesRef termText) {
                super(tenum);
                this.afterRef = termText;
                this.setInitialSeekTerm(termText);
            }

            protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) {
                return term.equals((Object)this.afterRef) ? FilteredTermsEnum.AcceptStatus.NO : FilteredTermsEnum.AcceptStatus.YES;
            }
        }
    }

    public static class KeywordField
    extends Field {
        public KeywordField(String field, BytesRef term, FieldType ft) {
            super(field, term, (IndexableFieldType)ft);
        }
    }
}

