/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.elasticsearch.index.mapper.NestedObjectMapper;
import org.elasticsearch.index.mapper.ObjectMapper;

public interface NestedLookup {
    public static final NestedLookup EMPTY = new NestedLookup(){

        @Override
        public Map<String, NestedObjectMapper> getNestedMappers() {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, Query> getNestedParentFilters() {
            return Collections.emptyMap();
        }

        @Override
        public String getNestedParent(String path) {
            return null;
        }
    };

    public Map<String, NestedObjectMapper> getNestedMappers();

    public Map<String, Query> getNestedParentFilters();

    public String getNestedParent(String var1);

    public static NestedLookup build(List<NestedObjectMapper> mappers) {
        if (mappers == null || mappers.isEmpty()) {
            return EMPTY;
        }
        mappers = mappers.stream().sorted(Comparator.comparing(ObjectMapper::name)).toList();
        final HashMap<String, Query> parentFilters = new HashMap<String, Query>();
        final HashMap<String, NestedObjectMapper> mappersByName = new HashMap<String, NestedObjectMapper>();
        NestedObjectMapper previous = null;
        for (NestedObjectMapper mapper : mappers) {
            mappersByName.put(mapper.name(), mapper);
            if (previous != null && mapper.name().startsWith(previous.name() + ".")) {
                parentFilters.put(previous.name(), previous.nestedTypeFilter());
            }
            previous = mapper;
        }
        final List<String> nestedPathNames = mappers.stream().map(ObjectMapper::name).toList();
        return new NestedLookup(){

            @Override
            public Map<String, NestedObjectMapper> getNestedMappers() {
                return mappersByName;
            }

            @Override
            public Map<String, Query> getNestedParentFilters() {
                return parentFilters;
            }

            @Override
            public String getNestedParent(String path) {
                String parent = null;
                for (String parentPath : nestedPathNames) {
                    if (!path.startsWith(parentPath + ".")) continue;
                    parent = parentPath;
                }
                return parent;
            }
        };
    }
}

