/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.net.InetAddress;
import java.time.ZoneId;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.cluster.routing.IndexRouting;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.plain.SortedOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.DocValueFetcher;
import org.elasticsearch.index.mapper.DocumentDimensions;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TsidExtractingIdFieldMapper;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.field.DelegateDocValuesField;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;

public class TimeSeriesIdFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_tsid";
    public static final String CONTENT_TYPE = "_tsid";
    public static final TimeSeriesIdFieldType FIELD_TYPE = new TimeSeriesIdFieldType();
    public static final TimeSeriesIdFieldMapper INSTANCE = new TimeSeriesIdFieldMapper();
    private static final int LIMIT = 32766;
    private static final int DIMENSION_NAME_LIMIT = 512;
    private static final int DIMENSION_VALUE_LIMIT = 1024;
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.FixedTypeParser(c -> c.getIndexSettings().getMode().timeSeriesIdFieldMapper());

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder().init(this);
    }

    private TimeSeriesIdFieldMapper() {
        super(FIELD_TYPE);
    }

    @Override
    public void postParse(DocumentParserContext context) throws IOException {
        assert (!this.fieldType().isIndexed());
        TimeSeriesIdBuilder timeSeriesIdBuilder = (TimeSeriesIdBuilder)context.getDimensions();
        BytesRef timeSeriesId = timeSeriesIdBuilder.build().toBytesRef();
        context.doc().add((IndexableField)new SortedDocValuesField(this.fieldType().name(), timeSeriesId));
        TsidExtractingIdFieldMapper.createField(context, timeSeriesIdBuilder.routingBuilder, timeSeriesId);
    }

    @Override
    protected String contentType() {
        return "_tsid";
    }

    @Override
    public SourceLoader.SyntheticFieldLoader syntheticFieldLoader() {
        return SourceLoader.SyntheticFieldLoader.NOTHING;
    }

    public static Map<String, Object> decodeTsid(StreamInput in) {
        try {
            int size = in.readVInt();
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(size);
            block7: for (int i = 0; i < size; ++i) {
                String name = in.readBytesRef().utf8ToString();
                int type = in.read();
                switch (type) {
                    case 115: {
                        result.put(name, in.readBytesRef().utf8ToString());
                        continue block7;
                    }
                    case 108: {
                        result.put(name, in.readLong());
                        continue block7;
                    }
                    case 117: {
                        Object ul = DocValueFormat.UNSIGNED_LONG_SHIFTED.format(in.readLong());
                        result.put(name, ul);
                        continue block7;
                    }
                    default: {
                        throw new IllegalArgumentException("Cannot parse [" + name + "]: Unknown type [" + type + "]");
                    }
                }
            }
            return result;
        }
        catch (IOException | IllegalArgumentException e) {
            throw new IllegalArgumentException("Error formatting _tsid: " + e.getMessage(), e);
        }
    }

    public static Map<String, Object> decodeTsid(BytesRef bytesRef) {
        Map<String, Object> map;
        block8: {
            StreamInput input = new BytesArray(bytesRef).streamInput();
            try {
                map = TimeSeriesIdFieldMapper.decodeTsid(input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("Dimension field cannot be deserialized.", ex);
                }
            }
            input.close();
        }
        return map;
    }

    public static class Builder
    extends MetadataFieldMapper.Builder {
        protected Builder() {
            super("_tsid");
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return FieldMapper.EMPTY_PARAMETERS;
        }

        @Override
        public TimeSeriesIdFieldMapper build() {
            return INSTANCE;
        }
    }

    public static final class TimeSeriesIdFieldType
    extends MappedFieldType {
        private TimeSeriesIdFieldType() {
            super("_tsid", false, false, true, TextSearchInfo.NONE, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return "_tsid";
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return new DocValueFetcher(this.docValueFormat(format, null), (IndexFieldData<?>)context.getForField(this, MappedFieldType.FielddataOperation.SEARCH));
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return DocValueFormat.TIME_SERIES_ID;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            this.failIfNoDocValues();
            return new SortedOrdinalsIndexFieldData.Builder(this.name(), CoreValuesSourceType.KEYWORD, (dv, n) -> new DelegateDocValuesField(new ScriptDocValues.Strings(new ScriptDocValues.StringsSupplier(FieldData.toString(dv))), n));
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("[_tsid] is not searchable");
        }
    }

    public static class TimeSeriesIdBuilder
    implements DocumentDimensions {
        private final SortedMap<BytesRef, BytesReference> dimensions = new TreeMap<BytesRef, BytesReference>();
        @Nullable
        private final IndexRouting.ExtractFromSource.Builder routingBuilder;

        public TimeSeriesIdBuilder(@Nullable IndexRouting.ExtractFromSource.Builder routingBuilder) {
            this.routingBuilder = routingBuilder;
        }

        public BytesReference build() throws IOException {
            if (this.dimensions.isEmpty()) {
                throw new IllegalArgumentException("Dimension fields are missing.");
            }
            try (BytesStreamOutput out = new BytesStreamOutput();){
                out.writeVInt(this.dimensions.size());
                for (Map.Entry<BytesRef, BytesReference> entry : this.dimensions.entrySet()) {
                    BytesRef fieldName = entry.getKey();
                    if (fieldName.length > 512) {
                        throw new IllegalArgumentException(String.format(Locale.ROOT, "Dimension name must be less than [%d] bytes but [%s] was [%s].", 512, fieldName.utf8ToString(), fieldName.length));
                    }
                    out.writeBytesRef(fieldName);
                    entry.getValue().writeTo(out);
                }
                BytesReference timeSeriesId = out.bytes();
                if (timeSeriesId.length() > 32766) {
                    throw new IllegalArgumentException("_tsid longer than [32766] bytes [" + timeSeriesId.length() + "].");
                }
                BytesReference bytesReference = timeSeriesId;
                return bytesReference;
            }
        }

        @Override
        public void addString(String fieldName, BytesRef utf8Value) {
            try (BytesStreamOutput out = new BytesStreamOutput();){
                out.write(115);
                if (utf8Value.length > 1024) {
                    throw new IllegalArgumentException("Dimension fields must be less than [1024] bytes but was [" + utf8Value.length + "].");
                }
                out.writeBytesRef(utf8Value);
                this.add(fieldName, out.bytes());
                if (this.routingBuilder != null) {
                    this.routingBuilder.addMatching(fieldName, utf8Value);
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Dimension field cannot be serialized.", e);
            }
        }

        @Override
        public void addIp(String fieldName, InetAddress value) {
            this.addString(fieldName, NetworkAddress.format(value));
        }

        @Override
        public void addLong(String fieldName, long value) {
            try (BytesStreamOutput out = new BytesStreamOutput();){
                out.write(108);
                out.writeLong(value);
                this.add(fieldName, out.bytes());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Dimension field cannot be serialized.", e);
            }
        }

        @Override
        public void addUnsignedLong(String fieldName, long value) {
            try (BytesStreamOutput out = new BytesStreamOutput();){
                Object ul = DocValueFormat.UNSIGNED_LONG_SHIFTED.format(value);
                if (ul instanceof Long) {
                    Long l = (Long)ul;
                    out.write(108);
                    out.writeLong(l);
                } else {
                    out.write(117);
                    out.writeLong(value);
                }
                this.add(fieldName, out.bytes());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Dimension field cannot be serialized.", e);
            }
        }

        private void add(String fieldName, BytesReference encoded) {
            BytesReference old = this.dimensions.put(new BytesRef((CharSequence)fieldName), encoded);
            if (old != null) {
                throw new IllegalArgumentException("Dimension field [" + fieldName + "] cannot be a multi-valued field.");
            }
        }
    }
}

