/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.fetch.StoredFieldsContext;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class InnerHitBuilder
implements Writeable,
ToXContentObject {
    public static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    public static final ParseField IGNORE_UNMAPPED = new ParseField("ignore_unmapped", new String[0]);
    public static final QueryBuilder DEFAULT_INNER_HIT_QUERY = new MatchAllQueryBuilder();
    public static final ParseField COLLAPSE_FIELD = new ParseField("collapse", new String[0]);
    public static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    private static final boolean DEFAULT_IGNORE_UNAMPPED = false;
    private static final int DEFAULT_FROM = 0;
    private static final int DEFAULT_SIZE = 3;
    private static final boolean DEFAULT_VERSION = false;
    private static final boolean DEFAULT_SEQ_NO_AND_PRIMARY_TERM = false;
    private static final boolean DEFAULT_EXPLAIN = false;
    private static final boolean DEFAULT_TRACK_SCORES = false;
    private static final ObjectParser<InnerHitBuilder, Void> PARSER = new ObjectParser("inner_hits", InnerHitBuilder::new);
    private String name;
    private boolean ignoreUnmapped = false;
    private int from = 0;
    private int size = 3;
    private boolean explain = false;
    private boolean version = false;
    private boolean seqNoAndPrimaryTerm = false;
    private boolean trackScores = false;
    private StoredFieldsContext storedFieldsContext;
    private List<SortBuilder<?>> sorts;
    private List<FieldAndFormat> docValueFields;
    private Set<SearchSourceBuilder.ScriptField> scriptFields;
    private HighlightBuilder highlightBuilder;
    private FetchSourceContext fetchSourceContext;
    private List<FieldAndFormat> fetchFields;
    private CollapseBuilder innerCollapseBuilder = null;

    public InnerHitBuilder() {
        this.name = null;
    }

    public InnerHitBuilder(String name) {
        this.name = name;
    }

    public InnerHitBuilder(StreamInput in) throws IOException {
        int i;
        int size;
        this.name = in.readOptionalString();
        this.ignoreUnmapped = in.readBoolean();
        this.from = in.readVInt();
        this.size = in.readVInt();
        this.explain = in.readBoolean();
        this.version = in.readBoolean();
        this.seqNoAndPrimaryTerm = in.readBoolean();
        this.trackScores = in.readBoolean();
        this.storedFieldsContext = in.readOptionalWriteable(StoredFieldsContext::new);
        List<FieldAndFormat> list = this.docValueFields = in.readBoolean() ? in.readList(FieldAndFormat::new) : null;
        if (in.readBoolean()) {
            size = in.readVInt();
            this.scriptFields = Sets.newHashSetWithExpectedSize(size);
            for (i = 0; i < size; ++i) {
                this.scriptFields.add(new SearchSourceBuilder.ScriptField(in));
            }
        }
        this.fetchSourceContext = in.readOptionalWriteable(FetchSourceContext::readFrom);
        if (in.readBoolean()) {
            size = in.readVInt();
            this.sorts = new ArrayList(size);
            for (i = 0; i < size; ++i) {
                this.sorts.add(in.readNamedWriteable(SortBuilder.class));
            }
        }
        this.highlightBuilder = in.readOptionalWriteable(HighlightBuilder::new);
        this.innerCollapseBuilder = in.readOptionalWriteable(CollapseBuilder::new);
        if (in.getTransportVersion().onOrAfter(TransportVersion.V_7_10_0) && in.readBoolean()) {
            this.fetchFields = in.readList(FieldAndFormat::new);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.name);
        out.writeBoolean(this.ignoreUnmapped);
        out.writeVInt(this.from);
        out.writeVInt(this.size);
        out.writeBoolean(this.explain);
        out.writeBoolean(this.version);
        out.writeBoolean(this.seqNoAndPrimaryTerm);
        out.writeBoolean(this.trackScores);
        out.writeOptionalWriteable(this.storedFieldsContext);
        out.writeBoolean(this.docValueFields != null);
        if (this.docValueFields != null) {
            out.writeList(this.docValueFields);
        }
        boolean hasScriptFields = this.scriptFields != null;
        out.writeBoolean(hasScriptFields);
        if (hasScriptFields) {
            out.writeVInt(this.scriptFields.size());
            Iterator iterator = this.scriptFields.stream().sorted(Comparator.comparing(SearchSourceBuilder.ScriptField::fieldName)).iterator();
            while (iterator.hasNext()) {
                ((SearchSourceBuilder.ScriptField)iterator.next()).writeTo(out);
            }
        }
        out.writeOptionalWriteable(this.fetchSourceContext);
        boolean hasSorts = this.sorts != null;
        out.writeBoolean(hasSorts);
        if (hasSorts) {
            out.writeNamedWriteableList(this.sorts);
        }
        out.writeOptionalWriteable(this.highlightBuilder);
        out.writeOptionalWriteable(this.innerCollapseBuilder);
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_7_10_0)) {
            out.writeBoolean(this.fetchFields != null);
            if (this.fetchFields != null) {
                out.writeList(this.fetchFields);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public InnerHitBuilder setName(String name) {
        this.name = Objects.requireNonNull(name);
        return this;
    }

    public InnerHitBuilder setIgnoreUnmapped(boolean value) {
        this.ignoreUnmapped = value;
        return this;
    }

    public boolean isIgnoreUnmapped() {
        return this.ignoreUnmapped;
    }

    public int getFrom() {
        return this.from;
    }

    public InnerHitBuilder setFrom(int from) {
        if (from < 0) {
            throw new IllegalArgumentException("illegal from value, at least 0 or higher");
        }
        this.from = from;
        return this;
    }

    public int getSize() {
        return this.size;
    }

    public InnerHitBuilder setSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("illegal size value, at least 0 or higher");
        }
        this.size = size;
        return this;
    }

    public boolean isExplain() {
        return this.explain;
    }

    public InnerHitBuilder setExplain(boolean explain) {
        this.explain = explain;
        return this;
    }

    public boolean isVersion() {
        return this.version;
    }

    public InnerHitBuilder setVersion(boolean version) {
        this.version = version;
        return this;
    }

    public boolean isSeqNoAndPrimaryTerm() {
        return this.seqNoAndPrimaryTerm;
    }

    public InnerHitBuilder setSeqNoAndPrimaryTerm(boolean seqNoAndPrimaryTerm) {
        this.seqNoAndPrimaryTerm = seqNoAndPrimaryTerm;
        return this;
    }

    public boolean isTrackScores() {
        return this.trackScores;
    }

    public InnerHitBuilder setTrackScores(boolean trackScores) {
        this.trackScores = trackScores;
        return this;
    }

    public StoredFieldsContext getStoredFieldsContext() {
        return this.storedFieldsContext;
    }

    public InnerHitBuilder setStoredFieldNames(List<String> fieldNames) {
        if (this.storedFieldsContext == null) {
            this.storedFieldsContext = StoredFieldsContext.fromList(fieldNames);
        } else {
            this.storedFieldsContext.addFieldNames(fieldNames);
        }
        return this;
    }

    public List<FieldAndFormat> getDocValueFields() {
        return this.docValueFields;
    }

    public InnerHitBuilder setDocValueFields(List<FieldAndFormat> docValueFields) {
        this.docValueFields = docValueFields;
        return this;
    }

    public InnerHitBuilder addDocValueField(String field, String format) {
        if (this.docValueFields == null || this.docValueFields.isEmpty()) {
            this.docValueFields = new ArrayList<FieldAndFormat>();
        }
        this.docValueFields.add(new FieldAndFormat(field, format));
        return this;
    }

    public InnerHitBuilder addDocValueField(String field) {
        return this.addDocValueField(field, null);
    }

    public List<FieldAndFormat> getFetchFields() {
        return this.fetchFields;
    }

    public InnerHitBuilder setFetchFields(List<FieldAndFormat> fetchFields) {
        this.fetchFields = fetchFields;
        return this;
    }

    public InnerHitBuilder addFetchField(String name) {
        return this.addFetchField(name, null);
    }

    public InnerHitBuilder addFetchField(String name, @Nullable String format) {
        return this.addFetchField(name, format, null);
    }

    public InnerHitBuilder addFetchField(String name, @Nullable String format, Boolean includeUnmapped) {
        if (this.fetchFields == null || this.fetchFields.isEmpty()) {
            this.fetchFields = new ArrayList<FieldAndFormat>();
        }
        this.fetchFields.add(new FieldAndFormat(name, format, includeUnmapped));
        return this;
    }

    public Set<SearchSourceBuilder.ScriptField> getScriptFields() {
        return this.scriptFields;
    }

    public InnerHitBuilder setScriptFields(Set<SearchSourceBuilder.ScriptField> scriptFields) {
        this.scriptFields = scriptFields;
        return this;
    }

    public InnerHitBuilder addScriptField(String name, Script script) {
        if (this.scriptFields == null) {
            this.scriptFields = new HashSet<SearchSourceBuilder.ScriptField>();
        }
        this.scriptFields.add(new SearchSourceBuilder.ScriptField(name, script, false));
        return this;
    }

    public FetchSourceContext getFetchSourceContext() {
        return this.fetchSourceContext;
    }

    public InnerHitBuilder setFetchSourceContext(FetchSourceContext fetchSourceContext) {
        this.fetchSourceContext = fetchSourceContext;
        return this;
    }

    public List<SortBuilder<?>> getSorts() {
        return this.sorts;
    }

    public InnerHitBuilder setSorts(List<SortBuilder<?>> sorts) {
        this.sorts = sorts;
        return this;
    }

    public InnerHitBuilder addSort(SortBuilder<?> sort) {
        if (this.sorts == null) {
            this.sorts = new ArrayList();
        }
        this.sorts.add(sort);
        return this;
    }

    public HighlightBuilder getHighlightBuilder() {
        return this.highlightBuilder;
    }

    public InnerHitBuilder setHighlightBuilder(HighlightBuilder highlightBuilder) {
        this.highlightBuilder = highlightBuilder;
        return this;
    }

    public InnerHitBuilder setInnerCollapse(CollapseBuilder innerCollapseBuilder) {
        this.innerCollapseBuilder = innerCollapseBuilder;
        return this;
    }

    public CollapseBuilder getInnerCollapseBuilder() {
        return this.innerCollapseBuilder;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.name != null) {
            builder.field(NAME_FIELD.getPreferredName(), this.name);
        }
        if (this.ignoreUnmapped) {
            builder.field(IGNORE_UNMAPPED.getPreferredName(), this.ignoreUnmapped);
        }
        if (this.from != 0) {
            builder.field(SearchSourceBuilder.FROM_FIELD.getPreferredName(), this.from);
        }
        if (this.size != 3) {
            builder.field(SearchSourceBuilder.SIZE_FIELD.getPreferredName(), this.size);
        }
        if (this.version) {
            builder.field(SearchSourceBuilder.VERSION_FIELD.getPreferredName(), this.version);
        }
        if (this.seqNoAndPrimaryTerm) {
            builder.field(SearchSourceBuilder.SEQ_NO_PRIMARY_TERM_FIELD.getPreferredName(), this.seqNoAndPrimaryTerm);
        }
        if (this.explain) {
            builder.field(SearchSourceBuilder.EXPLAIN_FIELD.getPreferredName(), this.explain);
        }
        if (this.trackScores) {
            builder.field(SearchSourceBuilder.TRACK_SCORES_FIELD.getPreferredName(), this.trackScores);
        }
        if (this.fetchSourceContext != null) {
            builder.field(SearchSourceBuilder._SOURCE_FIELD.getPreferredName(), (ToXContent)this.fetchSourceContext, params);
        }
        if (this.storedFieldsContext != null) {
            this.storedFieldsContext.toXContent(SearchSourceBuilder.STORED_FIELDS_FIELD.getPreferredName(), builder);
        }
        if (this.docValueFields != null) {
            builder.startArray(SearchSourceBuilder.DOCVALUE_FIELDS_FIELD.getPreferredName());
            for (FieldAndFormat fieldAndFormat : this.docValueFields) {
                fieldAndFormat.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.fetchFields != null) {
            builder.startArray(SearchSourceBuilder.FETCH_FIELDS_FIELD.getPreferredName());
            for (FieldAndFormat fieldAndFormat : this.fetchFields) {
                fieldAndFormat.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.scriptFields != null) {
            builder.startObject(SearchSourceBuilder.SCRIPT_FIELDS_FIELD.getPreferredName());
            for (SearchSourceBuilder.ScriptField scriptField : this.scriptFields) {
                scriptField.toXContent(builder, params);
            }
            builder.endObject();
        }
        if (this.sorts != null) {
            builder.startArray(SearchSourceBuilder.SORT_FIELD.getPreferredName());
            for (SortBuilder sortBuilder : this.sorts) {
                sortBuilder.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.highlightBuilder != null) {
            builder.field(SearchSourceBuilder.HIGHLIGHT_FIELD.getPreferredName(), (ToXContent)this.highlightBuilder, params);
        }
        if (this.innerCollapseBuilder != null) {
            builder.field(COLLAPSE_FIELD.getPreferredName(), (ToXContent)this.innerCollapseBuilder);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InnerHitBuilder that = (InnerHitBuilder)o;
        return this.ignoreUnmapped == that.ignoreUnmapped && this.from == that.from && this.size == that.size && this.explain == that.explain && this.version == that.version && this.seqNoAndPrimaryTerm == that.seqNoAndPrimaryTerm && this.trackScores == that.trackScores && Objects.equals(this.name, that.name) && Objects.equals(this.storedFieldsContext, that.storedFieldsContext) && Objects.equals(this.sorts, that.sorts) && Objects.equals(this.docValueFields, that.docValueFields) && Objects.equals(this.scriptFields, that.scriptFields) && Objects.equals(this.highlightBuilder, that.highlightBuilder) && Objects.equals(this.fetchSourceContext, that.fetchSourceContext) && Objects.equals(this.fetchFields, that.fetchFields) && Objects.equals(this.innerCollapseBuilder, that.innerCollapseBuilder);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.ignoreUnmapped, this.from, this.size, this.explain, this.version, this.seqNoAndPrimaryTerm, this.trackScores, this.storedFieldsContext, this.sorts, this.docValueFields, this.scriptFields, this.highlightBuilder, this.fetchSourceContext, this.fetchFields, this.innerCollapseBuilder);
    }

    public static InnerHitBuilder fromXContent(XContentParser parser) throws IOException {
        return (InnerHitBuilder)PARSER.parse(parser, (Object)new InnerHitBuilder(), null);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, true, true);
    }

    static {
        PARSER.declareString(InnerHitBuilder::setName, NAME_FIELD);
        PARSER.declareBoolean((innerHitBuilder, value) -> {
            innerHitBuilder.ignoreUnmapped = value;
        }, IGNORE_UNMAPPED);
        PARSER.declareInt(InnerHitBuilder::setFrom, SearchSourceBuilder.FROM_FIELD);
        PARSER.declareInt(InnerHitBuilder::setSize, SearchSourceBuilder.SIZE_FIELD);
        PARSER.declareBoolean(InnerHitBuilder::setExplain, SearchSourceBuilder.EXPLAIN_FIELD);
        PARSER.declareBoolean(InnerHitBuilder::setVersion, SearchSourceBuilder.VERSION_FIELD);
        PARSER.declareBoolean(InnerHitBuilder::setSeqNoAndPrimaryTerm, SearchSourceBuilder.SEQ_NO_PRIMARY_TERM_FIELD);
        PARSER.declareBoolean(InnerHitBuilder::setTrackScores, SearchSourceBuilder.TRACK_SCORES_FIELD);
        PARSER.declareStringArray(InnerHitBuilder::setStoredFieldNames, SearchSourceBuilder.STORED_FIELDS_FIELD);
        PARSER.declareObjectArray(InnerHitBuilder::setDocValueFields, (p, c) -> FieldAndFormat.fromXContent(p), SearchSourceBuilder.DOCVALUE_FIELDS_FIELD);
        PARSER.declareObjectArray(InnerHitBuilder::setFetchFields, (p, c) -> FieldAndFormat.fromXContent(p), SearchSourceBuilder.FETCH_FIELDS_FIELD);
        PARSER.declareField((p, i, c) -> {
            try {
                HashSet<SearchSourceBuilder.ScriptField> scriptFields = new HashSet<SearchSourceBuilder.ScriptField>();
                XContentParser.Token token = p.nextToken();
                while (token != XContentParser.Token.END_OBJECT) {
                    scriptFields.add(new SearchSourceBuilder.ScriptField(p));
                    token = p.nextToken();
                }
                i.setScriptFields(scriptFields);
            }
            catch (IOException e) {
                throw new ParsingException(p.getTokenLocation(), "Could not parse inner script definition", e, new Object[0]);
            }
        }, SearchSourceBuilder.SCRIPT_FIELDS_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareField((p, i, c) -> i.setSorts(SortBuilder.fromXContent(p)), SearchSourceBuilder.SORT_FIELD, ObjectParser.ValueType.OBJECT_ARRAY);
        PARSER.declareField((p, i, c) -> {
            try {
                i.setFetchSourceContext(FetchSourceContext.fromXContent(p));
            }
            catch (IOException e) {
                throw new ParsingException(p.getTokenLocation(), "Could not parse inner _source definition", e, new Object[0]);
            }
        }, SearchSourceBuilder._SOURCE_FIELD, ObjectParser.ValueType.OBJECT_ARRAY_BOOLEAN_OR_STRING);
        PARSER.declareObject(InnerHitBuilder::setHighlightBuilder, (p, c) -> HighlightBuilder.fromXContent(p), SearchSourceBuilder.HIGHLIGHT_FIELD);
        PARSER.declareField((parser, builder, context) -> {
            Boolean isParsedCorrectly = false;
            if (parser.currentToken() == XContentParser.Token.START_OBJECT && parser.nextToken() == XContentParser.Token.FIELD_NAME && FIELD_FIELD.match(parser.currentName(), parser.getDeprecationHandler()) && parser.nextToken() == XContentParser.Token.VALUE_STRING) {
                String field = parser.text();
                if (parser.nextToken() == XContentParser.Token.END_OBJECT) {
                    isParsedCorrectly = true;
                    CollapseBuilder cb = new CollapseBuilder(field);
                    builder.setInnerCollapse(cb);
                }
            }
            if (!isParsedCorrectly.booleanValue()) {
                throw new ParsingException(parser.getTokenLocation(), "Invalid token in the inner collapse", new Object[0]);
            }
        }, COLLAPSE_FIELD, ObjectParser.ValueType.OBJECT);
    }
}

