/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.LongSupplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.index.query.CoordinatorRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.XContentParserConfiguration;

public class QueryRewriteContext {
    private final XContentParserConfiguration parserConfiguration;
    private final NamedWriteableRegistry writeableRegistry;
    protected final Client client;
    protected final LongSupplier nowInMillis;
    private final List<BiConsumer<Client, ActionListener<?>>> asyncActions = new ArrayList();

    public QueryRewriteContext(XContentParserConfiguration parserConfiguration, NamedWriteableRegistry writeableRegistry, Client client, LongSupplier nowInMillis) {
        this.parserConfiguration = parserConfiguration;
        this.writeableRegistry = writeableRegistry;
        this.client = client;
        this.nowInMillis = nowInMillis;
    }

    public XContentParserConfiguration getParserConfig() {
        return this.parserConfiguration;
    }

    public long nowInMillis() {
        return this.nowInMillis.getAsLong();
    }

    public NamedWriteableRegistry getWriteableRegistry() {
        return this.writeableRegistry;
    }

    public SearchExecutionContext convertToSearchExecutionContext() {
        return null;
    }

    public CoordinatorRewriteContext convertToCoordinatorRewriteContext() {
        return null;
    }

    public void registerAsyncAction(BiConsumer<Client, ActionListener<?>> asyncAction) {
        this.asyncActions.add(asyncAction);
    }

    public boolean hasAsyncActions() {
        return !this.asyncActions.isEmpty();
    }

    public void executeAsyncActions(final ActionListener listener) {
        if (this.asyncActions.isEmpty()) {
            listener.onResponse(null);
        } else {
            final CountDown countDown = new CountDown(this.asyncActions.size());
            ActionListener internalListener = new ActionListener(){

                public void onResponse(Object o) {
                    if (countDown.countDown()) {
                        listener.onResponse(null);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    if (countDown.fastForward()) {
                        listener.onFailure(e);
                    }
                }
            };
            ArrayList biConsumers = new ArrayList(this.asyncActions);
            this.asyncActions.clear();
            for (BiConsumer biConsumer : biConsumers) {
                biConsumer.accept(this.client, internalListener);
            }
        }
    }
}

