/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;

public interface IndexEventListener {
    default public void shardRoutingChanged(IndexShard indexShard, @Nullable ShardRouting oldRouting, ShardRouting newRouting) {
    }

    default public void afterIndexShardCreated(IndexShard indexShard) {
    }

    default public void afterIndexShardStarted(IndexShard indexShard) {
    }

    default public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
    }

    default public void afterIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
    }

    default public void indexShardStateChanged(IndexShard indexShard, @Nullable IndexShardState previousState, IndexShardState currentState, @Nullable String reason) {
    }

    default public void beforeIndexCreated(Index index, Settings indexSettings) {
    }

    default public void afterIndexCreated(IndexService indexService) {
    }

    default public void beforeIndexRemoved(IndexService indexService, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
    }

    default public void afterIndexRemoved(Index index, IndexSettings indexSettings, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
    }

    default public void beforeIndexShardCreated(ShardRouting routing, Settings indexSettings) {
    }

    default public void beforeIndexShardDeleted(ShardId shardId, Settings indexSettings) {
    }

    default public void afterIndexShardDeleted(ShardId shardId, Settings indexSettings) {
    }

    default public void beforeIndexAddedToCluster(Index index, Settings indexSettings) {
    }

    default public void onStoreCreated(ShardId shardId) {
    }

    default public void onStoreClosed(ShardId shardId) {
    }

    default public void beforeIndexShardRecovery(IndexShard indexShard, IndexSettings indexSettings, ActionListener<Void> listener) {
        listener.onResponse(null);
    }

    default public void afterFilesRestoredFromRepository(IndexShard indexShard) {
    }
}

