/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SNIHostName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.Assertions;
import org.elasticsearch.Build;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionModule;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.repositories.reservedstate.ReservedRepositoryAction;
import org.elasticsearch.action.admin.indices.template.reservedstate.ReservedComposableIndexTemplateAction;
import org.elasticsearch.action.ingest.ReservedPipelineAction;
import org.elasticsearch.action.search.SearchExecutionStatsCollector;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.update.UpdateHelper;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.bootstrap.BootstrapContext;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.InternalClusterInfoService;
import org.elasticsearch.cluster.NodeConnectionsService;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.coordination.CoordinationDiagnosticsService;
import org.elasticsearch.cluster.coordination.Coordinator;
import org.elasticsearch.cluster.coordination.MasterHistoryService;
import org.elasticsearch.cluster.coordination.StableMasterHealthIndicatorService;
import org.elasticsearch.cluster.desirednodes.DesiredNodesSettingsValidator;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadataVerifier;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Manifest;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateDataStreamService;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetadataDataStreamsService;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.metadata.MetadataUpdateSettingsService;
import org.elasticsearch.cluster.metadata.SystemIndexMetadataUpgradeService;
import org.elasticsearch.cluster.metadata.TemplateUpgradeService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.routing.BatchedRerouteService;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdMonitor;
import org.elasticsearch.cluster.routing.allocation.ShardsAvailabilityHealthIndicatorService;
import org.elasticsearch.cluster.routing.allocation.WriteLoadForecaster;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.StopWatch;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.ModulesBuilder;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.logging.NodeAndClusterIdStateListener;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.ConsistentSettingsService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.SettingUpgrader;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Types;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.NodeMetadata;
import org.elasticsearch.gateway.GatewayAllocator;
import org.elasticsearch.gateway.GatewayMetaState;
import org.elasticsearch.gateway.GatewayModule;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.gateway.MetaStateService;
import org.elasticsearch.gateway.PersistedClusterStateService;
import org.elasticsearch.health.HealthIndicatorService;
import org.elasticsearch.health.HealthService;
import org.elasticsearch.health.metadata.HealthMetadataService;
import org.elasticsearch.health.node.DiskHealthIndicatorService;
import org.elasticsearch.health.node.HealthInfoCache;
import org.elasticsearch.health.node.LocalHealthMonitor;
import org.elasticsearch.health.node.selection.HealthNodeTaskExecutor;
import org.elasticsearch.health.stats.HealthApiStats;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.index.IndexSettingProviders;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexingPressure;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.ExecutorSelector;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.ShardLimitValidator;
import org.elasticsearch.indices.SystemIndexManager;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.indices.breaker.BreakerSettings;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.HierarchyCircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.indices.recovery.PeerRecoverySourceService;
import org.elasticsearch.indices.recovery.PeerRecoveryTargetService;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.SnapshotFilesProvider;
import org.elasticsearch.indices.recovery.plan.PeerOnlyRecoveryPlannerService;
import org.elasticsearch.indices.recovery.plan.RecoveryPlannerService;
import org.elasticsearch.indices.recovery.plan.ShardSnapshotsService;
import org.elasticsearch.indices.store.IndicesStore;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.monitor.MonitorService;
import org.elasticsearch.monitor.fs.FsHealthService;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.node.NodeService;
import org.elasticsearch.node.NodeValidationException;
import org.elasticsearch.node.ResponseCollectorService;
import org.elasticsearch.persistent.PersistentTasksClusterService;
import org.elasticsearch.persistent.PersistentTasksExecutorRegistry;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.AnalysisPlugin;
import org.elasticsearch.plugins.CircuitBreakerPlugin;
import org.elasticsearch.plugins.ClusterPlugin;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.plugins.EnginePlugin;
import org.elasticsearch.plugins.HealthPlugin;
import org.elasticsearch.plugins.IndexStorePlugin;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.MetadataUpgrader;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.plugins.PersistentTaskPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.plugins.RecoveryPlannerPlugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.plugins.ShutdownAwarePlugin;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.elasticsearch.plugins.TracerPlugin;
import org.elasticsearch.readiness.ReadinessService;
import org.elasticsearch.repositories.RepositoriesModule;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.reservedstate.ReservedClusterStateHandlerProvider;
import org.elasticsearch.reservedstate.action.ReservedClusterSettingsAction;
import org.elasticsearch.reservedstate.service.FileSettingsService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.script.ScriptModule;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.SearchUtils;
import org.elasticsearch.search.aggregations.support.AggregationUsageService;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.shutdown.PluginShutdownService;
import org.elasticsearch.snapshots.InternalSnapshotsInfoService;
import org.elasticsearch.snapshots.RepositoryIntegrityHealthIndicatorService;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.snapshots.SnapshotShardsService;
import org.elasticsearch.snapshots.SnapshotsInfoService;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskCancellationService;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.tasks.TaskResultsService;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.tracing.Tracer;
import org.elasticsearch.transport.RemoteClusterPortSettings;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.upgrades.SystemIndexMigrationExecutor;
import org.elasticsearch.usage.UsageService;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class Node
implements Closeable {
    public static final Setting<Boolean> WRITE_PORTS_FILE_SETTING = Setting.boolSetting("node.portsfile", false, Setting.Property.NodeScope);
    public static final Setting<String> NODE_NAME_SETTING = Setting.simpleString("node.name", Setting.Property.NodeScope);
    public static final Setting<String> NODE_EXTERNAL_ID_SETTING = Setting.simpleString("node.external_id", NODE_NAME_SETTING, Setting.Property.NodeScope);
    public static final Setting.AffixSetting<String> NODE_ATTRIBUTES = Setting.prefixKeySetting("node.attr.", key -> new Setting<String>((String)key, "", value -> {
        if (value.length() > 0 && (Character.isWhitespace(value.charAt(0)) || Character.isWhitespace(value.charAt(value.length() - 1)))) {
            throw new IllegalArgumentException(key + " cannot have leading or trailing whitespace [" + value + "]");
        }
        if (value.length() > 0 && "node.attr.server_name".equals(key)) {
            try {
                new SNIHostName((String)value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("invalid node.attr.server_name [" + value + "]", e);
            }
        }
        return value;
    }, Setting.Property.NodeScope));
    public static final Setting<String> BREAKER_TYPE_KEY = new Setting<String>("indices.breaker.type", "hierarchy", s -> {
        switch (s) {
            case "hierarchy": 
            case "none": {
                break;
            }
            default: {
                throw new IllegalArgumentException("indices.breaker.type must be one of [hierarchy, none] but was: " + s);
            }
        }
        return s;
    }, Setting.Property.NodeScope);
    public static final Setting<TimeValue> INITIAL_STATE_TIMEOUT_SETTING = Setting.positiveTimeSetting("discovery.initial_state_timeout", TimeValue.timeValueSeconds((long)30L), Setting.Property.NodeScope);
    private static final String CLIENT_TYPE = "node";
    private final Lifecycle lifecycle = new Lifecycle();
    private final Logger logger = LogManager.getLogger(Node.class);
    private final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(Node.class);
    private final Injector injector;
    private final Environment environment;
    private final NodeEnvironment nodeEnvironment;
    private final PluginsService pluginsService;
    private final NodeClient client;
    private final Collection<LifecycleComponent> pluginLifecycleComponents;
    private final LocalNodeFactory localNodeFactory;
    private final NodeService nodeService;
    final NamedWriteableRegistry namedWriteableRegistry;
    final NamedXContentRegistry namedXContentRegistry;

    public Node(Environment environment) {
        this(environment, PluginsService.getPluginsServiceCtor(environment), true);
    }

    protected Node(Environment initialEnvironment, Function<Settings, PluginsService> pluginServiceCtor, boolean forbidPrivateIndexSettings) {
        ArrayList<Object> resourcesToClose = new ArrayList<Object>();
        boolean success = false;
        try {
            DeprecationLogger.initialize(initialEnvironment.settings());
            Settings tmpSettings = Settings.builder().put(initialEnvironment.settings()).put(Client.CLIENT_TYPE_SETTING_S.getKey(), CLIENT_TYPE).build();
            JvmInfo jvmInfo = JvmInfo.jvmInfo();
            this.logger.info("version[{}], pid[{}], build[{}/{}/{}], OS[{}/{}/{}], JVM[{}/{}/{}/{}]", new Object[]{Build.CURRENT.qualifiedVersion(), jvmInfo.pid(), Build.CURRENT.type().displayName(), Build.CURRENT.hash(), Build.CURRENT.date(), Constants.OS_NAME, Constants.OS_VERSION, Constants.OS_ARCH, Constants.JVM_VENDOR, Constants.JVM_NAME, Constants.JAVA_VERSION, Constants.JVM_VERSION});
            this.logger.info("JVM home [{}], using bundled JDK [{}]", (Object)System.getProperty("java.home"), (Object)jvmInfo.getUsingBundledJdk());
            this.logger.info("JVM arguments {}", (Object)Arrays.toString(jvmInfo.getInputArguments()));
            if (!Build.CURRENT.isProductionRelease()) {
                this.logger.warn("version [{}] is a pre-release version of Elasticsearch and is not suitable for production", (Object)Build.CURRENT.qualifiedVersion());
            }
            if (Environment.PATH_SHARED_DATA_SETTING.exists(tmpSettings)) {
                this.deprecationLogger.warn(DeprecationCategory.SETTINGS, "shared-data-path", "setting [path.shared_data] is deprecated and will be removed in a future release", new Object[0]);
            }
            if (initialEnvironment.dataFiles().length > 1) {
                this.deprecationLogger.warn(DeprecationCategory.SETTINGS, "multiple-data-paths", "Configuring multiple [path.data] paths is deprecated. Use RAID or other system level features for utilizing multiple disks. This feature will be removed in a future release.", new Object[0]);
            }
            if (Environment.dataPathUsesList(tmpSettings)) {
                this.deprecationLogger.warn(DeprecationCategory.SETTINGS, "multiple-data-paths-list", "Configuring [path.data] with a list is deprecated. Instead specify as a string value.", new Object[0]);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("using config [{}], data [{}], logs [{}], plugins [{}]", (Object)initialEnvironment.configFile(), (Object)Arrays.toString(initialEnvironment.dataFiles()), (Object)initialEnvironment.logsFile(), (Object)initialEnvironment.pluginsFile());
            }
            Node.deleteTemporaryApmConfig(jvmInfo, (e, apmConfig) -> this.logger.error("failed to delete temporary APM config file [{}], reason: [{}]", apmConfig, (Object)e.getMessage()));
            this.pluginsService = pluginServiceCtor.apply(tmpSettings);
            Settings settings = Node.mergePluginSettings(this.pluginsService.pluginMap(), tmpSettings);
            this.environment = new Environment(settings, initialEnvironment.configFile());
            Environment.assertEquivalent(initialEnvironment, this.environment);
            List<ExecutorBuilder> executorBuilders = this.pluginsService.flatMap(p -> p.getExecutorBuilders(settings)).toList();
            ThreadPool threadPool = new ThreadPool(settings, executorBuilders.toArray(new ExecutorBuilder[0]));
            resourcesToClose.add(() -> ThreadPool.terminate(threadPool, 10L, TimeUnit.SECONDS));
            ResourceWatcherService resourceWatcherService = new ResourceWatcherService(settings, threadPool);
            resourcesToClose.add(resourceWatcherService);
            HeaderWarning.setThreadContext(threadPool.getThreadContext());
            resourcesToClose.add(() -> HeaderWarning.removeThreadContext(threadPool.getThreadContext()));
            Set<String> taskHeaders = Stream.concat(this.pluginsService.filterPlugins(ActionPlugin.class).stream().flatMap(p -> p.getTaskHeaders().stream()), Task.HEADERS_TO_COPY.stream()).collect(Collectors.toSet());
            Tracer tracer = this.getTracer(this.pluginsService, settings);
            TaskManager taskManager = new TaskManager(settings, threadPool, taskHeaders, tracer);
            ArrayList additionalSettings = new ArrayList(this.pluginsService.flatMap(Plugin::getSettings).toList());
            for (ExecutorBuilder builder : threadPool.builders()) {
                additionalSettings.addAll(builder.getRegisteredSettings());
            }
            this.client = new NodeClient(settings, threadPool);
            ScriptModule scriptModule = new ScriptModule(settings, this.pluginsService.filterPlugins(ScriptPlugin.class));
            ScriptService scriptService = this.newScriptService(settings, scriptModule.engines, scriptModule.contexts, threadPool::absoluteTimeInMillis);
            AnalysisModule analysisModule = new AnalysisModule(this.environment, this.pluginsService.filterPlugins(AnalysisPlugin.class), this.pluginsService.getStablePluginRegistry());
            Set<SettingUpgrader<?>> settingsUpgraders = this.pluginsService.flatMap(Plugin::getSettingUpgraders).collect(Collectors.toSet());
            SettingsModule settingsModule = new SettingsModule(settings, additionalSettings, this.pluginsService.flatMap(Plugin::getSettingsFilter).toList(), settingsUpgraders);
            this.nodeEnvironment = new NodeEnvironment(tmpSettings, this.environment);
            this.logger.info("node name [{}], node ID [{}], cluster name [{}], roles {}", (Object)NODE_NAME_SETTING.get(tmpSettings), (Object)this.nodeEnvironment.nodeId(), (Object)ClusterName.CLUSTER_NAME_SETTING.get(tmpSettings).value(), (Object)DiscoveryNode.getRolesFromSettings(settings).stream().map(DiscoveryNodeRole::roleName).collect(Collectors.toCollection(LinkedHashSet::new)));
            resourcesToClose.add(this.nodeEnvironment);
            this.localNodeFactory = new LocalNodeFactory(settings, this.nodeEnvironment.nodeId());
            ScriptModule.registerClusterSettingsListeners(scriptService, settingsModule.getClusterSettings());
            NetworkService networkService = new NetworkService(this.getCustomNameResolvers(this.pluginsService.filterPlugins(DiscoveryPlugin.class)));
            List<ClusterPlugin> clusterPlugins = this.pluginsService.filterPlugins(ClusterPlugin.class);
            ClusterService clusterService = new ClusterService(settings, settingsModule.getClusterSettings(), threadPool, taskManager);
            clusterService.addStateApplier(scriptService);
            resourcesToClose.add(clusterService);
            Set<Setting<?>> consistentSettings = settingsModule.getConsistentSettings();
            if (!consistentSettings.isEmpty()) {
                clusterService.addLocalNodeMasterListener(new ConsistentSettingsService(settings, clusterService, consistentSettings).newHashPublisher());
            }
            IngestService ingestService = new IngestService(clusterService, threadPool, this.environment, scriptService, analysisModule.getAnalysisRegistry(), this.pluginsService.filterPlugins(IngestPlugin.class), this.client);
            SetOnce repositoriesServiceReference = new SetOnce();
            ClusterInfoService clusterInfoService = this.newClusterInfoService(settings, clusterService, threadPool, this.client);
            UsageService usageService = new UsageService();
            SearchModule searchModule = new SearchModule(settings, this.pluginsService.filterPlugins(SearchPlugin.class));
            IndexSearcher.setMaxClauseCount((int)SearchUtils.calculateMaxClauseValue(threadPool));
            List<NamedWriteableRegistry.Entry> namedWriteables = Stream.of(NetworkModule.getNamedWriteables().stream(), IndicesModule.getNamedWriteables().stream(), searchModule.getNamedWriteables().stream(), this.pluginsService.flatMap(Plugin::getNamedWriteables), ClusterModule.getNamedWriteables().stream(), SystemIndexMigrationExecutor.getNamedWriteables().stream()).flatMap(Function.identity()).toList();
            NamedWriteableRegistry namedWriteableRegistry = new NamedWriteableRegistry(namedWriteables);
            NamedXContentRegistry xContentRegistry = new NamedXContentRegistry(Stream.of(NetworkModule.getNamedXContents().stream(), IndicesModule.getNamedXContents().stream(), searchModule.getNamedXContents().stream(), this.pluginsService.flatMap(Plugin::getNamedXContent), ClusterModule.getNamedXWriteables().stream(), SystemIndexMigrationExecutor.getNamedXContentParsers().stream(), HealthNodeTaskExecutor.getNamedXContentParsers().stream()).flatMap(Function.identity()).collect(Collectors.toList()));
            List<SystemIndices.Feature> features = this.pluginsService.filterPlugins(SystemIndexPlugin.class).stream().map(plugin -> {
                SystemIndices.validateFeatureName(plugin.getFeatureName(), plugin.getClass().getCanonicalName());
                return SystemIndices.Feature.fromSystemIndexPlugin(plugin, settings);
            }).toList();
            SystemIndices systemIndices = new SystemIndices(features);
            ExecutorSelector executorSelector = systemIndices.getExecutorSelector();
            ModulesBuilder modules = new ModulesBuilder();
            MonitorService monitorService = new MonitorService(settings, this.nodeEnvironment, threadPool);
            FsHealthService fsHealthService = new FsHealthService(settings, clusterService.getClusterSettings(), threadPool, this.nodeEnvironment);
            SetOnce rerouteServiceReference = new SetOnce();
            InternalSnapshotsInfoService snapshotsInfoService = new InternalSnapshotsInfoService(settings, clusterService, () -> ((SetOnce)repositoriesServiceReference).get(), () -> ((SetOnce)rerouteServiceReference).get());
            WriteLoadForecaster writeLoadForecaster = this.getWriteLoadForecaster(threadPool, settings, clusterService.getClusterSettings());
            ClusterModule clusterModule = new ClusterModule(settings, clusterService, clusterPlugins, clusterInfoService, snapshotsInfoService, threadPool, systemIndices, writeLoadForecaster);
            modules.add(clusterModule);
            IndicesModule indicesModule = new IndicesModule(this.pluginsService.filterPlugins(MapperPlugin.class));
            modules.add(indicesModule);
            List<BreakerSettings> pluginCircuitBreakers = this.pluginsService.filterPlugins(CircuitBreakerPlugin.class).stream().map(plugin -> plugin.getCircuitBreaker(settings)).toList();
            CircuitBreakerService circuitBreakerService = Node.createCircuitBreakerService(settingsModule.getSettings(), pluginCircuitBreakers, settingsModule.getClusterSettings());
            this.pluginsService.filterPlugins(CircuitBreakerPlugin.class).forEach(plugin -> {
                CircuitBreaker breaker = circuitBreakerService.getBreaker(plugin.getCircuitBreaker(settings).getName());
                plugin.setCircuitBreaker(breaker);
            });
            resourcesToClose.add(circuitBreakerService);
            modules.add(new GatewayModule());
            PageCacheRecycler pageCacheRecycler = this.createPageCacheRecycler(settings);
            BigArrays bigArrays = this.createBigArrays(pageCacheRecycler, circuitBreakerService);
            modules.add(settingsModule);
            MetaStateService metaStateService = new MetaStateService(this.nodeEnvironment, xContentRegistry);
            PersistedClusterStateService persistedClusterStateService = new PersistedClusterStateService(this.nodeEnvironment, xContentRegistry, clusterService.getClusterSettings(), threadPool::relativeTimeInMillis);
            List<EnginePlugin> enginePlugins = this.pluginsService.filterPlugins(EnginePlugin.class);
            List<Function<IndexSettings, Optional<EngineFactory>>> engineFactoryProviders = enginePlugins.stream().map(plugin -> plugin::getEngineFactory).toList();
            Map<String, IndexStorePlugin.DirectoryFactory> indexStoreFactories = this.pluginsService.filterPlugins(IndexStorePlugin.class).stream().map(IndexStorePlugin::getDirectoryFactories).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Map<String, IndexStorePlugin.RecoveryStateFactory> recoveryStateFactories = this.pluginsService.filterPlugins(IndexStorePlugin.class).stream().map(IndexStorePlugin::getRecoveryStateFactories).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            List<IndexStorePlugin.IndexFoldersDeletionListener> indexFoldersDeletionListeners = this.pluginsService.filterPlugins(IndexStorePlugin.class).stream().map(IndexStorePlugin::getIndexFoldersDeletionListeners).flatMap(Collection::stream).toList();
            Map<String, IndexStorePlugin.SnapshotCommitSupplier> snapshotCommitSuppliers = this.pluginsService.filterPlugins(IndexStorePlugin.class).stream().map(IndexStorePlugin::getSnapshotCommitSuppliers).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (DiscoveryNode.isMasterNode(settings)) {
                clusterService.addListener(new SystemIndexManager(systemIndices, this.client));
            }
            BatchedRerouteService rerouteService = new BatchedRerouteService(clusterService, clusterModule.getAllocationService()::reroute);
            rerouteServiceReference.set((Object)rerouteService);
            clusterService.setRerouteService(rerouteService);
            IndicesService indicesService = new IndicesService(settings, this.pluginsService, this.nodeEnvironment, xContentRegistry, analysisModule.getAnalysisRegistry(), clusterModule.getIndexNameExpressionResolver(), indicesModule.getMapperRegistry(), namedWriteableRegistry, threadPool, settingsModule.getIndexScopedSettings(), circuitBreakerService, bigArrays, scriptService, clusterService, this.client, metaStateService, engineFactoryProviders, indexStoreFactories, searchModule.getValuesSourceRegistry(), recoveryStateFactories, indexFoldersDeletionListeners, snapshotCommitSuppliers, searchModule.getRequestCacheKeyDifferentiator());
            IndexSettingProvider.Parameters parameters = new IndexSettingProvider.Parameters((CheckedFunction<IndexMetadata, MapperService, IOException>)((CheckedFunction)indicesService::createIndexMapperServiceForValidation));
            IndexSettingProviders indexSettingProviders = new IndexSettingProviders(this.pluginsService.flatMap(p -> p.getAdditionalIndexSettingProviders(parameters)).collect(Collectors.toSet()));
            ShardLimitValidator shardLimitValidator = new ShardLimitValidator(settings, clusterService);
            MetadataCreateIndexService metadataCreateIndexService = new MetadataCreateIndexService(settings, clusterService, indicesService, clusterModule.getAllocationService(), shardLimitValidator, this.environment, settingsModule.getIndexScopedSettings(), threadPool, xContentRegistry, systemIndices, forbidPrivateIndexSettings, indexSettingProviders);
            MetadataCreateDataStreamService metadataCreateDataStreamService = new MetadataCreateDataStreamService(threadPool, clusterService, metadataCreateIndexService);
            MetadataDataStreamsService metadataDataStreamsService = new MetadataDataStreamsService(clusterService, indicesService);
            MetadataUpdateSettingsService metadataUpdateSettingsService = new MetadataUpdateSettingsService(clusterService, clusterModule.getAllocationService(), settingsModule.getIndexScopedSettings(), indicesService, shardLimitValidator, threadPool);
            List pluginComponents = this.pluginsService.flatMap(p -> p.createComponents(this.client, clusterService, threadPool, resourceWatcherService, scriptService, xContentRegistry, this.environment, this.nodeEnvironment, namedWriteableRegistry, clusterModule.getIndexNameExpressionResolver(), () -> ((SetOnce)repositoriesServiceReference).get(), tracer, clusterModule.getAllocationService())).toList();
            ArrayList reservedStateHandlers = new ArrayList();
            reservedStateHandlers.add(new ReservedClusterSettingsAction(settingsModule.getClusterSettings()));
            MetadataIndexTemplateService templateService = new MetadataIndexTemplateService(clusterService, metadataCreateIndexService, indicesService, settingsModule.getIndexScopedSettings(), xContentRegistry, systemIndices, indexSettingProviders);
            reservedStateHandlers.add(new ReservedComposableIndexTemplateAction(templateService, settingsModule.getIndexScopedSettings()));
            List<ReservedClusterStateHandlerProvider> pluginHandlers = this.pluginsService.loadServiceProviders(ReservedClusterStateHandlerProvider.class);
            pluginHandlers.forEach(h -> reservedStateHandlers.addAll(h.handlers()));
            ActionModule actionModule = new ActionModule(settings, clusterModule.getIndexNameExpressionResolver(), settingsModule.getIndexScopedSettings(), settingsModule.getClusterSettings(), settingsModule.getSettingsFilter(), threadPool, this.pluginsService.filterPlugins(ActionPlugin.class), this.client, circuitBreakerService, usageService, systemIndices, tracer, clusterService, reservedStateHandlers);
            modules.add(actionModule);
            RestController restController = actionModule.getRestController();
            NetworkModule networkModule = new NetworkModule(settings, this.pluginsService.filterPlugins(NetworkPlugin.class), threadPool, bigArrays, pageCacheRecycler, circuitBreakerService, namedWriteableRegistry, xContentRegistry, networkService, restController, clusterService.getClusterSettings(), tracer);
            List<UnaryOperator<Map<String, IndexTemplateMetadata>>> indexTemplateMetadataUpgraders = this.pluginsService.map(Plugin::getIndexTemplateMetadataUpgrader).toList();
            MetadataUpgrader metadataUpgrader = new MetadataUpgrader(indexTemplateMetadataUpgraders);
            IndexMetadataVerifier indexMetadataVerifier = new IndexMetadataVerifier(settings, xContentRegistry, indicesModule.getMapperRegistry(), settingsModule.getIndexScopedSettings(), scriptService);
            if (DiscoveryNode.isMasterNode(settings)) {
                clusterService.addListener(new SystemIndexMetadataUpgradeService(systemIndices, clusterService));
            }
            new TemplateUpgradeService(this.client, clusterService, threadPool, indexTemplateMetadataUpgraders);
            Transport transport = networkModule.getTransportSupplier().get();
            TransportService transportService = this.newTransportService(settings, transport, threadPool, networkModule.getTransportInterceptor(), this.localNodeFactory, settingsModule.getClusterSettings(), taskManager, tracer);
            GatewayMetaState gatewayMetaState = new GatewayMetaState();
            ResponseCollectorService responseCollectorService = new ResponseCollectorService(clusterService);
            SearchTransportService searchTransportService = new SearchTransportService(transportService, this.client, SearchExecutionStatsCollector.makeWrapper(responseCollectorService));
            HttpServerTransport httpServerTransport = this.newHttpTransport(networkModule);
            IndexingPressure indexingLimits = new IndexingPressure(settings);
            RecoverySettings recoverySettings = new RecoverySettings(settings, settingsModule.getClusterSettings());
            RepositoriesModule repositoriesModule = new RepositoriesModule(this.environment, this.pluginsService.filterPlugins(RepositoryPlugin.class), transportService, clusterService, bigArrays, xContentRegistry, recoverySettings);
            RepositoriesService repositoryService = repositoriesModule.getRepositoryService();
            repositoriesServiceReference.set((Object)repositoryService);
            SnapshotsService snapshotsService = new SnapshotsService(settings, clusterService, clusterModule.getIndexNameExpressionResolver(), repositoryService, transportService, actionModule.getActionFilters(), systemIndices);
            SnapshotShardsService snapshotShardsService = new SnapshotShardsService(settings, clusterService, repositoryService, transportService, indicesService);
            actionModule.getReservedClusterStateService().installStateHandler(new ReservedRepositoryAction(repositoryService));
            actionModule.getReservedClusterStateService().installStateHandler(new ReservedPipelineAction());
            FileSettingsService fileSettingsService = new FileSettingsService(clusterService, actionModule.getReservedClusterStateService(), this.environment);
            RestoreService restoreService = new RestoreService(clusterService, repositoryService, clusterModule.getAllocationService(), metadataCreateIndexService, clusterModule.getMetadataDeleteIndexService(), indexMetadataVerifier, shardLimitValidator, systemIndices, indicesService, fileSettingsService, threadPool);
            DiskThresholdMonitor diskThresholdMonitor = new DiskThresholdMonitor(settings, clusterService::state, clusterService.getClusterSettings(), this.client, threadPool::relativeTimeInMillis, rerouteService);
            clusterInfoService.addListener(diskThresholdMonitor::onNewInfo);
            DiscoveryModule discoveryModule = new DiscoveryModule(settings, transportService, this.client, namedWriteableRegistry, networkService, clusterService.getMasterService(), clusterService.getClusterApplierService(), clusterService.getClusterSettings(), this.pluginsService.filterPlugins(DiscoveryPlugin.class), clusterModule.getAllocationService(), this.environment.configFile(), gatewayMetaState, rerouteService, fsHealthService, circuitBreakerService);
            this.nodeService = new NodeService(settings, threadPool, monitorService, discoveryModule.getCoordinator(), transportService, indicesService, this.pluginsService, circuitBreakerService, scriptService, httpServerTransport, ingestService, clusterService, settingsModule.getSettingsFilter(), responseCollectorService, searchTransportService, indexingLimits, searchModule.getValuesSourceRegistry().getUsageService());
            SearchService searchService = this.newSearchService(clusterService, indicesService, threadPool, scriptService, bigArrays, searchModule.getFetchPhase(), responseCollectorService, circuitBreakerService, executorSelector, tracer);
            PersistentTasksService persistentTasksService = new PersistentTasksService(clusterService, threadPool, this.client);
            SystemIndexMigrationExecutor systemIndexMigrationExecutor = new SystemIndexMigrationExecutor(this.client, clusterService, systemIndices, metadataUpdateSettingsService, metadataCreateIndexService, settingsModule.getIndexScopedSettings());
            HealthNodeTaskExecutor healthNodeTaskExecutor = HealthNodeTaskExecutor.create(clusterService, persistentTasksService, settings, clusterService.getClusterSettings());
            List<HealthNodeTaskExecutor> builtinTaskExecutors = List.of(systemIndexMigrationExecutor, healthNodeTaskExecutor);
            List pluginTaskExecutors = this.pluginsService.filterPlugins(PersistentTaskPlugin.class).stream().map(p -> p.getPersistentTasksExecutor(clusterService, threadPool, this.client, settingsModule, clusterModule.getIndexNameExpressionResolver())).flatMap(Collection::stream).collect(Collectors.toList());
            PersistentTasksExecutorRegistry registry = new PersistentTasksExecutorRegistry(CollectionUtils.concatLists(pluginTaskExecutors, builtinTaskExecutors));
            PersistentTasksClusterService persistentTasksClusterService = new PersistentTasksClusterService(settings, registry, clusterService, threadPool);
            resourcesToClose.add(persistentTasksClusterService);
            List<ShutdownAwarePlugin> shutdownAwarePlugins = this.pluginsService.filterPlugins(ShutdownAwarePlugin.class);
            PluginShutdownService pluginShutdownService = new PluginShutdownService(shutdownAwarePlugins);
            clusterService.addListener(pluginShutdownService);
            RecoveryPlannerService recoveryPlannerService = this.getRecoveryPlannerService(threadPool, clusterService, repositoryService);
            DesiredNodesSettingsValidator desiredNodesSettingsValidator = new DesiredNodesSettingsValidator(clusterService.getClusterSettings());
            MasterHistoryService masterHistoryService = new MasterHistoryService(transportService, threadPool, clusterService);
            CoordinationDiagnosticsService coordinationDiagnosticsService = new CoordinationDiagnosticsService(clusterService, transportService, discoveryModule.getCoordinator(), masterHistoryService);
            HealthService healthService = this.createHealthService(clusterService, clusterModule, coordinationDiagnosticsService, threadPool, systemIndices);
            HealthMetadataService healthMetadataService = HealthMetadataService.create(clusterService, settings);
            LocalHealthMonitor localHealthMonitor = LocalHealthMonitor.create(settings, clusterService, this.nodeService, threadPool, this.client);
            HealthInfoCache nodeHealthOverview = HealthInfoCache.create(clusterService);
            HealthApiStats healthApiStats = new HealthApiStats();
            modules.add(b -> {
                b.bind(Node.class).toInstance(this);
                b.bind(NodeService.class).toInstance(this.nodeService);
                b.bind(NamedXContentRegistry.class).toInstance(xContentRegistry);
                b.bind(PluginsService.class).toInstance(this.pluginsService);
                b.bind(Client.class).toInstance(this.client);
                b.bind(NodeClient.class).toInstance(this.client);
                b.bind(Environment.class).toInstance(this.environment);
                b.bind(ThreadPool.class).toInstance(threadPool);
                b.bind(NodeEnvironment.class).toInstance(this.nodeEnvironment);
                b.bind(ResourceWatcherService.class).toInstance(resourceWatcherService);
                b.bind(CircuitBreakerService.class).toInstance(circuitBreakerService);
                b.bind(BigArrays.class).toInstance(bigArrays);
                b.bind(PageCacheRecycler.class).toInstance(pageCacheRecycler);
                b.bind(ScriptService.class).toInstance(scriptService);
                b.bind(AnalysisRegistry.class).toInstance(analysisModule.getAnalysisRegistry());
                b.bind(IngestService.class).toInstance(ingestService);
                b.bind(IndexingPressure.class).toInstance(indexingLimits);
                b.bind(UsageService.class).toInstance(usageService);
                b.bind(AggregationUsageService.class).toInstance(searchModule.getValuesSourceRegistry().getUsageService());
                b.bind(NamedWriteableRegistry.class).toInstance(namedWriteableRegistry);
                b.bind(MetadataUpgrader.class).toInstance(metadataUpgrader);
                b.bind(MetaStateService.class).toInstance(metaStateService);
                b.bind(PersistedClusterStateService.class).toInstance(persistedClusterStateService);
                b.bind(IndicesService.class).toInstance(indicesService);
                b.bind(MetadataCreateIndexService.class).toInstance(metadataCreateIndexService);
                b.bind(MetadataCreateDataStreamService.class).toInstance(metadataCreateDataStreamService);
                b.bind(MetadataDataStreamsService.class).toInstance(metadataDataStreamsService);
                b.bind(MetadataUpdateSettingsService.class).toInstance(metadataUpdateSettingsService);
                b.bind(SearchService.class).toInstance(searchService);
                b.bind(SearchTransportService.class).toInstance(searchTransportService);
                b.bind(SearchPhaseController.class).toInstance(new SearchPhaseController(searchService::aggReduceContextBuilder));
                b.bind(Transport.class).toInstance(transport);
                b.bind(TransportService.class).toInstance(transportService);
                b.bind(NetworkService.class).toInstance(networkService);
                b.bind(UpdateHelper.class).toInstance(new UpdateHelper(scriptService));
                b.bind(IndexMetadataVerifier.class).toInstance(indexMetadataVerifier);
                b.bind(ClusterInfoService.class).toInstance(clusterInfoService);
                b.bind(SnapshotsInfoService.class).toInstance(snapshotsInfoService);
                b.bind(GatewayMetaState.class).toInstance(gatewayMetaState);
                b.bind(Coordinator.class).toInstance(discoveryModule.getCoordinator());
                this.processRecoverySettings(settingsModule.getClusterSettings(), recoverySettings);
                SnapshotFilesProvider snapshotFilesProvider = new SnapshotFilesProvider(repositoryService);
                b.bind(PeerRecoverySourceService.class).toInstance(new PeerRecoverySourceService(transportService, indicesService, recoverySettings, recoveryPlannerService));
                b.bind(PeerRecoveryTargetService.class).toInstance(new PeerRecoveryTargetService(threadPool, transportService, recoverySettings, clusterService, snapshotFilesProvider));
                b.bind(HttpServerTransport.class).toInstance(httpServerTransport);
                pluginComponents.forEach(p -> {
                    Class<?> pluginClass = p.getClass();
                    b.bind(pluginClass).toInstance(p);
                });
                b.bind(PersistentTasksService.class).toInstance(persistentTasksService);
                b.bind(PersistentTasksClusterService.class).toInstance(persistentTasksClusterService);
                b.bind(PersistentTasksExecutorRegistry.class).toInstance(registry);
                b.bind(RepositoriesService.class).toInstance(repositoryService);
                b.bind(SnapshotsService.class).toInstance(snapshotsService);
                b.bind(SnapshotShardsService.class).toInstance(snapshotShardsService);
                b.bind(RestoreService.class).toInstance(restoreService);
                b.bind(RerouteService.class).toInstance(rerouteService);
                b.bind(ShardLimitValidator.class).toInstance(shardLimitValidator);
                b.bind(FsHealthService.class).toInstance(fsHealthService);
                b.bind(SystemIndices.class).toInstance(systemIndices);
                b.bind(PluginShutdownService.class).toInstance(pluginShutdownService);
                b.bind(ExecutorSelector.class).toInstance(executorSelector);
                b.bind(IndexSettingProviders.class).toInstance(indexSettingProviders);
                b.bind(DesiredNodesSettingsValidator.class).toInstance(desiredNodesSettingsValidator);
                b.bind(HealthService.class).toInstance(healthService);
                b.bind(MasterHistoryService.class).toInstance(masterHistoryService);
                b.bind(CoordinationDiagnosticsService.class).toInstance(coordinationDiagnosticsService);
                b.bind(HealthNodeTaskExecutor.class).toInstance(healthNodeTaskExecutor);
                b.bind(HealthMetadataService.class).toInstance(healthMetadataService);
                b.bind(LocalHealthMonitor.class).toInstance(localHealthMonitor);
                b.bind(HealthInfoCache.class).toInstance(nodeHealthOverview);
                b.bind(HealthApiStats.class).toInstance(healthApiStats);
                b.bind(Tracer.class).toInstance(tracer);
                b.bind(FileSettingsService.class).toInstance(fileSettingsService);
                b.bind(WriteLoadForecaster.class).toInstance(writeLoadForecaster);
            });
            if (ReadinessService.enabled(this.environment)) {
                modules.add(b -> b.bind(ReadinessService.class).toInstance(new ReadinessService(clusterService, this.environment)));
            }
            this.injector = modules.createInjector();
            clusterModule.setExistingShardsAllocators(this.injector.getInstance(GatewayAllocator.class));
            List<LifecycleComponent> pluginLifecycleComponents = pluginComponents.stream().filter(p -> p instanceof LifecycleComponent).map(p -> (LifecycleComponent)p).toList();
            resourcesToClose.addAll(pluginLifecycleComponents);
            resourcesToClose.add((Closeable)((Object)this.injector.getInstance(PeerRecoverySourceService.class)));
            this.pluginLifecycleComponents = Collections.unmodifiableList(pluginLifecycleComponents);
            Map actions = (Map)Types.forciblyCast(this.injector.getInstance(new Key<Map<ActionType, TransportAction>>(){}));
            this.client.initialize(actions, transportService.getTaskManager(), () -> clusterService.localNode().getId(), transportService.getLocalNodeConnection(), transportService.getRemoteClusterService(), namedWriteableRegistry);
            this.namedWriteableRegistry = namedWriteableRegistry;
            this.namedXContentRegistry = xContentRegistry;
            this.logger.debug("initializing HTTP handlers ...");
            actionModule.initRestHandlers(() -> clusterService.state().nodesIfRecovered());
            this.logger.info("initialized");
            success = true;
        }
        catch (IOException ex) {
            throw new ElasticsearchException("failed to bind service", (Throwable)ex, new Object[0]);
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException(resourcesToClose);
            }
        }
    }

    @SuppressForbidden(reason="Cannot guarantee that the temp config path is relative to the environment")
    public static void deleteTemporaryApmConfig(JvmInfo jvmInfo, BiConsumer<Exception, Path> errorHandler) {
        for (String inputArgument : jvmInfo.getInputArguments()) {
            Path apmConfig;
            String APM_AGENT_CONFIG_FILE_REGEX;
            String agentArg;
            String[] parts;
            if (!inputArgument.startsWith("-javaagent:") || !(parts = (agentArg = inputArgument.substring(11)).split("=", 2))[0].matches(APM_AGENT_CONFIG_FILE_REGEX = String.join((CharSequence)("\\" + File.separator), ".*modules", "apm", "elastic-apm-agent-\\d+\\.\\d+\\.\\d+\\.jar"))) continue;
            if (parts.length == 2 && parts[1].startsWith("c=") && (apmConfig = PathUtils.get((String)parts[1].substring(2), (String[])new String[0])).getFileName().toString().matches("^\\.elstcapm\\..*\\.tmp")) {
                try {
                    Files.deleteIfExists(apmConfig);
                }
                catch (IOException e) {
                    errorHandler.accept(e, apmConfig);
                }
            }
            return;
        }
    }

    private Tracer getTracer(PluginsService pluginsService, Settings settings) {
        List<TracerPlugin> tracerPlugins = pluginsService.filterPlugins(TracerPlugin.class);
        if (tracerPlugins.size() > 1) {
            throw new IllegalStateException("A single TracerPlugin was expected but got: " + tracerPlugins);
        }
        return tracerPlugins.isEmpty() ? Tracer.NOOP : tracerPlugins.get(0).getTracer(settings);
    }

    private HealthService createHealthService(ClusterService clusterService, ClusterModule clusterModule, CoordinationDiagnosticsService coordinationDiagnosticsService, ThreadPool threadPool, SystemIndices systemIndices) {
        List<HealthIndicatorService> preflightHealthIndicatorServices = Collections.singletonList(new StableMasterHealthIndicatorService(coordinationDiagnosticsService, clusterService));
        ArrayList<ShardsAvailabilityHealthIndicatorService> serverHealthIndicatorServices = new ArrayList<ShardsAvailabilityHealthIndicatorService>(List.of(new RepositoryIntegrityHealthIndicatorService(clusterService), new ShardsAvailabilityHealthIndicatorService(clusterService, clusterModule.getAllocationService(), systemIndices)));
        serverHealthIndicatorServices.add((ShardsAvailabilityHealthIndicatorService)((Object)new DiskHealthIndicatorService(clusterService)));
        List pluginHealthIndicatorServices = this.pluginsService.filterPlugins(HealthPlugin.class).stream().flatMap(plugin -> plugin.getHealthIndicatorServices().stream()).toList();
        return new HealthService(preflightHealthIndicatorServices, CollectionUtils.concatLists(serverHealthIndicatorServices, pluginHealthIndicatorServices), threadPool);
    }

    private RecoveryPlannerService getRecoveryPlannerService(ThreadPool threadPool, ClusterService clusterService, RepositoriesService repositoryService) {
        List<RecoveryPlannerService> recoveryPlannerServices = this.pluginsService.filterPlugins(RecoveryPlannerPlugin.class).stream().map(plugin -> plugin.createRecoveryPlannerService(new ShardSnapshotsService(this.client, repositoryService, threadPool, clusterService))).filter(Optional::isPresent).map(Optional::get).toList();
        if (recoveryPlannerServices.isEmpty()) {
            return new PeerOnlyRecoveryPlannerService();
        }
        if (recoveryPlannerServices.size() > 1) {
            throw new IllegalStateException("Expected a single RecoveryPlannerService but got: " + recoveryPlannerServices.size());
        }
        return recoveryPlannerServices.get(0);
    }

    private WriteLoadForecaster getWriteLoadForecaster(ThreadPool threadPool, Settings settings, ClusterSettings clusterSettings) {
        List<ClusterPlugin> clusterPlugins = this.pluginsService.filterPlugins(ClusterPlugin.class);
        List writeLoadForecasters = clusterPlugins.stream().flatMap(clusterPlugin -> clusterPlugin.createWriteLoadForecasters(threadPool, settings, clusterSettings).stream()).toList();
        if (writeLoadForecasters.isEmpty()) {
            return WriteLoadForecaster.DEFAULT;
        }
        if (writeLoadForecasters.size() > 1) {
            throw new IllegalStateException("A single WriteLoadForecaster was expected but got: " + writeLoadForecasters);
        }
        return (WriteLoadForecaster)writeLoadForecasters.get(0);
    }

    protected TransportService newTransportService(Settings settings, Transport transport, ThreadPool threadPool, TransportInterceptor interceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, ClusterSettings clusterSettings, TaskManager taskManager, Tracer tracer) {
        return new TransportService(settings, transport, threadPool, interceptor, localNodeFactory, clusterSettings, taskManager, tracer);
    }

    protected void processRecoverySettings(ClusterSettings clusterSettings, RecoverySettings recoverySettings) {
    }

    public Settings settings() {
        return this.environment.settings();
    }

    public Client client() {
        return this.client;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public NodeEnvironment getNodeEnvironment() {
        return this.nodeEnvironment;
    }

    public Node start() throws NodeValidationException {
        GatewayMetaState gatewayMetaState;
        TransportService transportService;
        Coordinator coordinator;
        ClusterService clusterService;
        block21: {
            if (!this.lifecycle.moveToStarted()) {
                return this;
            }
            this.logger.info("starting ...");
            this.pluginLifecycleComponents.forEach(LifecycleComponent::start);
            if (ReadinessService.enabled(this.environment)) {
                this.injector.getInstance(ReadinessService.class).start();
            }
            this.injector.getInstance(MappingUpdatedAction.class).setClient(this.client);
            this.injector.getInstance(IndicesService.class).start();
            this.injector.getInstance(IndicesClusterStateService.class).start();
            this.injector.getInstance(SnapshotsService.class).start();
            this.injector.getInstance(SnapshotShardsService.class).start();
            this.injector.getInstance(RepositoriesService.class).start();
            this.injector.getInstance(SearchService.class).start();
            this.injector.getInstance(FsHealthService.class).start();
            this.nodeService.getMonitorService().start();
            clusterService = this.injector.getInstance(ClusterService.class);
            NodeConnectionsService nodeConnectionsService = this.injector.getInstance(NodeConnectionsService.class);
            nodeConnectionsService.start();
            clusterService.setNodeConnectionsService(nodeConnectionsService);
            this.injector.getInstance(GatewayService.class).start();
            coordinator = this.injector.getInstance(Coordinator.class);
            clusterService.getMasterService().setClusterStatePublisher(coordinator);
            transportService = this.injector.getInstance(TransportService.class);
            transportService.getTaskManager().setTaskResultsService(this.injector.getInstance(TaskResultsService.class));
            transportService.getTaskManager().setTaskCancellationService(new TaskCancellationService(transportService));
            transportService.start();
            assert (this.localNodeFactory.getNode() != null);
            assert (transportService.getLocalNode().equals(this.localNodeFactory.getNode())) : "transportService has a different local node than the factory provided";
            this.injector.getInstance(PeerRecoverySourceService.class).start();
            gatewayMetaState = this.injector.getInstance(GatewayMetaState.class);
            gatewayMetaState.start(this.settings(), transportService, clusterService, this.injector.getInstance(MetaStateService.class), this.injector.getInstance(IndexMetadataVerifier.class), this.injector.getInstance(MetadataUpgrader.class), this.injector.getInstance(PersistedClusterStateService.class));
            if (Assertions.ENABLED) {
                try {
                    assert (((Manifest)this.injector.getInstance(MetaStateService.class).loadFullState().v1()).isEmpty());
                    NodeMetadata nodeMetadata = NodeMetadata.FORMAT.loadLatestState(this.logger, NamedXContentRegistry.EMPTY, this.nodeEnvironment.nodeDataPaths());
                    assert (nodeMetadata != null);
                    assert (nodeMetadata.nodeVersion().equals(Version.CURRENT));
                    assert (nodeMetadata.nodeId().equals(this.localNodeFactory.getNode().getId()));
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block21;
                    throw new AssertionError((Object)e);
                }
            }
        }
        Metadata onDiskMetadata = gatewayMetaState.getPersistedState().getLastAcceptedState().metadata();
        assert (onDiskMetadata != null) : "metadata is null but shouldn't";
        this.validateNodeBeforeAcceptingRequests(new BootstrapContext(this.environment, onDiskMetadata), transportService.boundAddress(), this.pluginsService.flatMap(Plugin::getBootstrapChecks).toList());
        FileSettingsService fileSettingsService = this.injector.getInstance(FileSettingsService.class);
        fileSettingsService.start();
        if (ReadinessService.enabled(this.environment)) {
            fileSettingsService.addFileSettingsChangedListener(this.injector.getInstance(ReadinessService.class));
        }
        clusterService.addStateApplier(transportService.getTaskManager());
        coordinator.start();
        clusterService.start();
        assert (clusterService.localNode().equals(this.localNodeFactory.getNode())) : "clusterService has a different local node than the factory provided";
        transportService.acceptIncomingRequests();
        this.injector.getInstance(CoordinationDiagnosticsService.class).start();
        coordinator.startInitialJoin();
        final TimeValue initialStateTimeout = INITIAL_STATE_TIMEOUT_SETTING.get(this.settings());
        this.configureNodeAndClusterIdStateListener(clusterService);
        if (initialStateTimeout.millis() > 0L) {
            ThreadPool thread = this.injector.getInstance(ThreadPool.class);
            ClusterState clusterState = clusterService.state();
            ClusterStateObserver observer = new ClusterStateObserver(clusterState, clusterService, null, this.logger, thread.getThreadContext());
            if (clusterState.nodes().getMasterNodeId() == null) {
                this.logger.debug("waiting to join the cluster. timeout [{}]", (Object)initialStateTimeout);
                final CountDownLatch latch = new CountDownLatch(1);
                observer.waitForNextChange(new ClusterStateObserver.Listener(){

                    @Override
                    public void onNewClusterState(ClusterState state) {
                        latch.countDown();
                    }

                    @Override
                    public void onClusterServiceClose() {
                        latch.countDown();
                    }

                    @Override
                    public void onTimeout(TimeValue timeout) {
                        Node.this.logger.warn("timed out while waiting for initial discovery state - timeout: {}", (Object)initialStateTimeout);
                        latch.countDown();
                    }
                }, state -> state.nodes().getMasterNodeId() != null, initialStateTimeout);
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new ElasticsearchTimeoutException("Interrupted while waiting for initial discovery state", new Object[0]);
                }
            }
        }
        this.injector.getInstance(HttpServerTransport.class).start();
        if (WRITE_PORTS_FILE_SETTING.get(this.settings()).booleanValue()) {
            TransportService transport = this.injector.getInstance(TransportService.class);
            this.writePortsFile("transport", transport.boundAddress());
            HttpServerTransport http = this.injector.getInstance(HttpServerTransport.class);
            this.writePortsFile("http", http.boundAddress());
            if (ReadinessService.enabled(this.environment)) {
                ReadinessService readiness = this.injector.getInstance(ReadinessService.class);
                readiness.addBoundAddressListener(address -> this.writePortsFile("readiness", address));
            }
            if (RemoteClusterPortSettings.REMOTE_CLUSTER_PORT_ENABLED.get(this.environment.settings()).booleanValue()) {
                this.writePortsFile("remote_cluster", transport.boundRemoteAccessAddress());
            }
        }
        this.logger.info("started {}", (Object)transportService.getLocalNode());
        this.pluginsService.filterPlugins(ClusterPlugin.class).forEach(ClusterPlugin::onNodeStarted);
        return this;
    }

    protected void configureNodeAndClusterIdStateListener(ClusterService clusterService) {
        NodeAndClusterIdStateListener.getAndSetNodeIdAndClusterId(clusterService, this.injector.getInstance(ThreadPool.class).getThreadContext());
    }

    private Node stop() {
        if (!this.lifecycle.moveToStopped()) {
            return this;
        }
        this.logger.info("stopping ...");
        if (ReadinessService.enabled(this.environment)) {
            this.injector.getInstance(ReadinessService.class).stop();
        }
        this.injector.getInstance(FileSettingsService.class).stop();
        this.injector.getInstance(ResourceWatcherService.class).close();
        this.injector.getInstance(HttpServerTransport.class).stop();
        this.injector.getInstance(SnapshotsService.class).stop();
        this.injector.getInstance(SnapshotShardsService.class).stop();
        this.injector.getInstance(RepositoriesService.class).stop();
        this.injector.getInstance(IndicesClusterStateService.class).stop();
        this.injector.getInstance(Coordinator.class).stop();
        this.injector.getInstance(ClusterService.class).stop();
        this.injector.getInstance(NodeConnectionsService.class).stop();
        this.injector.getInstance(FsHealthService.class).stop();
        this.nodeService.getMonitorService().stop();
        this.injector.getInstance(GatewayService.class).stop();
        this.injector.getInstance(SearchService.class).stop();
        this.injector.getInstance(TransportService.class).stop();
        this.pluginLifecycleComponents.forEach(LifecycleComponent::stop);
        this.injector.getInstance(IndicesService.class).stop();
        this.logger.info("stopped");
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        Lifecycle lifecycle = this.lifecycle;
        synchronized (lifecycle) {
            if (this.lifecycle.started()) {
                this.stop();
            }
            if (!this.lifecycle.moveToClosed()) {
                return;
            }
        }
        this.logger.info("closing ...");
        ArrayList<Object> toClose = new ArrayList<Object>();
        StopWatch stopWatch = new StopWatch("node_close");
        toClose.add(() -> stopWatch.start("node_service"));
        toClose.add(this.nodeService);
        toClose.add(() -> stopWatch.stop().start("http"));
        toClose.add((Closeable)((Object)this.injector.getInstance(HttpServerTransport.class)));
        toClose.add(() -> stopWatch.stop().start("snapshot_service"));
        toClose.add((Closeable)((Object)this.injector.getInstance(SnapshotsService.class)));
        toClose.add((Closeable)((Object)this.injector.getInstance(SnapshotShardsService.class)));
        toClose.add((Closeable)((Object)this.injector.getInstance(RepositoriesService.class)));
        toClose.add(() -> stopWatch.stop().start("client"));
        Releasables.close((Releasable)this.injector.getInstance(Client.class));
        toClose.add(() -> stopWatch.stop().start("indices_cluster"));
        toClose.add((Closeable)((Object)this.injector.getInstance(IndicesClusterStateService.class)));
        toClose.add(() -> stopWatch.stop().start("indices"));
        toClose.add((Closeable)((Object)this.injector.getInstance(IndicesService.class)));
        toClose.add(this.injector.getInstance(IndicesStore.class));
        toClose.add((Closeable)((Object)this.injector.getInstance(PeerRecoverySourceService.class)));
        toClose.add(() -> stopWatch.stop().start("cluster"));
        toClose.add((Closeable)((Object)this.injector.getInstance(ClusterService.class)));
        toClose.add(() -> stopWatch.stop().start("node_connections_service"));
        toClose.add((Closeable)((Object)this.injector.getInstance(NodeConnectionsService.class)));
        toClose.add(() -> stopWatch.stop().start("cluster_coordinator"));
        toClose.add((Closeable)((Object)this.injector.getInstance(Coordinator.class)));
        toClose.add(() -> stopWatch.stop().start("monitor"));
        toClose.add(this.nodeService.getMonitorService());
        toClose.add(() -> stopWatch.stop().start("fsHealth"));
        toClose.add((Closeable)((Object)this.injector.getInstance(FsHealthService.class)));
        toClose.add(() -> stopWatch.stop().start("gateway"));
        toClose.add((Closeable)((Object)this.injector.getInstance(GatewayService.class)));
        toClose.add(() -> stopWatch.stop().start("search"));
        toClose.add((Closeable)((Object)this.injector.getInstance(SearchService.class)));
        toClose.add(() -> stopWatch.stop().start("transport"));
        toClose.add((Closeable)((Object)this.injector.getInstance(TransportService.class)));
        if (ReadinessService.enabled(this.environment)) {
            toClose.add((Closeable)((Object)this.injector.getInstance(ReadinessService.class)));
        }
        toClose.add((Closeable)((Object)this.injector.getInstance(FileSettingsService.class)));
        for (LifecycleComponent plugin : this.pluginLifecycleComponents) {
            toClose.add(() -> stopWatch.stop().start("plugin(" + plugin.getClass().getName() + ")"));
            toClose.add(plugin);
        }
        toClose.addAll(this.pluginsService.filterPlugins(Plugin.class));
        toClose.add(() -> stopWatch.stop().start("script"));
        toClose.add(this.injector.getInstance(ScriptService.class));
        toClose.add(() -> stopWatch.stop().start("thread_pool"));
        toClose.add(() -> this.injector.getInstance(ThreadPool.class).shutdown());
        toClose.add(() -> stopWatch.stop().start("gateway_meta_state"));
        toClose.add(this.injector.getInstance(GatewayMetaState.class));
        toClose.add(() -> stopWatch.stop().start("node_environment"));
        toClose.add(this.injector.getInstance(NodeEnvironment.class));
        toClose.add(stopWatch::stop);
        if (this.logger.isTraceEnabled()) {
            toClose.add(() -> this.logger.trace("Close times for each service:\n{}", (Object)stopWatch.prettyPrint()));
        }
        IOUtils.close(toClose);
        this.logger.info("closed");
    }

    public synchronized boolean awaitClose(long timeout, TimeUnit timeUnit) throws InterruptedException {
        if (!this.lifecycle.closed()) {
            throw new IllegalStateException("Call close() first");
        }
        ThreadPool threadPool = this.injector.getInstance(ThreadPool.class);
        boolean terminated = ThreadPool.terminate(threadPool, timeout, timeUnit);
        if (terminated && !this.nodeService.awaitClose(0L, TimeUnit.MILLISECONDS)) {
            throw new IllegalStateException("Some shards are still open after the threadpool terminated. Something is leaking index readers or store references.");
        }
        return terminated;
    }

    public boolean isClosed() {
        return this.lifecycle.closed();
    }

    public Injector injector() {
        return this.injector;
    }

    protected void validateNodeBeforeAcceptingRequests(BootstrapContext context, BoundTransportAddress boundTransportAddress, List<BootstrapCheck> bootstrapChecks) throws NodeValidationException {
    }

    private void writePortsFile(String type, BoundTransportAddress boundAddress) {
        Path tmpPortsFile = this.environment.logsFile().resolve(type + ".ports.tmp");
        try (BufferedWriter writer = Files.newBufferedWriter(tmpPortsFile, Charset.forName("UTF-8"), new OpenOption[0]);){
            for (TransportAddress address : boundAddress.boundAddresses()) {
                InetAddress inetAddress = InetAddress.getByName(address.getAddress());
                writer.write(NetworkAddress.format(new InetSocketAddress(inetAddress, address.getPort())) + "\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write ports file", e);
        }
        Path portsFile = this.environment.logsFile().resolve(type + ".ports");
        try {
            Files.move(tmpPortsFile, portsFile, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to rename ports file", e);
        }
    }

    protected PluginsService getPluginsService() {
        return this.pluginsService;
    }

    static Settings mergePluginSettings(Map<String, Plugin> pluginMap, Settings originalSettings) {
        HashMap<String, String> foundSettings = new HashMap<String, String>();
        Settings.Builder builder = Settings.builder();
        for (Map.Entry<String, Plugin> entry : pluginMap.entrySet()) {
            Settings settings = entry.getValue().additionalSettings();
            for (String setting : settings.keySet()) {
                String oldPlugin = foundSettings.put(setting, entry.getKey());
                if (oldPlugin == null) continue;
                throw new IllegalArgumentException("Cannot have additional setting [" + setting + "] in plugin [" + entry.getKey() + "], already added in plugin [" + oldPlugin + "]");
            }
            builder.put(settings);
        }
        return builder.put(originalSettings).build();
    }

    private static CircuitBreakerService createCircuitBreakerService(Settings settings, List<BreakerSettings> breakerSettings, ClusterSettings clusterSettings) {
        String type = BREAKER_TYPE_KEY.get(settings);
        if (type.equals("hierarchy")) {
            return new HierarchyCircuitBreakerService(settings, breakerSettings, clusterSettings);
        }
        if (type.equals("none")) {
            return new NoneCircuitBreakerService();
        }
        throw new IllegalArgumentException("Unknown circuit breaker type [" + type + "]");
    }

    BigArrays createBigArrays(PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService) {
        return new BigArrays(pageCacheRecycler, circuitBreakerService, "request");
    }

    PageCacheRecycler createPageCacheRecycler(Settings settings) {
        return new PageCacheRecycler(settings);
    }

    protected SearchService newSearchService(ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ScriptService scriptService, BigArrays bigArrays, FetchPhase fetchPhase, ResponseCollectorService responseCollectorService, CircuitBreakerService circuitBreakerService, ExecutorSelector executorSelector, Tracer tracer) {
        return new SearchService(clusterService, indicesService, threadPool, scriptService, bigArrays, fetchPhase, responseCollectorService, circuitBreakerService, executorSelector, tracer);
    }

    protected ScriptService newScriptService(Settings settings, Map<String, ScriptEngine> engines, Map<String, ScriptContext<?>> contexts, LongSupplier timeProvider) {
        return new ScriptService(settings, engines, contexts, timeProvider);
    }

    private List<NetworkService.CustomNameResolver> getCustomNameResolvers(List<DiscoveryPlugin> discoveryPlugins) {
        ArrayList<NetworkService.CustomNameResolver> customNameResolvers = new ArrayList<NetworkService.CustomNameResolver>();
        for (DiscoveryPlugin discoveryPlugin : discoveryPlugins) {
            NetworkService.CustomNameResolver customNameResolver = discoveryPlugin.getCustomNameResolver(this.settings());
            if (customNameResolver == null) continue;
            customNameResolvers.add(customNameResolver);
        }
        return customNameResolvers;
    }

    protected ClusterInfoService newClusterInfoService(Settings settings, ClusterService clusterService, ThreadPool threadPool, NodeClient client) {
        InternalClusterInfoService service = new InternalClusterInfoService(settings, clusterService, threadPool, client);
        if (DiscoveryNode.isMasterNode(settings)) {
            clusterService.addListener(service);
        }
        return service;
    }

    protected HttpServerTransport newHttpTransport(NetworkModule networkModule) {
        return networkModule.getHttpServerTransportSupplier().get();
    }

    private static class LocalNodeFactory
    implements Function<BoundTransportAddress, DiscoveryNode> {
        private final SetOnce<DiscoveryNode> localNode = new SetOnce();
        private final String persistentNodeId;
        private final Settings settings;

        private LocalNodeFactory(Settings settings, String persistentNodeId) {
            this.persistentNodeId = persistentNodeId;
            this.settings = settings;
        }

        @Override
        public DiscoveryNode apply(BoundTransportAddress boundTransportAddress) {
            this.localNode.set((Object)DiscoveryNode.createLocal(this.settings, boundTransportAddress.publishAddress(), this.persistentNodeId));
            return (DiscoveryNode)this.localNode.get();
        }

        DiscoveryNode getNode() {
            assert (this.localNode.get() != null);
            return (DiscoveryNode)this.localNode.get();
        }
    }
}

