/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.Collector;
import org.elasticsearch.action.search.SearchShardTask;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.AggregationInitializationException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.MultiBucketCollector;
import org.elasticsearch.search.aggregations.support.TimeSeriesIndexSearcher;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.profile.query.InternalProfileCollector;
import org.elasticsearch.search.query.QueryPhase;

public class AggregationPhase {
    @Inject
    public AggregationPhase() {
    }

    public static void preProcess(SearchContext context) {
        BucketCollector bucketCollector;
        if (context.aggregations() == null) {
            return;
        }
        try {
            context.aggregations().aggregators(context.aggregations().factories().createTopLevelAggregators());
            bucketCollector = MultiBucketCollector.wrap(true, List.of(context.aggregations().aggregators()));
            bucketCollector.preCollection();
        }
        catch (IOException e) {
            throw new AggregationInitializationException("Could not initialize aggregators", e);
        }
        if (context.aggregations().factories().context() != null && context.aggregations().factories().context().isInSortOrderExecutionRequired()) {
            TimeSeriesIndexSearcher searcher = new TimeSeriesIndexSearcher(context.searcher(), AggregationPhase.getCancellationChecks(context));
            try {
                searcher.search(context.rewrittenQuery(), bucketCollector);
            }
            catch (IOException e) {
                throw new AggregationExecutionException("Could not perform time series aggregation", e);
            }
            context.queryCollectors().put(AggregationPhase.class, BucketCollector.NO_OP_COLLECTOR);
        } else {
            Collector collector = context.getProfilers() == null ? bucketCollector.asCollector() : new InternalProfileCollector(bucketCollector.asCollector(), "aggregation", List.of());
            context.queryCollectors().put(AggregationPhase.class, collector);
        }
    }

    private static List<Runnable> getCancellationChecks(SearchContext context) {
        boolean timeoutSet;
        ArrayList<Runnable> cancellationChecks = new ArrayList<Runnable>();
        if (context.lowLevelCancellation()) {
            cancellationChecks.add(() -> {
                SearchShardTask task = context.getTask();
                if (task != null) {
                    task.ensureNotCancelled();
                }
            });
        }
        boolean bl = timeoutSet = context.scrollContext() == null && context.timeout() != null && !context.timeout().equals((Object)SearchService.NO_TIMEOUT);
        if (timeoutSet) {
            long startTime = context.getRelativeTimeInMillis();
            long timeout = context.timeout().millis();
            long maxTime = startTime + timeout;
            cancellationChecks.add(() -> {
                long time = context.getRelativeTimeInMillis();
                if (time > maxTime) {
                    throw new QueryPhase.TimeExceededException();
                }
            });
        }
        return cancellationChecks;
    }

    public static void execute(SearchContext context) {
        if (context.aggregations() == null) {
            context.queryResult().aggregations(null);
            return;
        }
        if (context.queryResult().hasAggs()) {
            return;
        }
        Aggregator[] aggregators = context.aggregations().aggregators();
        ArrayList<InternalAggregation> aggregations = new ArrayList<InternalAggregation>(aggregators.length);
        if (context.aggregations().factories().context() != null) {
            context.aggregations().factories().context().multiBucketConsumer().reset();
        }
        for (Aggregator aggregator : context.aggregations().aggregators()) {
            try {
                aggregator.postCollection();
                aggregations.add(aggregator.buildTopLevel());
            }
            catch (IOException e) {
                throw new AggregationExecutionException("Failed to build aggregation [" + aggregator.name() + "]", e);
            }
        }
        context.queryResult().aggregations(InternalAggregations.from(aggregations));
        context.aggregations(null);
        context.queryCollectors().remove(AggregationPhase.class);
    }
}

