/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket;

import java.io.IOException;
import java.util.Iterator;
import java.util.function.BiConsumer;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.support.AggregationPath;
import org.elasticsearch.search.sort.SortOrder;

public abstract class DeferringBucketCollector
extends BucketCollector {
    public abstract void setDeferredCollector(Iterable<BucketCollector> var1);

    public abstract void prepareSelectedBuckets(long ... var1) throws IOException;

    public Aggregator wrap(Aggregator in) {
        return new WrappedAggregator(in);
    }

    protected static class WrappedAggregator
    extends Aggregator {
        private final Aggregator in;

        WrappedAggregator(Aggregator in) {
            this.in = in;
        }

        @Override
        public ScoreMode scoreMode() {
            return this.in.scoreMode();
        }

        public void close() {
            this.in.close();
        }

        @Override
        public String name() {
            return this.in.name();
        }

        @Override
        public Aggregator parent() {
            return this.in.parent();
        }

        @Override
        public Aggregator subAggregator(String name) {
            return this.in.subAggregator(name);
        }

        @Override
        public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
            return this.in.buildAggregations(owningBucketOrds);
        }

        @Override
        public InternalAggregation buildEmptyAggregation() {
            return this.in.buildEmptyAggregation();
        }

        @Override
        public void collectDebugInfo(BiConsumer<String, Object> add) {
            super.collectDebugInfo(add);
            this.in.collectDebugInfo(add);
        }

        @Override
        public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx) throws IOException {
            throw new IllegalStateException("Deferred collectors cannot be collected directly. They must be collected through the recording wrapper.");
        }

        @Override
        public void preCollection() throws IOException {
            throw new IllegalStateException("Deferred collectors cannot be collected directly. They must be collected through the recording wrapper.");
        }

        @Override
        public void postCollection() throws IOException {
            throw new IllegalStateException("Deferred collectors cannot be collected directly. They must be collected through the recording wrapper.");
        }

        @Override
        public Aggregator resolveSortPath(AggregationPath.PathElement next, Iterator<AggregationPath.PathElement> path) {
            return this.in.resolveSortPath(next, path);
        }

        @Override
        public Aggregator.BucketComparator bucketComparator(String key, SortOrder order) {
            throw new UnsupportedOperationException("Can't sort on deferred aggregations");
        }

        @Override
        public Aggregator[] subAggregators() {
            return this.in.subAggregators();
        }
    }
}

