/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.sampler.random;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.InternalSingleBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.sampler.Sampler;
import org.elasticsearch.search.aggregations.bucket.sampler.random.RandomSamplerAggregationBuilder;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class InternalRandomSampler
extends InternalSingleBucketAggregation
implements Sampler {
    public static final String NAME = "mapped_random_sampler";
    public static final String PARSER_NAME = "random_sampler";
    private final int seed;
    private final double probability;

    InternalRandomSampler(String name, long docCount, int seed, double probability, InternalAggregations subAggregations, Map<String, Object> metadata) {
        super(name, docCount, subAggregations, metadata);
        this.seed = seed;
        this.probability = probability;
    }

    public InternalRandomSampler(StreamInput in) throws IOException {
        super(in);
        this.seed = in.readInt();
        this.probability = in.readDouble();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        super.doWriteTo(out);
        out.writeInt(this.seed);
        out.writeDouble(this.probability);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public String getType() {
        return PARSER_NAME;
    }

    @Override
    protected InternalSingleBucketAggregation newAggregation(String name, long docCount, InternalAggregations subAggregations) {
        return new InternalRandomSampler(name, docCount, this.seed, this.probability, subAggregations, this.metadata);
    }

    @Override
    public InternalAggregation reduce(List<InternalAggregation> aggregations, AggregationReduceContext reduceContext) {
        long docCount = 0L;
        ArrayList<InternalAggregations> subAggregationsList = new ArrayList<InternalAggregations>(aggregations.size());
        for (InternalAggregation aggregation : aggregations) {
            docCount += ((InternalSingleBucketAggregation)aggregation).getDocCount();
            subAggregationsList.add(((InternalSingleBucketAggregation)aggregation).getAggregations());
        }
        InternalAggregations aggs = InternalAggregations.reduce(subAggregationsList, reduceContext);
        if (reduceContext.isFinalReduce() && aggs != null) {
            SamplingContext context = this.buildContext();
            aggs = InternalAggregations.from(aggs.asList().stream().map(agg -> ((InternalAggregation)agg).finalizeSampling(context)).toList());
        }
        return this.newAggregation(this.getName(), docCount, aggs);
    }

    public SamplingContext buildContext() {
        return new SamplingContext(this.probability, this.seed);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(RandomSamplerAggregationBuilder.SEED.getPreferredName(), this.seed);
        builder.field(RandomSamplerAggregationBuilder.PROBABILITY.getPreferredName(), this.probability);
        builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.getDocCount());
        this.getAggregations().toXContentInternal(builder, params);
        return builder;
    }
}

