/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.hash.MurmurHash3;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.metrics.AbstractHyperLogLogPlusPlus;
import org.elasticsearch.search.aggregations.metrics.HyperLogLogPlusPlusSparse;
import org.elasticsearch.search.aggregations.metrics.InternalCardinality;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public class GlobalOrdCardinalityAggregator
extends NumericMetricsAggregator.SingleValue {
    private final ValuesSource.Bytes.WithOrdinals valuesSource;
    private final BigArrays bigArrays;
    private final int maxOrd;
    private final int precision;
    @Nullable
    private HyperLogLogPlusPlusSparse counts;
    private SortedSetDocValues values;
    private ObjectArray<BitArray> visitedOrds;

    public GlobalOrdCardinalityAggregator(String name, ValuesSource.Bytes.WithOrdinals valuesSource, int precision, int maxOrd, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        this.valuesSource = valuesSource;
        this.precision = precision;
        this.maxOrd = maxOrd;
        this.bigArrays = context.bigArrays();
        this.visitedOrds = this.bigArrays.newObjectArray(1L);
    }

    @Override
    public ScoreMode scoreMode() {
        return this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        this.values = this.valuesSource.globalOrdinalsValues(aggCtx.getLeafReaderContext());
        return new LeafBucketCollector(){

            @Override
            public void collect(int doc, long bucketOrd) throws IOException {
                GlobalOrdCardinalityAggregator.this.visitedOrds = GlobalOrdCardinalityAggregator.this.bigArrays.grow(GlobalOrdCardinalityAggregator.this.visitedOrds, bucketOrd + 1L);
                BitArray bits = GlobalOrdCardinalityAggregator.this.visitedOrds.get(bucketOrd);
                if (bits == null) {
                    bits = new BitArray(GlobalOrdCardinalityAggregator.this.maxOrd, GlobalOrdCardinalityAggregator.this.bigArrays);
                    GlobalOrdCardinalityAggregator.this.visitedOrds.set(bucketOrd, bits);
                }
                if (GlobalOrdCardinalityAggregator.this.values.advanceExact(doc)) {
                    long ord = GlobalOrdCardinalityAggregator.this.values.nextOrd();
                    while (ord != -1L) {
                        bits.set((int)ord);
                        ord = GlobalOrdCardinalityAggregator.this.values.nextOrd();
                    }
                }
            }
        };
    }

    @Override
    protected void doPostCollection() throws IOException {
        this.counts = new HyperLogLogPlusPlusSparse(this.precision, this.bigArrays, this.visitedOrds.size());
        try (LongArray hashes = this.bigArrays.newLongArray(this.maxOrd, false);){
            try (BitArray allVisitedOrds = new BitArray(this.maxOrd, this.bigArrays);){
                for (long bucket = this.visitedOrds.size() - 1L; bucket >= 0L; --bucket) {
                    BitArray bits = this.visitedOrds.get(bucket);
                    if (bits == null) continue;
                    allVisitedOrds.or(bits);
                }
                MurmurHash3.Hash128 hash = new MurmurHash3.Hash128();
                long ord = allVisitedOrds.nextSetBit(0L);
                while (ord < Long.MAX_VALUE) {
                    BytesRef value = this.values.lookupOrd(ord);
                    MurmurHash3.hash128(value.bytes, value.offset, value.length, 0L, hash);
                    hashes.set(ord, hash.h1);
                    ord = ord + 1L < (long)this.maxOrd ? allVisitedOrds.nextSetBit(ord + 1L) : Long.MAX_VALUE;
                }
            }
            for (long bucket = this.visitedOrds.size() - 1L; bucket >= 0L; --bucket) {
                try (BitArray bits = this.visitedOrds.get(bucket);){
                    if (bits == null) continue;
                    this.visitedOrds.set(bucket, null);
                    this.counts.ensureCapacity(bucket, bits.cardinality());
                    long ord = bits.nextSetBit(0L);
                    while (ord < Long.MAX_VALUE) {
                        this.counts.collect(bucket, hashes.get(ord));
                        ord = ord + 1L < (long)this.maxOrd ? bits.nextSetBit(ord + 1L) : Long.MAX_VALUE;
                    }
                    continue;
                }
            }
            Releasables.close(this.visitedOrds);
            this.visitedOrds = null;
        }
    }

    @Override
    public double metric(long owningBucketOrd) {
        return this.counts.cardinality(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        if (this.counts == null || owningBucketOrdinal >= this.counts.maxOrd() || this.counts.cardinality(owningBucketOrdinal) == 0L) {
            return this.buildEmptyAggregation();
        }
        AbstractHyperLogLogPlusPlus copy = this.counts.clone(owningBucketOrdinal, BigArrays.NON_RECYCLING_INSTANCE);
        return new InternalCardinality(this.name, copy, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalCardinality(this.name, null, this.metadata());
    }

    @Override
    protected void doClose() {
        if (this.visitedOrds != null) {
            int i = 0;
            while ((long)i < this.visitedOrds.size()) {
                Releasables.close((Releasable)this.visitedOrds.get(i));
                ++i;
            }
        }
        Releasables.close((Releasable[])new Releasable[]{this.visitedOrds, this.counts});
    }
}

