/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.common.geo.SpatialPoint;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.CentroidAggregation;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class InternalCentroid
extends InternalAggregation
implements CentroidAggregation {
    protected final SpatialPoint centroid;
    protected final long count;
    private final FieldExtractor firstField;
    private final FieldExtractor secondField;

    public InternalCentroid(String name, SpatialPoint centroid, long count, Map<String, Object> metadata, FieldExtractor firstField, FieldExtractor secondField) {
        super(name, metadata);
        assert (centroid == null == (count == 0L));
        this.centroid = centroid;
        assert (count >= 0L);
        this.count = count;
        this.firstField = firstField;
        this.secondField = secondField;
    }

    protected abstract SpatialPoint centroidFromStream(StreamInput var1) throws IOException;

    protected abstract void centroidToStream(StreamOutput var1) throws IOException;

    protected InternalCentroid(StreamInput in, FieldExtractor firstField, FieldExtractor secondField) throws IOException {
        super(in);
        this.count = in.readVLong();
        this.centroid = in.readBoolean() ? this.centroidFromStream(in) : null;
        this.firstField = firstField;
        this.secondField = secondField;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVLong(this.count);
        if (this.centroid != null) {
            out.writeBoolean(true);
            this.centroidToStream(out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public SpatialPoint centroid() {
        return this.centroid;
    }

    @Override
    public long count() {
        return this.count;
    }

    protected abstract InternalCentroid copyWith(SpatialPoint var1, long var2);

    protected abstract InternalCentroid copyWith(double var1, double var3, long var5);

    @Override
    public InternalCentroid reduce(List<InternalAggregation> aggregations, AggregationReduceContext reduceContext) {
        double firstSum = Double.NaN;
        double secondSum = Double.NaN;
        long totalCount = 0L;
        for (InternalAggregation aggregation : aggregations) {
            InternalCentroid centroidAgg = (InternalCentroid)aggregation;
            if (centroidAgg.count <= 0L) continue;
            totalCount += centroidAgg.count;
            if (Double.isNaN(firstSum)) {
                firstSum = (double)centroidAgg.count * this.firstField.extractor.apply(centroidAgg.centroid);
                secondSum = (double)centroidAgg.count * this.secondField.extractor.apply(centroidAgg.centroid);
                continue;
            }
            firstSum += (double)centroidAgg.count * this.firstField.extractor.apply(centroidAgg.centroid);
            secondSum += (double)centroidAgg.count * this.secondField.extractor.apply(centroidAgg.centroid);
        }
        return this.copyWith(firstSum, secondSum, totalCount);
    }

    @Override
    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        return this.copyWith(this.centroid, samplingContext.scaleUp(this.count));
    }

    @Override
    protected boolean mustReduceOnSingleInternalAgg() {
        return false;
    }

    protected abstract double extractDouble(String var1);

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() == 1) {
            String coordinate;
            return switch (coordinate = path.get(0)) {
                case "value" -> this.centroid;
                case "count" -> this.count;
                default -> this.extractDouble(coordinate);
            };
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.centroid != null) {
            builder.startObject(Fields.CENTROID.getPreferredName());
            builder.field(this.firstField.name, this.firstField.extractor.apply(this.centroid));
            builder.field(this.secondField.name, this.secondField.extractor.apply(this.centroid));
            builder.endObject();
        }
        builder.field(Fields.COUNT.getPreferredName(), this.count);
        return builder;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalCentroid that = (InternalCentroid)obj;
        return this.count == that.count && Objects.equals(this.centroid, that.centroid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.centroid, this.count);
    }

    @Override
    public String toString() {
        return "InternalCentroid{centroid=" + this.centroid + ", count=" + this.count + "}";
    }

    protected static class FieldExtractor {
        private final String name;
        private final Function<SpatialPoint, Double> extractor;

        public FieldExtractor(String name, Function<SpatialPoint, Double> extractor) {
            this.name = name;
            this.extractor = extractor;
        }
    }

    public static class Fields {
        public static final ParseField CENTROID = new ParseField("location", new String[0]);
        public static final ParseField COUNT = new ParseField("count", new String[0]);
    }
}

