/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptedMetricAggContexts;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.InternalScriptedMetric;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.ScriptedMetricAggregatorFactory;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.lookup.SearchLookup;

class ScriptedMetricAggregator
extends MetricsAggregator {
    private static final long BUCKET_COST_ESTIMATE = 5120L;
    private final SearchLookup lookup;
    private final Map<String, Object> aggParams;
    @Nullable
    private final ScriptedMetricAggContexts.InitScript.Factory initScriptFactory;
    private final Map<String, Object> initScriptParams;
    private final ScriptedMetricAggContexts.MapScript.Factory mapScriptFactory;
    private final Map<String, Object> mapScriptParams;
    private final ScriptedMetricAggContexts.CombineScript.Factory combineScriptFactory;
    private final Map<String, Object> combineScriptParams;
    private final Script reduceScript;
    private ObjectArray<State> states;

    ScriptedMetricAggregator(String name, SearchLookup lookup, Map<String, Object> aggParams, @Nullable ScriptedMetricAggContexts.InitScript.Factory initScriptFactory, Map<String, Object> initScriptParams, ScriptedMetricAggContexts.MapScript.Factory mapScriptFactory, Map<String, Object> mapScriptParams, ScriptedMetricAggContexts.CombineScript.Factory combineScriptFactory, Map<String, Object> combineScriptParams, Script reduceScript, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        this.lookup = lookup;
        this.aggParams = aggParams;
        this.initScriptFactory = initScriptFactory;
        this.initScriptParams = initScriptParams;
        this.mapScriptFactory = mapScriptFactory;
        this.mapScriptParams = mapScriptParams;
        this.combineScriptFactory = combineScriptFactory;
        this.combineScriptParams = combineScriptParams;
        this.reduceScript = reduceScript;
        this.states = context.bigArrays().newObjectArray(1L);
    }

    @Override
    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE;
    }

    @Override
    public LeafBucketCollector getLeafCollector(final AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        for (long i = 0L; i < this.states.size(); ++i) {
            State state = this.states.get(i);
            if (state == null) continue;
            state.leafMapScript = null;
        }
        return new LeafBucketCollectorBase(sub, null){
            private Scorable scorer;

            @Override
            public void setScorer(Scorable scorer) throws IOException {
                this.scorer = scorer;
            }

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                ScriptedMetricAggregator.this.states = ScriptedMetricAggregator.this.bigArrays().grow(ScriptedMetricAggregator.this.states, owningBucketOrd + 1L);
                State state = ScriptedMetricAggregator.this.states.get(owningBucketOrd);
                if (state == null) {
                    ScriptedMetricAggregator.this.addRequestCircuitBreakerBytes(5120L);
                    state = new State();
                    ScriptedMetricAggregator.this.states.set(owningBucketOrd, state);
                }
                if (state.leafMapScript == null) {
                    state.leafMapScript = state.mapScript.newInstance(aggCtx.getLeafReaderContext());
                    state.leafMapScript.setScorer(this.scorer);
                }
                state.leafMapScript.setDocument(doc);
                state.leafMapScript.execute();
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        Object result = this.aggStateForResult(owningBucketOrdinal).combine();
        StreamOutput.checkWriteable(result);
        return new InternalScriptedMetric(this.name, Collections.singletonList(result), this.reduceScript, this.metadata());
    }

    private State aggStateForResult(long owningBucketOrdinal) {
        if (owningBucketOrdinal >= this.states.size()) {
            return new State();
        }
        State state = this.states.get(owningBucketOrdinal);
        if (state == null) {
            return new State();
        }
        CollectionUtils.ensureNoSelfReferences(state.aggState, "Scripted metric aggs map script");
        return state;
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalScriptedMetric(this.name, Collections.singletonList(null), this.reduceScript, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close(this.states);
    }

    private class State {
        private final ScriptedMetricAggContexts.MapScript.LeafFactory mapScript;
        private final Map<String, Object> mapScriptParamsForState;
        private final Map<String, Object> combineScriptParamsForState;
        private final Map<String, Object> aggState;
        private ScriptedMetricAggContexts.MapScript leafMapScript;

        State() {
            Map<String, Object> aggParamsForState = ScriptedMetricAggregatorFactory.deepCopyParams(ScriptedMetricAggregator.this.aggParams);
            this.mapScriptParamsForState = ScriptedMetricAggregatorFactory.mergeParams(aggParamsForState, ScriptedMetricAggregator.this.mapScriptParams);
            this.combineScriptParamsForState = ScriptedMetricAggregatorFactory.mergeParams(aggParamsForState, ScriptedMetricAggregator.this.combineScriptParams);
            this.aggState = this.newInitialState(ScriptedMetricAggregatorFactory.mergeParams(aggParamsForState, ScriptedMetricAggregator.this.initScriptParams));
            this.mapScript = ScriptedMetricAggregator.this.mapScriptFactory.newFactory(ScriptedMetricAggregatorFactory.deepCopyParams(this.mapScriptParamsForState), this.aggState, ScriptedMetricAggregator.this.lookup);
        }

        private Map<String, Object> newInitialState(Map<String, Object> initScriptParamsForState) {
            if (ScriptedMetricAggregator.this.initScriptFactory == null) {
                return new HashMap<String, Object>();
            }
            HashMap<String, Object> initialState = new HashMap<String, Object>();
            ScriptedMetricAggregator.this.initScriptFactory.newInstance(initScriptParamsForState, initialState).execute();
            CollectionUtils.ensureNoSelfReferences(initialState, "Scripted metric aggs init script");
            return initialState;
        }

        private Object combine() {
            if (ScriptedMetricAggregator.this.combineScriptFactory == null) {
                return this.aggState;
            }
            Object result = ScriptedMetricAggregator.this.combineScriptFactory.newInstance(this.combineScriptParamsForState, this.aggState).execute();
            CollectionUtils.ensureNoSelfReferences(result, "Scripted metric aggs combine script");
            return result;
        }
    }
}

