/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class Sum
extends InternalNumericMetricsAggregation.SingleValue {
    private final double sum;

    public Sum(String name, double sum, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, formatter, metadata);
        this.sum = sum;
    }

    public Sum(StreamInput in) throws IOException {
        super(in);
        this.sum = in.readDouble();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeDouble(this.sum);
    }

    @Override
    public String getWriteableName() {
        return "sum";
    }

    @Override
    public double value() {
        return this.sum;
    }

    @Override
    public Sum reduce(List<InternalAggregation> aggregations, AggregationReduceContext reduceContext) {
        CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        for (InternalAggregation aggregation : aggregations) {
            double value = ((Sum)aggregation).sum;
            kahanSummation.add(value);
        }
        return new Sum(this.name, kahanSummation.value(), this.format, this.getMetadata());
    }

    @Override
    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        return new Sum(this.name, samplingContext.scaleUp(this.sum), this.format, this.getMetadata());
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), this.sum);
        if (this.format != DocValueFormat.RAW) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.format.format(this.sum).toString());
        }
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sum);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Sum that = (Sum)obj;
        return Objects.equals(this.sum, that.sum);
    }
}

