/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public abstract class MultiValuesSource<VS extends ValuesSource> {
    protected Map<String, VS> values;

    public boolean needsScores() {
        return this.values.values().stream().anyMatch(ValuesSource::needsScores);
    }

    public boolean areValuesSourcesEmpty() {
        return this.values.values().stream().allMatch(Objects::isNull);
    }

    public static class NumericMultiValuesSource
    extends MultiValuesSource<ValuesSource.Numeric> {
        public NumericMultiValuesSource(Map<String, ValuesSourceConfig> valuesSourceConfigs) {
            this.values = Maps.newMapWithExpectedSize(valuesSourceConfigs.size());
            for (Map.Entry<String, ValuesSourceConfig> entry : valuesSourceConfigs.entrySet()) {
                ValuesSource valuesSource = entry.getValue().getValuesSource();
                if (!(valuesSource instanceof ValuesSource.Numeric)) {
                    throw new AggregationExecutionException("ValuesSource type " + valuesSource.toString() + "is not supported for multi-valued aggregation");
                }
                this.values.put(entry.getKey(), (ValuesSource.Numeric)valuesSource);
            }
        }

        public SortedNumericDoubleValues getField(String fieldName, LeafReaderContext ctx) throws IOException {
            ValuesSource.Numeric value = (ValuesSource.Numeric)this.values.get(fieldName);
            if (value == null) {
                throw new IllegalArgumentException("Could not find field name [" + fieldName + "] in multiValuesSource");
            }
            return value.doubleValues(ctx);
        }
    }
}

