/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.util.HashSet;
import java.util.Set;

public record StoredFieldsSpec(boolean requiresSource, boolean requiresMetadata, Set<String> requiredStoredFields) {
    public static StoredFieldsSpec NO_REQUIREMENTS = new StoredFieldsSpec(false, false, Set.of());
    public static StoredFieldsSpec NEEDS_SOURCE = new StoredFieldsSpec(true, false, Set.of());

    public boolean noRequirements() {
        return !this.requiresSource && !this.requiresMetadata && this.requiredStoredFields.isEmpty();
    }

    public StoredFieldsSpec merge(StoredFieldsSpec other) {
        HashSet<String> mergedFields = new HashSet<String>(this.requiredStoredFields);
        mergedFields.addAll(other.requiredStoredFields);
        return new StoredFieldsSpec(this.requiresSource || other.requiresSource, this.requiresMetadata || other.requiresMetadata, mergedFields);
    }
}

