/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SourceValueFetcherIndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.Field;

public class LeafDocLookup
implements Map<String, ScriptDocValues<?>> {
    private final Function<String, MappedFieldType> fieldTypeLookup;
    private final BiFunction<MappedFieldType, MappedFieldType.FielddataOperation, IndexFieldData<?>> fieldDataLookup;
    private final LeafReaderContext reader;
    private int docId = -1;
    final Map<String, DocValuesScriptFieldFactory> fieldFactoryCache = Maps.newMapWithExpectedSize(4);
    final Map<String, DocValuesScriptFieldFactory> docFactoryCache = Maps.newMapWithExpectedSize(4);

    LeafDocLookup(Function<String, MappedFieldType> fieldTypeLookup, BiFunction<MappedFieldType, MappedFieldType.FielddataOperation, IndexFieldData<?>> fieldDataLookup, LeafReaderContext reader) {
        this.fieldTypeLookup = fieldTypeLookup;
        this.fieldDataLookup = fieldDataLookup;
        this.reader = reader;
    }

    public void setDocument(int docId) {
        this.docId = docId;
    }

    private DocValuesScriptFieldFactory getFactoryForField(final String fieldName) {
        final MappedFieldType fieldType = this.fieldTypeLookup.apply(fieldName);
        if (fieldType == null) {
            throw new IllegalArgumentException("No field found for [" + fieldName + "] in mapping");
        }
        return AccessController.doPrivileged(new PrivilegedAction<DocValuesScriptFieldFactory>(){

            @Override
            public DocValuesScriptFieldFactory run() {
                DocValuesScriptFieldFactory fieldFactory = null;
                IndexFieldData<?> indexFieldData = LeafDocLookup.this.fieldDataLookup.apply(fieldType, MappedFieldType.FielddataOperation.SCRIPT);
                DocValuesScriptFieldFactory docFactory = null;
                if (!LeafDocLookup.this.docFactoryCache.isEmpty()) {
                    docFactory = LeafDocLookup.this.docFactoryCache.get(fieldName);
                }
                fieldFactory = docFactory != null && !(indexFieldData instanceof SourceValueFetcherIndexFieldData) ? docFactory : indexFieldData.load(LeafDocLookup.this.reader).getScriptFieldFactory(fieldName);
                LeafDocLookup.this.fieldFactoryCache.put(fieldName, fieldFactory);
                return fieldFactory;
            }
        });
    }

    public Field<?> getScriptField(String fieldName) {
        DocValuesScriptFieldFactory factory = this.fieldFactoryCache.get(fieldName);
        if (factory == null) {
            factory = this.getFactoryForField(fieldName);
        }
        try {
            factory.setNextDocId(this.docId);
        }
        catch (IOException ioe) {
            throw ExceptionsHelper.convertToElastic(ioe);
        }
        return factory.toScriptField();
    }

    private DocValuesScriptFieldFactory getFactoryForDoc(final String fieldName) {
        final MappedFieldType fieldType = this.fieldTypeLookup.apply(fieldName);
        if (fieldType == null) {
            throw new IllegalArgumentException("No field found for [" + fieldName + "] in mapping");
        }
        return AccessController.doPrivileged(new PrivilegedAction<DocValuesScriptFieldFactory>(){

            @Override
            public DocValuesScriptFieldFactory run() {
                IndexFieldData<?> fieldIndexFieldData;
                DocValuesScriptFieldFactory docFactory = null;
                DocValuesScriptFieldFactory fieldFactory = null;
                if (!LeafDocLookup.this.fieldFactoryCache.isEmpty()) {
                    fieldFactory = LeafDocLookup.this.fieldFactoryCache.get(fieldName);
                }
                if (fieldFactory != null && !((fieldIndexFieldData = LeafDocLookup.this.fieldDataLookup.apply(fieldType, MappedFieldType.FielddataOperation.SCRIPT)) instanceof SourceValueFetcherIndexFieldData)) {
                    docFactory = fieldFactory;
                }
                if (docFactory == null) {
                    IndexFieldData<?> indexFieldData = LeafDocLookup.this.fieldDataLookup.apply(fieldType, MappedFieldType.FielddataOperation.SEARCH);
                    docFactory = indexFieldData.load(LeafDocLookup.this.reader).getScriptFieldFactory(fieldName);
                }
                LeafDocLookup.this.docFactoryCache.put(fieldName, docFactory);
                return docFactory;
            }
        });
    }

    @Override
    public ScriptDocValues<?> get(Object key) {
        String fieldName = key.toString();
        DocValuesScriptFieldFactory factory = this.docFactoryCache.get(fieldName);
        if (factory == null) {
            factory = this.getFactoryForDoc(key.toString());
        }
        try {
            factory.setNextDocId(this.docId);
        }
        catch (IOException ioe) {
            throw ExceptionsHelper.convertToElastic(ioe);
        }
        return factory.toScriptDocValues();
    }

    @Override
    public boolean containsKey(Object key) {
        String fieldName = key.toString();
        return this.docFactoryCache.containsKey(key) || this.fieldFactoryCache.containsKey(key) || this.fieldTypeLookup.apply(fieldName) != null;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScriptDocValues<?> put(String key, ScriptDocValues<?> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScriptDocValues<?> remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends ScriptDocValues<?>> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<ScriptDocValues<?>> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, ScriptDocValues<?>>> entrySet() {
        throw new UnsupportedOperationException();
    }
}

