/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.transport.Compression;
import org.elasticsearch.transport.TransportStatus;

public abstract class NetworkMessage {
    protected final TransportVersion version;
    protected final Writeable threadContext;
    protected final long requestId;
    protected final byte status;
    protected final Compression.Scheme compressionScheme;

    NetworkMessage(ThreadContext threadContext, TransportVersion version, byte status, long requestId, Compression.Scheme compressionScheme) {
        this.threadContext = threadContext.captureAsWriteable();
        this.version = version;
        this.requestId = requestId;
        this.compressionScheme = NetworkMessage.adjustedScheme(version, compressionScheme);
        this.status = this.compressionScheme != null ? TransportStatus.setCompress(status) : status;
    }

    public TransportVersion getVersion() {
        return this.version;
    }

    public long getRequestId() {
        return this.requestId;
    }

    boolean isCompress() {
        return TransportStatus.isCompress(this.status);
    }

    boolean isResponse() {
        return !TransportStatus.isRequest(this.status);
    }

    boolean isRequest() {
        return TransportStatus.isRequest(this.status);
    }

    boolean isHandshake() {
        return TransportStatus.isHandshake(this.status);
    }

    boolean isError() {
        return TransportStatus.isError(this.status);
    }

    private static Compression.Scheme adjustedScheme(TransportVersion version, Compression.Scheme compressionScheme) {
        return compressionScheme == Compression.Scheme.LZ4 && version.before(Compression.Scheme.LZ4_VERSION) ? null : compressionScheme;
    }
}

