/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.Closeable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.transport.Compression;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.ProxyConnectionStrategy;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.RemoteConnectionInfo;
import org.elasticsearch.transport.RemoteConnectionManager;
import org.elasticsearch.transport.SniffConnectionStrategy;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportConnectionListener;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.TransportSettings;

public abstract class RemoteConnectionStrategy
implements TransportConnectionListener,
Closeable {
    public static final Setting.AffixSetting<ConnectionStrategy> REMOTE_CONNECTION_MODE = Setting.affixKeySetting("cluster.remote.", "mode", key -> new Setting<ConnectionStrategy>((String)key, ConnectionStrategy.SNIFF.name(), value -> ConnectionStrategy.valueOf(value.toUpperCase(Locale.ROOT)), Setting.Property.NodeScope, Setting.Property.Dynamic), new Setting.AffixSettingDependency[0]);
    public static final Setting<Integer> REMOTE_MAX_PENDING_CONNECTION_LISTENERS = Setting.intSetting("cluster.remote.max_pending_connection_listeners", 1000, Setting.Property.NodeScope);
    private final int maxPendingConnectionListeners;
    protected final Logger logger = LogManager.getLogger(this.getClass());
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Object mutex = new Object();
    private List<ActionListener<Void>> listeners = new ArrayList<ActionListener<Void>>();
    protected final TransportService transportService;
    protected final RemoteConnectionManager connectionManager;
    protected final String clusterAlias;

    RemoteConnectionStrategy(String clusterAlias, TransportService transportService, RemoteConnectionManager connectionManager, Settings settings) {
        this.clusterAlias = clusterAlias;
        this.transportService = transportService;
        this.connectionManager = connectionManager;
        this.maxPendingConnectionListeners = REMOTE_MAX_PENDING_CONNECTION_LISTENERS.get(settings);
        connectionManager.addListener(this);
    }

    static ConnectionProfile buildConnectionProfile(String clusterAlias, Settings settings) {
        String transportProfile = RemoteClusterService.REMOTE_CLUSTER_AUTHORIZATION.getConcreteSettingForNamespace(clusterAlias).exists(settings) ? "_remote_cluster" : "default";
        ConnectionStrategy mode = REMOTE_CONNECTION_MODE.getConcreteSettingForNamespace(clusterAlias).get(settings);
        ConnectionProfile.Builder builder = new ConnectionProfile.Builder().setConnectTimeout(TransportSettings.CONNECT_TIMEOUT.get(settings)).setHandshakeTimeout(TransportSettings.CONNECT_TIMEOUT.get(settings)).setCompressionEnabled(RemoteClusterService.REMOTE_CLUSTER_COMPRESS.getConcreteSettingForNamespace(clusterAlias).get(settings)).setCompressionScheme(RemoteClusterService.REMOTE_CLUSTER_COMPRESSION_SCHEME.getConcreteSettingForNamespace(clusterAlias).get(settings)).setPingInterval(RemoteClusterService.REMOTE_CLUSTER_PING_SCHEDULE.getConcreteSettingForNamespace(clusterAlias).get(settings)).addConnections(0, TransportRequestOptions.Type.BULK, TransportRequestOptions.Type.STATE, TransportRequestOptions.Type.RECOVERY, TransportRequestOptions.Type.PING).addConnections(mode.numberOfChannels, TransportRequestOptions.Type.REG).setTransportProfile(transportProfile);
        return builder.build();
    }

    static RemoteConnectionStrategy buildStrategy(String clusterAlias, TransportService transportService, RemoteConnectionManager connectionManager, Settings settings) {
        ConnectionStrategy mode = REMOTE_CONNECTION_MODE.getConcreteSettingForNamespace(clusterAlias).get(settings);
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case ConnectionStrategy.SNIFF -> new SniffConnectionStrategy(clusterAlias, transportService, connectionManager, settings);
            case ConnectionStrategy.PROXY -> new ProxyConnectionStrategy(clusterAlias, transportService, connectionManager, settings);
        };
    }

    static Set<String> getRemoteClusters(Settings settings) {
        Stream enablementSettings = Arrays.stream(ConnectionStrategy.values()).flatMap(strategy -> strategy.getEnablementSettings().get());
        return enablementSettings.flatMap(s -> RemoteConnectionStrategy.getClusterAlias(settings, s)).collect(Collectors.toSet());
    }

    public static boolean isConnectionEnabled(String clusterAlias, Settings settings) {
        ConnectionStrategy mode = REMOTE_CONNECTION_MODE.getConcreteSettingForNamespace(clusterAlias).get(settings);
        if (mode.equals((Object)ConnectionStrategy.SNIFF)) {
            List<String> seeds = SniffConnectionStrategy.REMOTE_CLUSTER_SEEDS.getConcreteSettingForNamespace(clusterAlias).get(settings);
            return !seeds.isEmpty();
        }
        String address = ProxyConnectionStrategy.PROXY_ADDRESS.getConcreteSettingForNamespace(clusterAlias).get(settings);
        return !org.elasticsearch.common.Strings.isEmpty(address);
    }

    public static boolean isConnectionEnabled(String clusterAlias, Map<Setting<?>, Object> settings) {
        ConnectionStrategy mode = (ConnectionStrategy)((Object)settings.get(REMOTE_CONNECTION_MODE.getConcreteSettingForNamespace(clusterAlias)));
        if (mode.equals((Object)ConnectionStrategy.SNIFF)) {
            List seeds = (List)settings.get(SniffConnectionStrategy.REMOTE_CLUSTER_SEEDS.getConcreteSettingForNamespace(clusterAlias));
            return !seeds.isEmpty();
        }
        String address = (String)settings.get(ProxyConnectionStrategy.PROXY_ADDRESS.getConcreteSettingForNamespace(clusterAlias));
        return !org.elasticsearch.common.Strings.isEmpty(address);
    }

    private static <T> Stream<String> getClusterAlias(Settings settings, Setting.AffixSetting<T> affixSetting) {
        Stream<Setting<Setting>> allConcreteSettings = affixSetting.getAllConcreteSettings(settings);
        return allConcreteSettings.map(affixSetting::getNamespace);
    }

    static InetSocketAddress parseConfiguredAddress(String configuredAddress) {
        InetAddress hostAddress;
        String host = RemoteConnectionStrategy.parseHost(configuredAddress);
        int port = RemoteConnectionStrategy.parsePort(configuredAddress);
        try {
            hostAddress = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("unknown host [" + host + "]", e);
        }
        return new InetSocketAddress(hostAddress, port);
    }

    static String parseHost(String configuredAddress) {
        return configuredAddress.substring(0, RemoteConnectionStrategy.indexOfPortSeparator(configuredAddress));
    }

    static int parsePort(String remoteHost) {
        try {
            int port = Integer.parseInt(remoteHost.substring(RemoteConnectionStrategy.indexOfPortSeparator(remoteHost) + 1));
            if (port <= 0) {
                throw new IllegalArgumentException("port number must be > 0 but was: [" + port + "]");
            }
            return port;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("failed to parse port", e);
        }
    }

    private static int indexOfPortSeparator(String remoteHost) {
        int portSeparator = remoteHost.lastIndexOf(58);
        if (portSeparator == -1 || portSeparator == remoteHost.length()) {
            throw new IllegalArgumentException("remote hosts need to be configured as [host:port], found [" + remoteHost + "] instead");
        }
        return portSeparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connect(ActionListener<Void> connectListener) {
        boolean isCurrentlyClosed;
        boolean runConnect = false;
        ContextPreservingActionListener<Void> listener = ContextPreservingActionListener.wrapPreservingContext(connectListener, this.transportService.getThreadPool().getThreadContext());
        Object object = this.mutex;
        synchronized (object) {
            isCurrentlyClosed = this.closed.get();
            if (isCurrentlyClosed) {
                assert (this.listeners.isEmpty());
            } else {
                if (this.listeners.size() >= this.maxPendingConnectionListeners) {
                    assert (this.listeners.size() == this.maxPendingConnectionListeners);
                    listener.onFailure(new EsRejectedExecutionException("connect listener queue is full"));
                    return;
                }
                this.listeners.add(listener);
                runConnect = this.listeners.size() == 1;
            }
        }
        if (isCurrentlyClosed) {
            connectListener.onFailure((Exception)((Object)new AlreadyClosedException("connect handler is already closed")));
            return;
        }
        if (runConnect) {
            ExecutorService executor = this.transportService.getThreadPool().executor("management");
            executor.submit(new AbstractRunnable(){

                @Override
                public void onFailure(Exception e) {
                    ActionListener.onFailure(RemoteConnectionStrategy.this.getAndClearListeners(), e);
                }

                @Override
                protected void doRun() {
                    RemoteConnectionStrategy.this.connectImpl(new ActionListener<Void>(){

                        @Override
                        public void onResponse(Void aVoid) {
                            ActionListener.onResponse(RemoteConnectionStrategy.this.getAndClearListeners(), aVoid);
                        }

                        @Override
                        public void onFailure(Exception e) {
                            ActionListener.onFailure(RemoteConnectionStrategy.this.getAndClearListeners(), e);
                        }
                    });
                }
            });
        }
    }

    boolean shouldRebuildConnection(Settings newSettings) {
        ConnectionStrategy newMode = REMOTE_CONNECTION_MODE.getConcreteSettingForNamespace(this.clusterAlias).get(newSettings);
        if (!newMode.equals((Object)this.strategyType())) {
            return true;
        }
        Compression.Enabled compressionEnabled = RemoteClusterService.REMOTE_CLUSTER_COMPRESS.getConcreteSettingForNamespace(this.clusterAlias).get(newSettings);
        Compression.Scheme compressionScheme = RemoteClusterService.REMOTE_CLUSTER_COMPRESSION_SCHEME.getConcreteSettingForNamespace(this.clusterAlias).get(newSettings);
        TimeValue pingSchedule = RemoteClusterService.REMOTE_CLUSTER_PING_SCHEDULE.getConcreteSettingForNamespace(this.clusterAlias).get(newSettings);
        ConnectionProfile oldProfile = this.connectionManager.getConnectionProfile();
        ConnectionProfile.Builder builder = new ConnectionProfile.Builder(oldProfile);
        builder.setCompressionEnabled(compressionEnabled);
        builder.setCompressionScheme(compressionScheme);
        builder.setPingInterval(pingSchedule);
        ConnectionProfile newProfile = builder.build();
        return RemoteConnectionStrategy.connectionProfileChanged(oldProfile, newProfile) || this.strategyMustBeRebuilt(newSettings);
    }

    protected abstract boolean strategyMustBeRebuilt(Settings var1);

    protected abstract ConnectionStrategy strategyType();

    @Override
    public void onNodeDisconnected(DiscoveryNode node, Transport.Connection connection) {
        if (this.shouldOpenMoreConnections()) {
            this.connect(ActionListener.wrap(ignore -> this.logger.trace("[{}] successfully connected after disconnect of {}", (Object)this.clusterAlias, (Object)node), e -> this.logger.debug(() -> Strings.format((String)"[%s] failed to connect after disconnect of %s", (Object[])new Object[]{this.clusterAlias, node}), (Throwable)e)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        List<ActionListener<Object>> toNotify;
        Object object = this.mutex;
        synchronized (object) {
            if (this.closed.compareAndSet(false, true)) {
                this.connectionManager.removeListener(this);
                toNotify = this.listeners;
                this.listeners = Collections.emptyList();
            } else {
                toNotify = Collections.emptyList();
            }
        }
        ActionListener.onFailure(toNotify, (Exception)((Object)new AlreadyClosedException("connect handler is already closed")));
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean assertNoRunningConnections() {
        Object object = this.mutex;
        synchronized (object) {
            assert (this.listeners.isEmpty());
        }
        return true;
    }

    protected abstract boolean shouldOpenMoreConnections();

    protected abstract void connectImpl(ActionListener<Void> var1);

    protected abstract RemoteConnectionInfo.ModeInfo getModeInfo();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ActionListener<Void>> getAndClearListeners() {
        List<ActionListener<Void>> result;
        Object object = this.mutex;
        synchronized (object) {
            if (this.listeners.isEmpty()) {
                result = Collections.emptyList();
            } else {
                result = this.listeners;
                this.listeners = new ArrayList<ActionListener<Void>>();
            }
        }
        return result;
    }

    private static boolean connectionProfileChanged(ConnectionProfile oldProfile, ConnectionProfile newProfile) {
        return !Objects.equals((Object)oldProfile.getCompressionEnabled(), (Object)newProfile.getCompressionEnabled()) || !Objects.equals(oldProfile.getPingInterval(), newProfile.getPingInterval()) || !Objects.equals((Object)oldProfile.getCompressionScheme(), (Object)newProfile.getCompressionScheme());
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum ConnectionStrategy {
        SNIFF(6, SniffConnectionStrategy::enablementSettings, SniffConnectionStrategy::infoReader){

            public String toString() {
                return "sniff";
            }
        }
        ,
        PROXY(1, ProxyConnectionStrategy::enablementSettings, ProxyConnectionStrategy::infoReader){

            public String toString() {
                return "proxy";
            }
        };

        private final int numberOfChannels;
        private final Supplier<Stream<Setting.AffixSetting<?>>> enablementSettings;
        private final Supplier<Writeable.Reader<RemoteConnectionInfo.ModeInfo>> reader;

        private ConnectionStrategy(int numberOfChannels, Supplier<Stream<Setting.AffixSetting<?>>> enablementSettings, Supplier<Writeable.Reader<RemoteConnectionInfo.ModeInfo>> reader) {
            this.numberOfChannels = numberOfChannels;
            this.enablementSettings = enablementSettings;
            this.reader = reader;
        }

        public int getNumberOfChannels() {
            return this.numberOfChannels;
        }

        public Supplier<Stream<Setting.AffixSetting<?>>> getEnablementSettings() {
            return this.enablementSettings;
        }

        public Writeable.Reader<RemoteConnectionInfo.ModeInfo> getReader() {
            return this.reader.get();
        }
    }

    static class StrategyValidator<T>
    implements Setting.Validator<T> {
        private final String key;
        private final ConnectionStrategy expectedStrategy;
        private final String namespace;
        private final Consumer<T> valueChecker;

        StrategyValidator(String namespace, String key, ConnectionStrategy expectedStrategy) {
            this(namespace, key, expectedStrategy, v -> {});
        }

        StrategyValidator(String namespace, String key, ConnectionStrategy expectedStrategy, Consumer<T> valueChecker) {
            this.namespace = namespace;
            this.key = key;
            this.expectedStrategy = expectedStrategy;
            this.valueChecker = valueChecker;
        }

        @Override
        public void validate(T value) {
            this.valueChecker.accept(value);
        }

        @Override
        public void validate(T value, Map<Setting<?>, Object> settings, boolean isPresent) {
            Setting<ConnectionStrategy> concrete = REMOTE_CONNECTION_MODE.getConcreteSettingForNamespace(this.namespace);
            ConnectionStrategy modeType = (ConnectionStrategy)((Object)settings.get(concrete));
            if (isPresent && !modeType.equals((Object)this.expectedStrategy)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Setting \"%s\" cannot be used with the configured \"%s\" [required=%s, configured=%s]", this.key, concrete.getKey(), this.expectedStrategy.name(), modeType.name()));
            }
        }

        @Override
        public Iterator<Setting<?>> settings() {
            Setting<ConnectionStrategy> concrete = REMOTE_CONNECTION_MODE.getConcreteSettingForNamespace(this.namespace);
            Stream<Setting<ConnectionStrategy>> settingStream = Stream.of(concrete);
            return settingStream.iterator();
        }
    }
}

