/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamOutput;

public class TcpHeader {
    public static final TransportVersion VERSION_WITH_HEADER_SIZE = TransportVersion.V_7_6_0;
    public static final int MARKER_BYTES_SIZE = 2;
    public static final int MESSAGE_LENGTH_SIZE = 4;
    public static final int REQUEST_ID_SIZE = 8;
    public static final int STATUS_SIZE = 1;
    public static final int VERSION_ID_SIZE = 4;
    public static final int VARIABLE_HEADER_SIZE = 4;
    public static final int BYTES_REQUIRED_FOR_MESSAGE_SIZE = 6;
    public static final int VERSION_POSITION = 15;
    public static final int VARIABLE_HEADER_SIZE_POSITION = 19;
    private static final int PRE_76_HEADER_SIZE = 19;
    public static final int BYTES_REQUIRED_FOR_VERSION = 19;
    private static final int HEADER_SIZE = 23;
    private static final byte[] PREFIX = new byte[]{69, 83};

    public static int headerSize(TransportVersion version) {
        if (version.onOrAfter(VERSION_WITH_HEADER_SIZE)) {
            return 23;
        }
        return 19;
    }

    public static void writeHeader(StreamOutput output, long requestId, byte status, TransportVersion version, int contentSize, int variableHeaderSize) throws IOException {
        output.writeBytes(PREFIX);
        if (version.onOrAfter(VERSION_WITH_HEADER_SIZE)) {
            output.writeInt(contentSize + 8 + 1 + 4 + 4);
        } else {
            output.writeInt(contentSize + 8 + 1 + 4);
        }
        output.writeLong(requestId);
        output.writeByte(status);
        output.writeInt(version.id);
        if (version.onOrAfter(VERSION_WITH_HEADER_SIZE)) {
            assert (variableHeaderSize != -1) : "Variable header size not set";
            output.writeInt(variableHeaderSize);
        }
    }
}

