/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.EOFException;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;

final class TransportHandshaker {
    static final String HANDSHAKE_ACTION_NAME = "internal:tcp/handshake";
    private final ConcurrentMap<Long, HandshakeResponseHandler> pendingHandshakes = new ConcurrentHashMap<Long, HandshakeResponseHandler>();
    private final CounterMetric numHandshakes = new CounterMetric();
    private final TransportVersion version;
    private final ThreadPool threadPool;
    private final HandshakeRequestSender handshakeRequestSender;
    private final boolean ignoreDeserializationErrors;

    TransportHandshaker(TransportVersion version, ThreadPool threadPool, HandshakeRequestSender handshakeRequestSender, boolean ignoreDeserializationErrors) {
        this.version = version;
        this.threadPool = threadPool;
        this.handshakeRequestSender = handshakeRequestSender;
        this.ignoreDeserializationErrors = ignoreDeserializationErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendHandshake(long requestId, DiscoveryNode node, TcpChannel channel, TimeValue timeout, ActionListener<TransportVersion> listener) {
        block5: {
            this.numHandshakes.inc();
            HandshakeResponseHandler handler = new HandshakeResponseHandler(requestId, this.version, listener);
            this.pendingHandshakes.put(requestId, handler);
            channel.addCloseListener(ActionListener.wrap(() -> handler.handleLocalException(new TransportException("handshake failed because connection reset"))));
            boolean success = false;
            try {
                TransportVersion minCompatVersion = this.version.calculateMinimumCompatVersion();
                this.handshakeRequestSender.sendRequest(node, channel, requestId, minCompatVersion);
                this.threadPool.schedule(() -> handler.handleLocalException(new ConnectTransportException(node, "handshake_timeout[" + timeout + "]")), timeout, "generic");
                success = true;
            }
            catch (Exception e) {
                handler.handleLocalException(new ConnectTransportException(node, "failure to send internal:tcp/handshake", e));
            }
            finally {
                if (success) break block5;
                TransportResponseHandler removed = (TransportResponseHandler)this.pendingHandshakes.remove(requestId);
                if ($assertionsDisabled || removed == null) break block5;
                throw new AssertionError((Object)"Handshake should not be pending if exception was thrown");
            }
        }
    }

    void handleHandshake(TransportChannel channel, long requestId, StreamInput stream) throws IOException {
        try {
            new HandshakeRequest(stream);
        }
        catch (Exception e) {
            assert (this.ignoreDeserializationErrors) : e;
            throw e;
        }
        int nextByte = stream.read();
        if (nextByte != -1) {
            IllegalStateException exception = new IllegalStateException("Handshake request not fully read for requestId [" + requestId + "], action [internal:tcp/handshake], available [" + stream.available() + "]; resetting");
            assert (this.ignoreDeserializationErrors) : exception;
            throw exception;
        }
        channel.sendResponse(new HandshakeResponse(this.version));
    }

    TransportResponseHandler<HandshakeResponse> removeHandlerForHandshake(long requestId) {
        return (TransportResponseHandler)this.pendingHandshakes.remove(requestId);
    }

    int getNumPendingHandshakes() {
        return this.pendingHandshakes.size();
    }

    long getNumHandshakes() {
        return this.numHandshakes.count();
    }

    @FunctionalInterface
    static interface HandshakeRequestSender {
        public void sendRequest(DiscoveryNode var1, TcpChannel var2, long var3, TransportVersion var5) throws IOException;
    }

    private class HandshakeResponseHandler
    implements TransportResponseHandler<HandshakeResponse> {
        private final long requestId;
        private final TransportVersion currentVersion;
        private final ActionListener<TransportVersion> listener;
        private final AtomicBoolean isDone = new AtomicBoolean(false);

        private HandshakeResponseHandler(long requestId, TransportVersion currentVersion, ActionListener<TransportVersion> listener) {
            this.requestId = requestId;
            this.currentVersion = currentVersion;
            this.listener = listener;
        }

        @Override
        public HandshakeResponse read(StreamInput in) throws IOException {
            return new HandshakeResponse(in);
        }

        @Override
        public void handleResponse(HandshakeResponse response) {
            if (this.isDone.compareAndSet(false, true)) {
                TransportVersion responseVersion = response.responseVersion;
                if (!this.currentVersion.isCompatible(responseVersion)) {
                    this.listener.onFailure(new IllegalStateException("Received message from unsupported version: [" + responseVersion + "] minimal compatible version is: [" + this.currentVersion.calculateMinimumCompatVersion() + "]"));
                } else {
                    this.listener.onResponse(responseVersion);
                }
            }
        }

        @Override
        public void handleException(TransportException e) {
            if (this.isDone.compareAndSet(false, true)) {
                this.listener.onFailure(new IllegalStateException("handshake failed", e));
            }
        }

        void handleLocalException(TransportException e) {
            if (TransportHandshaker.this.removeHandlerForHandshake(this.requestId) != null && this.isDone.compareAndSet(false, true)) {
                this.listener.onFailure(e);
            }
        }
    }

    static final class HandshakeRequest
    extends TransportRequest {
        private final TransportVersion version;

        HandshakeRequest(TransportVersion version) {
            this.version = version;
        }

        HandshakeRequest(StreamInput streamInput) throws IOException {
            super(streamInput);
            BytesReference remainingMessage;
            try {
                remainingMessage = streamInput.readBytesReference();
            }
            catch (EOFException e) {
                remainingMessage = null;
            }
            if (remainingMessage == null) {
                this.version = null;
            } else {
                try (StreamInput messageStreamInput = remainingMessage.streamInput();){
                    this.version = TransportVersion.readVersion(messageStreamInput);
                }
            }
        }

        @Override
        public void writeTo(StreamOutput streamOutput) throws IOException {
            super.writeTo(streamOutput);
            assert (this.version != null);
            try (BytesStreamOutput messageStreamOutput = new BytesStreamOutput(4);){
                TransportVersion.writeVersion(this.version, messageStreamOutput);
                BytesReference reference = messageStreamOutput.bytes();
                streamOutput.writeBytesReference(reference);
            }
        }
    }

    static final class HandshakeResponse
    extends TransportResponse {
        private final TransportVersion responseVersion;

        HandshakeResponse(TransportVersion responseVersion) {
            this.responseVersion = responseVersion;
        }

        private HandshakeResponse(StreamInput in) throws IOException {
            super(in);
            this.responseVersion = TransportVersion.readVersion(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            assert (this.responseVersion != null);
            TransportVersion.writeVersion(this.responseVersion, out);
        }

        TransportVersion getResponseVersion() {
            return this.responseVersion;
        }
    }
}

