/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.branch.pr.ws;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.BranchDto;
import org.sonar.db.component.BranchType;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.branch.pr.ws.PullRequestWsAction;
import org.sonar.server.branch.pr.ws.PullRequestsWs;
import org.sonar.server.component.ComponentCleanerService;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.user.UserSession;

public class DeleteAction
implements PullRequestWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final ComponentCleanerService componentCleanerService;
    private final ComponentFinder componentFinder;

    public DeleteAction(DbClient dbClient, ComponentFinder componentFinder, UserSession userSession, ComponentCleanerService componentCleanerService) {
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
        this.userSession = userSession;
        this.componentCleanerService = componentCleanerService;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("delete").setSince("7.1").setDescription("Delete a pull request.<br/>Requires 'Administer' rights on the specified project.").setPost(true).setHandler((RequestHandler)this);
        PullRequestsWs.addProjectParam(action);
        PullRequestsWs.addPullRequestParam(action);
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        String projectKey = request.mandatoryParam("project");
        String pullRequestId = request.mandatoryParam("pullRequest");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto project = this.componentFinder.getRootComponentByUuidOrKey(dbSession, null, projectKey);
            this.checkPermission(project);
            BranchDto pullRequest = this.dbClient.branchDao().selectByPullRequestKey(dbSession, project.uuid(), pullRequestId).filter(branch -> branch.getBranchType() == BranchType.PULL_REQUEST).orElseThrow(() -> new NotFoundException(String.format("Pull request '%s' is not found for project '%s'", pullRequestId, projectKey)));
            ComponentDto branchComponent = this.componentFinder.getByKeyAndPullRequest(dbSession, projectKey, pullRequest.getKey());
            this.componentCleanerService.deleteBranch(dbSession, branchComponent);
            response.noContent();
        }
    }

    private void checkPermission(ComponentDto project) {
        this.userSession.checkComponentPermission("admin", project);
    }
}

