/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.duplication.ws;

import com.google.common.annotations.VisibleForTesting;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.server.ServerSide;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDao;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.duplication.ws.Duplication;

@ServerSide
public class DuplicationsParser {
    private static final BlockComparator BLOCK_COMPARATOR = new BlockComparator();
    private final ComponentDao componentDao;

    public DuplicationsParser(ComponentDao componentDao) {
        this.componentDao = componentDao;
    }

    public List<Block> parse(DbSession session, ComponentDto component, @Nullable String branch, @Nullable String pullRequest, @Nullable String duplicationsData) {
        LinkedHashMap<String, ComponentDto> componentsByKey = new LinkedHashMap<String, ComponentDto>();
        ArrayList<Block> blocks = new ArrayList<Block>();
        if (duplicationsData == null) {
            return blocks;
        }
        DuplicationComparator duplicationComparator = new DuplicationComparator(component.uuid(), component.projectUuid());
        try {
            SMInputFactory inputFactory = DuplicationsParser.initStax();
            SMHierarchicCursor root = inputFactory.rootElementCursor((Reader)new StringReader(duplicationsData));
            root.advance();
            SMInputCursor cursor = root.childElementCursor("g");
            while (cursor.getNext() != null) {
                ArrayList<Duplication> duplications = new ArrayList<Duplication>();
                SMInputCursor bCursor = cursor.childElementCursor("b");
                while (bCursor.getNext() != null) {
                    String from = bCursor.getAttrValue("s");
                    String size = bCursor.getAttrValue("l");
                    boolean disableLink = Boolean.parseBoolean(bCursor.getAttrValue("t"));
                    String componentDbKey = bCursor.getAttrValue("r");
                    if (from == null || size == null || componentDbKey == null) continue;
                    if (disableLink) {
                        duplications.add(Duplication.newTextComponent(componentDbKey, Integer.valueOf(from), Integer.valueOf(size)));
                        continue;
                    }
                    duplications.add(this.createDuplication(componentsByKey, branch, pullRequest, from, size, componentDbKey, session));
                }
                duplications.sort(duplicationComparator);
                blocks.add(new Block(duplications));
            }
            blocks.sort(BLOCK_COMPARATOR);
            return blocks;
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("XML is not valid", e);
        }
    }

    private Duplication createDuplication(Map<String, ComponentDto> componentsByKey, @Nullable String branch, @Nullable String pullRequest, String from, String size, String componentDbKey, DbSession session) {
        ComponentDto component;
        String componentKey = DuplicationsParser.convertToKey(componentDbKey);
        if (componentsByKey.containsKey(componentKey)) {
            component = componentsByKey.get(componentKey);
        } else {
            component = this.loadComponent(session, componentKey, branch, pullRequest);
            componentsByKey.put(componentKey, component);
        }
        if (component != null) {
            return Duplication.newComponent(component, Integer.valueOf(from), Integer.valueOf(size));
        }
        return Duplication.newRemovedComponent(componentKey, Integer.valueOf(from), Integer.valueOf(size));
    }

    @CheckForNull
    private ComponentDto loadComponent(DbSession session, String componentKey, @Nullable String branch, @Nullable String pullRequest) {
        if (branch != null) {
            return this.componentDao.selectByKeyAndBranch(session, componentKey, branch).orElse(null);
        }
        if (pullRequest != null) {
            return this.componentDao.selectByKeyAndPullRequest(session, componentKey, pullRequest).orElse(null);
        }
        return this.componentDao.selectByKey(session, componentKey).orElse(null);
    }

    private static String convertToKey(String dbKey) {
        return new ComponentDto().setDbKey(dbKey).getKey();
    }

    private static SMInputFactory initStax() {
        XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
        xmlFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        xmlFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        return new SMInputFactory(xmlFactory);
    }

    static class Block {
        private final List<Duplication> duplications;

        public Block(List<Duplication> duplications) {
            this.duplications = duplications;
        }

        public List<Duplication> getDuplications() {
            return this.duplications;
        }
    }

    private static class BlockComparator
    implements Comparator<Block>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private BlockComparator() {
        }

        @Override
        public int compare(@Nullable Block b1, @Nullable Block b2) {
            if (b1 == null || b2 == null) {
                return -1;
            }
            List<Duplication> duplications1 = b1.getDuplications();
            List<Duplication> duplications2 = b2.getDuplications();
            if (duplications1.isEmpty() || duplications2.isEmpty()) {
                return -1;
            }
            return duplications1.get(0).from().compareTo(duplications2.get(0).from());
        }
    }

    @VisibleForTesting
    static class DuplicationComparator
    implements Comparator<Duplication>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String fileUuid;
        private final String projectUuid;

        DuplicationComparator(String fileUuid, String projectUuid) {
            this.fileUuid = fileUuid;
            this.projectUuid = projectUuid;
        }

        @Override
        public int compare(@Nullable Duplication d1, @Nullable Duplication d2) {
            if (d1 == null || d2 == null) {
                return -1;
            }
            ComponentDto file1 = d1.componentDto();
            ComponentDto file2 = d2.componentDto();
            if (file1 != null && file1.equals((Object)file2)) {
                return d1.from().compareTo(d2.from());
            }
            if (this.sameFile(file1) && !this.sameFile(file2)) {
                return -1;
            }
            if (this.sameFile(file2) && !this.sameFile(file1)) {
                return 1;
            }
            if (this.sameProject(file1) && !this.sameProject(file2)) {
                return -1;
            }
            if (this.sameProject(file2) && !this.sameProject(file1)) {
                return 1;
            }
            return d1.from().compareTo(d2.from());
        }

        private boolean sameFile(@Nullable ComponentDto otherDto) {
            return otherDto != null && StringUtils.equals((String)otherDto.uuid(), (String)this.fileUuid);
        }

        private boolean sameProject(@Nullable ComponentDto otherDto) {
            return otherDto == null || StringUtils.equals((String)otherDto.projectUuid(), (String)this.projectUuid);
        }
    }
}

