/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.ws;

import com.google.common.io.Resources;
import java.util.Collection;
import java.util.Date;
import org.sonar.api.rule.Severity;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.issue.IssueDto;
import org.sonar.server.issue.IssueFieldsSetter;
import org.sonar.server.issue.IssueFinder;
import org.sonar.server.issue.IssueUpdater;
import org.sonar.server.issue.ws.IssuesWsAction;
import org.sonar.server.issue.ws.OperationResponseWriter;
import org.sonar.server.issue.ws.SearchResponseData;
import org.sonar.server.user.UserSession;

public class SetSeverityAction
implements IssuesWsAction {
    private final UserSession userSession;
    private final DbClient dbClient;
    private final IssueFinder issueFinder;
    private final IssueFieldsSetter issueFieldsSetter;
    private final IssueUpdater issueUpdater;
    private final OperationResponseWriter responseWriter;

    public SetSeverityAction(UserSession userSession, DbClient dbClient, IssueFinder issueFinder, IssueFieldsSetter issueFieldsSetter, IssueUpdater issueUpdater, OperationResponseWriter responseWriter) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.issueFinder = issueFinder;
        this.issueFieldsSetter = issueFieldsSetter;
        this.issueUpdater = issueUpdater;
        this.responseWriter = responseWriter;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("set_severity").setDescription("Change severity.<br/>Requires the following permissions:<ul>  <li>'Authentication'</li>  <li>'Browse' rights on project of the specified issue</li>  <li>'Administer Issues' rights on project of the specified issue</li></ul>").setSince("3.6").setChangelog(new Change[]{new Change("6.5", "the database ids of the components are removed from the response"), new Change("6.5", "the response field components.uuid is deprecated. Use components.key instead.")}).setHandler((RequestHandler)this).setResponseExample(Resources.getResource(this.getClass(), (String)"set_severity-example.json")).setPost(true);
        action.createParam("issue").setDescription("Issue key").setRequired(true).setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam("severity").setDescription("New severity").setRequired(true).setPossibleValues((Collection)Severity.ALL);
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        String issueKey = request.mandatoryParam("issue");
        String severity = request.mandatoryParam("severity");
        try (DbSession session = this.dbClient.openSession(false);){
            SearchResponseData preloadedSearchResponseData = this.setType(session, issueKey, severity);
            this.responseWriter.write(issueKey, preloadedSearchResponseData, request, response);
        }
    }

    private SearchResponseData setType(DbSession session, String issueKey, String severity) {
        IssueDto issueDto = this.issueFinder.getByKey(session, issueKey);
        DefaultIssue issue = issueDto.toDefaultIssue();
        this.userSession.checkComponentUuidPermission("issueadmin", issue.projectUuid());
        IssueChangeContext context = IssueChangeContext.createUser((Date)new Date(), (String)this.userSession.getUuid());
        if (this.issueFieldsSetter.setManualSeverity(issue, severity, context)) {
            return this.issueUpdater.saveIssueAndPreloadSearchResponseData(session, issue, context, true);
        }
        return new SearchResponseData(issueDto);
    }
}

