/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.ws;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.BranchType;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.measure.LiveMeasureDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.db.metric.MetricDtoFunctions;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.measure.ws.ComponentDtoToWsComponent;
import org.sonar.server.measure.ws.MeasuresWsAction;
import org.sonar.server.measure.ws.MeasuresWsParametersBuilder;
import org.sonar.server.measure.ws.MetricDtoToWsMetric;
import org.sonar.server.measure.ws.MetricDtoWithBestValue;
import org.sonar.server.measure.ws.SLBorPRMeasureFix;
import org.sonar.server.measure.ws.SnapshotDtoToWsPeriod;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Measures;

public class ComponentAction
implements MeasuresWsAction {
    private static final Set<String> QUALIFIERS_ELIGIBLE_FOR_BEST_VALUE = ImmutableSortedSet.of((Comparable)((Object)"FIL"), (Comparable)((Object)"UTS"));
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;
    private final UserSession userSession;

    public ComponentAction(DbClient dbClient, ComponentFinder componentFinder, UserSession userSession) {
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("component").setDescription(String.format("Return component with specified measures. The %s or the %s parameter must be provided.<br>Requires the following permission: 'Browse' on the project of specified component.", "componentId", "component")).setResponseExample(this.getClass().getResource("component-example.json")).setSince("5.4").setChangelog(new Change[]{new Change("7.6", String.format("The use of module keys in parameter '%s' is deprecated", "component")), new Change("6.6", "the response field id is deprecated. Use key instead."), new Change("6.6", "the response field refId is deprecated. Use refKey instead.")}).setHandler((RequestHandler)this);
        action.createParam("component").setDescription("Component key").setExampleValue((Object)"my_project").setDeprecatedKey("componentKey", "6.6");
        action.createParam("componentId").setDescription("Component id").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy").setDeprecatedSince("6.6");
        action.createParam("branch").setDescription("Branch key").setExampleValue((Object)"feature/my_branch").setInternal(true).setSince("6.6");
        action.createParam("pullRequest").setDescription("Pull request id").setExampleValue((Object)"5461").setInternal(true).setSince("7.1");
        MeasuresWsParametersBuilder.createMetricKeysParameter(action);
        MeasuresWsParametersBuilder.createAdditionalFieldsParameter(action);
        MeasuresWsParametersBuilder.createDeveloperParameters(action);
    }

    public void handle(Request request, Response response) throws Exception {
        if (request.param("developerId") != null || request.param("developerKey") != null) {
            throw new NotFoundException("The Developer Cockpit feature has been dropped. The specified developer cannot be found.");
        }
        Measures.ComponentWsResponse componentWsResponse = this.doHandle(ComponentAction.toComponentWsRequest(request));
        WsUtils.writeProtobuf((Message)componentWsResponse, request, response);
    }

    private Measures.ComponentWsResponse doHandle(ComponentRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            String branch = request.getBranch();
            String pullRequest = request.getPullRequest();
            ComponentDto component = this.loadComponent(dbSession, request, branch, pullRequest);
            this.checkPermissions(component);
            SnapshotDto analysis = this.dbClient.snapshotDao().selectLastAnalysisByRootComponentUuid(dbSession, component.projectUuid()).orElse(null);
            boolean isSLBorPR = this.isSLBorPR(dbSession, component, branch, pullRequest);
            HashSet<String> metricKeysToRequest = new HashSet<String>(request.metricKeys);
            if (isSLBorPR) {
                SLBorPRMeasureFix.addReplacementMetricKeys(metricKeysToRequest);
            }
            List<MetricDto> metrics = this.searchMetrics(dbSession, metricKeysToRequest);
            List<LiveMeasureDto> measures = this.searchMeasures(dbSession, component, metrics);
            Map<MetricDto, LiveMeasureDto> measuresByMetric = ComponentAction.getMeasuresByMetric(measures, metrics);
            if (isSLBorPR) {
                HashSet<String> originalMetricKeys = new HashSet<String>(request.metricKeys);
                SLBorPRMeasureFix.createReplacementMeasures(metrics, measuresByMetric, originalMetricKeys);
                SLBorPRMeasureFix.removeMetricsNotRequested(metrics, originalMetricKeys);
            }
            Optional<Measures.Period> period = SnapshotDtoToWsPeriod.snapshotToWsPeriods(analysis);
            Optional<ComponentDto> refComponent = this.getReferenceComponent(dbSession, component);
            Measures.ComponentWsResponse componentWsResponse = ComponentAction.buildResponse(request, component, refComponent, measuresByMetric, metrics, period);
            return componentWsResponse;
        }
    }

    public List<MetricDto> searchMetrics(DbSession dbSession, Collection<String> metricKeys) {
        List metrics = this.dbClient.metricDao().selectByKeys(dbSession, metricKeys);
        if (metrics.size() < metricKeys.size()) {
            Set foundMetricKeys = metrics.stream().map(MetricDto::getKey).collect(Collectors.toSet());
            Set missingMetricKeys = metricKeys.stream().filter(m -> !foundMetricKeys.contains(m)).collect(Collectors.toSet());
            throw new NotFoundException(String.format("The following metric keys are not found: %s", Joiner.on((String)", ").join(missingMetricKeys)));
        }
        return metrics;
    }

    private List<LiveMeasureDto> searchMeasures(DbSession dbSession, ComponentDto component, Collection<MetricDto> metrics) {
        Set metricIds = metrics.stream().map(MetricDto::getId).collect(Collectors.toSet());
        List measures = this.dbClient.liveMeasureDao().selectByComponentUuidsAndMetricIds(dbSession, Collections.singletonList(component.uuid()), metricIds);
        ComponentAction.addBestValuesToMeasures(measures, component, metrics);
        return measures;
    }

    private static Map<MetricDto, LiveMeasureDto> getMeasuresByMetric(List<LiveMeasureDto> measures, Collection<MetricDto> metrics) {
        ImmutableMap metricsById = Maps.uniqueIndex(metrics, MetricDto::getId);
        HashMap<MetricDto, LiveMeasureDto> measuresByMetric = new HashMap<MetricDto, LiveMeasureDto>();
        for (LiveMeasureDto measure : measures) {
            MetricDto metric = (MetricDto)metricsById.get(measure.getMetricId());
            measuresByMetric.put(metric, measure);
        }
        return measuresByMetric;
    }

    private static void addBestValuesToMeasures(List<LiveMeasureDto> measures, ComponentDto component, Collection<MetricDto> metrics) {
        if (!QUALIFIERS_ELIGIBLE_FOR_BEST_VALUE.contains(component.qualifier())) {
            return;
        }
        List metricWithBestValueList = (List)metrics.stream().filter(MetricDtoFunctions.isOptimizedForBestValue()).map(MetricDtoWithBestValue::new).collect(MoreCollectors.toList((int)metrics.size()));
        ImmutableMap measuresByMetricId = Maps.uniqueIndex(measures, LiveMeasureDto::getMetricId);
        for (MetricDtoWithBestValue metricWithBestValue : metricWithBestValueList) {
            if (measuresByMetricId.get(metricWithBestValue.getMetric().getId()) != null) continue;
            measures.add(metricWithBestValue.getBestValue());
        }
    }

    private boolean isSLBorPR(DbSession dbSession, ComponentDto component, @Nullable String branch, @Nullable String pullRequest) {
        if (branch != null) {
            return this.dbClient.branchDao().selectByUuid(dbSession, component.projectUuid()).map(b -> b.getBranchType() == BranchType.SHORT).orElse(false);
        }
        return pullRequest != null;
    }

    private ComponentDto loadComponent(DbSession dbSession, ComponentRequest request, @Nullable String branch, @Nullable String pullRequest) {
        String componentKey = request.getComponent();
        String componentId = request.getComponentId();
        Preconditions.checkArgument((componentId == null || branch == null && pullRequest == null ? 1 : 0) != 0, (String)"Parameter '%s' cannot be used at the same time as '%s' or '%s'", (Object[])new Object[]{"componentId", "branch", "pullRequest"});
        if (branch == null && pullRequest == null) {
            return this.componentFinder.getByUuidOrKey(dbSession, componentId, componentKey, ComponentFinder.ParamNames.COMPONENT_ID_AND_KEY);
        }
        WsUtils.checkRequest(componentKey != null, "The '%s' parameter is missing", "component");
        return this.componentFinder.getByKeyAndOptionalBranchOrPullRequest(dbSession, componentKey, branch, pullRequest);
    }

    private Optional<ComponentDto> getReferenceComponent(DbSession dbSession, ComponentDto component) {
        if (component.getCopyResourceUuid() == null) {
            return Optional.empty();
        }
        return this.dbClient.componentDao().selectByUuid(dbSession, component.getCopyResourceUuid());
    }

    private static Measures.ComponentWsResponse buildResponse(ComponentRequest request, ComponentDto component, Optional<ComponentDto> refComponent, Map<MetricDto, LiveMeasureDto> measuresByMetric, Collection<MetricDto> metrics, Optional<Measures.Period> period) {
        Measures.ComponentWsResponse.Builder response = Measures.ComponentWsResponse.newBuilder();
        if (refComponent.isPresent()) {
            response.setComponent(ComponentDtoToWsComponent.componentDtoToWsComponent(component, measuresByMetric, Collections.singletonMap(refComponent.get().uuid(), refComponent.get())));
        } else {
            response.setComponent(ComponentDtoToWsComponent.componentDtoToWsComponent(component, measuresByMetric, Collections.emptyMap()));
        }
        List additionalFields = request.getAdditionalFields();
        if (additionalFields != null) {
            if (additionalFields.contains("metrics")) {
                for (MetricDto metric : metrics) {
                    response.getMetricsBuilder().addMetrics(MetricDtoToWsMetric.metricDtoToWsMetric(metric));
                }
            }
            if (additionalFields.contains("periods") && period.isPresent()) {
                response.getPeriodsBuilder().addPeriods(period.get());
            }
        }
        return response.build();
    }

    private static ComponentRequest toComponentWsRequest(Request request) {
        ComponentRequest componentRequest = new ComponentRequest().setComponentId(request.param("componentId")).setComponent(request.param("component")).setBranch(request.param("branch")).setPullRequest(request.param("pullRequest")).setAdditionalFields(request.paramAsStrings("additionalFields")).setMetricKeys(request.mandatoryParamAsStrings("metricKeys"));
        WsUtils.checkRequest(!componentRequest.getMetricKeys().isEmpty(), "At least one metric key must be provided", new Object[0]);
        return componentRequest;
    }

    private void checkPermissions(ComponentDto baseComponent) {
        this.userSession.checkComponentPermission("user", baseComponent);
    }

    private static class ComponentRequest {
        private String componentId;
        private String component;
        private String branch;
        private String pullRequest;
        private List<String> metricKeys;
        private List<String> additionalFields;

        private ComponentRequest() {
        }

        @Deprecated
        @CheckForNull
        private String getComponentId() {
            return this.componentId;
        }

        @Deprecated
        private ComponentRequest setComponentId(@Nullable String componentId) {
            this.componentId = componentId;
            return this;
        }

        @CheckForNull
        private String getComponent() {
            return this.component;
        }

        private ComponentRequest setComponent(@Nullable String component) {
            this.component = component;
            return this;
        }

        @CheckForNull
        private String getBranch() {
            return this.branch;
        }

        private ComponentRequest setBranch(@Nullable String branch) {
            this.branch = branch;
            return this;
        }

        @CheckForNull
        public String getPullRequest() {
            return this.pullRequest;
        }

        public ComponentRequest setPullRequest(@Nullable String pullRequest) {
            this.pullRequest = pullRequest;
            return this;
        }

        private List<String> getMetricKeys() {
            return this.metricKeys;
        }

        private ComponentRequest setMetricKeys(@Nullable List<String> metricKeys) {
            this.metricKeys = metricKeys;
            return this;
        }

        @CheckForNull
        private List<String> getAdditionalFields() {
            return this.additionalFields;
        }

        private ComponentRequest setAdditionalFields(@Nullable List<String> additionalFields) {
            this.additionalFields = additionalFields;
            return this;
        }
    }
}

