/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.ws;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.protobuf.Message;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.DateUtils;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.component.SnapshotQuery;
import org.sonar.db.measure.MeasureDto;
import org.sonar.db.measure.PastMeasureQuery;
import org.sonar.db.metric.MetricDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.measure.ws.MeasuresWsAction;
import org.sonar.server.measure.ws.SearchHistoryResponseFactory;
import org.sonar.server.measure.ws.SearchHistoryResult;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Measures;

public class SearchHistoryAction
implements MeasuresWsAction {
    private static final int MAX_PAGE_SIZE = 1000;
    private static final int DEFAULT_PAGE_SIZE = 100;
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;
    private final UserSession userSession;

    public SearchHistoryAction(DbClient dbClient, ComponentFinder componentFinder, UserSession userSession) {
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("search_history").setDescription("Search measures history of a component.<br>Measures are ordered chronologically.<br>Pagination applies to the number of measures for each metric.<br>Requires the following permission: 'Browse' on the specified component").setResponseExample(this.getClass().getResource("search_history-example.json")).setSince("6.3").setChangelog(new Change[]{new Change("7.6", String.format("The use of module keys in parameter '%s' is deprecated", "component"))}).setHandler((RequestHandler)this);
        action.createParam("component").setDescription("Component key").setRequired(true).setExampleValue((Object)"my_project");
        action.createParam("branch").setDescription("Branch key").setSince("6.6").setInternal(true).setExampleValue((Object)"feature/my_branch");
        action.createParam("pullRequest").setDescription("Pull request id").setSince("7.1").setInternal(true).setExampleValue((Object)"5461");
        action.createParam("metrics").setDescription("Comma-separated list of metric keys").setRequired(true).setExampleValue((Object)"ncloc,coverage,new_violations");
        action.createParam("from").setDescription("Filter measures created after the given date (inclusive). <br>Either a date (server timezone) or datetime can be provided").setExampleValue((Object)"2017-10-19 or 2017-10-19T13:00:00+0200");
        action.createParam("to").setDescription("Filter measures created before the given date (inclusive). <br>Either a date (server timezone) or datetime can be provided").setExampleValue((Object)"2017-10-19 or 2017-10-19T13:00:00+0200");
        action.addPagingParams(100, 1000);
    }

    public void handle(Request request, Response response) throws Exception {
        Measures.SearchHistoryResponse searchHistoryResponse = (Measures.SearchHistoryResponse)Stream.of(request).map(SearchHistoryAction::toWsRequest).map(this.search()).map(result -> new SearchHistoryResponseFactory((SearchHistoryResult)result).apply()).collect(MoreCollectors.toOneElement());
        WsUtils.writeProtobuf((Message)searchHistoryResponse, request, response);
    }

    private static SearchHistoryRequest toWsRequest(Request request) {
        return SearchHistoryRequest.builder().setComponent(request.mandatoryParam("component")).setBranch(request.param("branch")).setPullRequest(request.param("pullRequest")).setMetrics(request.mandatoryParamAsStrings("metrics")).setFrom(request.param("from")).setTo(request.param("to")).setPage(request.mandatoryParamAsInt("p")).setPageSize(request.mandatoryParamAsInt("ps")).build();
    }

    private Function<SearchHistoryRequest, SearchHistoryResult> search() {
        return request -> {
            try (DbSession dbSession = this.dbClient.openSession(false);){
                ComponentDto component = this.searchComponent((SearchHistoryRequest)request, dbSession);
                SearchHistoryResult result = new SearchHistoryResult(((SearchHistoryRequest)request).page, ((SearchHistoryRequest)request).pageSize).setComponent(component).setAnalyses(this.searchAnalyses(dbSession, (SearchHistoryRequest)request, component)).setMetrics(this.searchMetrics(dbSession, (SearchHistoryRequest)request));
                SearchHistoryResult searchHistoryResult = result.setMeasures(this.searchMeasures(dbSession, (SearchHistoryRequest)request, result));
                return searchHistoryResult;
            }
        };
    }

    private ComponentDto searchComponent(SearchHistoryRequest request, DbSession dbSession) {
        ComponentDto component = this.loadComponent(dbSession, request);
        this.userSession.checkComponentPermission("user", component);
        return component;
    }

    private List<MeasureDto> searchMeasures(DbSession dbSession, SearchHistoryRequest request, SearchHistoryResult result) {
        Date from = DateUtils.parseStartingDateOrDateTime((String)request.getFrom());
        Date to = DateUtils.parseEndingDateOrDateTime((String)request.getTo());
        PastMeasureQuery dbQuery = new PastMeasureQuery(result.getComponent().uuid(), (List)result.getMetrics().stream().map(MetricDto::getId).collect(MoreCollectors.toList()), from == null ? null : Long.valueOf(from.getTime()), to == null ? null : Long.valueOf(to.getTime() + 1000L));
        return this.dbClient.measureDao().selectPastMeasures(dbSession, dbQuery);
    }

    private List<SnapshotDto> searchAnalyses(DbSession dbSession, SearchHistoryRequest request, ComponentDto component) {
        SnapshotQuery dbQuery = new SnapshotQuery().setComponentUuid(component.projectUuid()).setStatus("P").setSort(SnapshotQuery.SORT_FIELD.BY_DATE, SnapshotQuery.SORT_ORDER.ASC);
        Optional.ofNullable(request.getFrom()).ifPresent(from -> dbQuery.setCreatedAfter(Long.valueOf(DateUtils.parseStartingDateOrDateTime((String)from).getTime())));
        Optional.ofNullable(request.getTo()).ifPresent(to -> dbQuery.setCreatedBefore(Long.valueOf(DateUtils.parseEndingDateOrDateTime((String)to).getTime() + 1000L)));
        return this.dbClient.snapshotDao().selectAnalysesByQuery(dbSession, dbQuery);
    }

    private List<MetricDto> searchMetrics(DbSession dbSession, SearchHistoryRequest request) {
        List metrics = this.dbClient.metricDao().selectByKeys(dbSession, request.getMetrics());
        if (request.getMetrics().size() > metrics.size()) {
            Set requestedMetrics = (Set)request.getMetrics().stream().collect(MoreCollectors.toSet());
            Set foundMetrics = (Set)metrics.stream().map(MetricDto::getKey).collect(MoreCollectors.toSet());
            ImmutableSet unfoundMetrics = Sets.difference((Set)requestedMetrics, (Set)foundMetrics).immutableCopy();
            throw new IllegalArgumentException(String.format("Metrics %s are not found", String.join((CharSequence)", ", (Iterable<? extends CharSequence>)unfoundMetrics)));
        }
        return metrics;
    }

    private ComponentDto loadComponent(DbSession dbSession, SearchHistoryRequest request) {
        String componentKey = request.getComponent();
        String branch = request.getBranch();
        String pullRequest = request.getPullRequest();
        return this.componentFinder.getByKeyAndOptionalBranchOrPullRequest(dbSession, componentKey, branch, pullRequest);
    }

    static class Builder {
        private String component;
        private String branch;
        private String pullRequest;
        private List<String> metrics;
        private String from;
        private String to;
        private int page = 1;
        private int pageSize = 100;

        private Builder() {
        }

        public Builder setComponent(String component) {
            this.component = component;
            return this;
        }

        public Builder setBranch(@Nullable String branch) {
            this.branch = branch;
            return this;
        }

        public Builder setPullRequest(@Nullable String pullRequest) {
            this.pullRequest = pullRequest;
            return this;
        }

        public Builder setMetrics(List<String> metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder setFrom(@Nullable String from) {
            this.from = from;
            return this;
        }

        public Builder setTo(@Nullable String to) {
            this.to = to;
            return this;
        }

        public Builder setPage(int page) {
            this.page = page;
            return this;
        }

        public Builder setPageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public SearchHistoryRequest build() {
            Builder.checkArgument(this.component != null && !this.component.isEmpty(), "Component key is required", new Object[0]);
            Builder.checkArgument(this.metrics != null && !this.metrics.isEmpty(), "Metric keys are required", new Object[0]);
            Builder.checkArgument(this.pageSize <= 1000, "Page size (%d) must be lower than or equal to %d", this.pageSize, 1000);
            return new SearchHistoryRequest(this);
        }

        private static void checkArgument(boolean condition, String message, Object ... args) {
            if (!condition) {
                throw new IllegalArgumentException(String.format(message, args));
            }
        }
    }

    static class SearchHistoryRequest {
        private final String component;
        private final String branch;
        private final String pullRequest;
        private final List<String> metrics;
        private final String from;
        private final String to;
        private final int page;
        private final int pageSize;

        public SearchHistoryRequest(Builder builder) {
            this.component = builder.component;
            this.branch = builder.branch;
            this.pullRequest = builder.pullRequest;
            this.metrics = builder.metrics;
            this.from = builder.from;
            this.to = builder.to;
            this.page = builder.page;
            this.pageSize = builder.pageSize;
        }

        public String getComponent() {
            return this.component;
        }

        @CheckForNull
        public String getBranch() {
            return this.branch;
        }

        @CheckForNull
        public String getPullRequest() {
            return this.pullRequest;
        }

        public List<String> getMetrics() {
            return this.metrics;
        }

        @CheckForNull
        public String getFrom() {
            return this.from;
        }

        @CheckForNull
        public String getTo() {
            return this.to;
        }

        public int getPage() {
            return this.page;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public static Builder builder() {
            return new Builder();
        }
    }
}

