/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization;

import java.util.List;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.server.ServerSide;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.permission.GroupPermissionDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.user.GroupDto;
import org.sonar.db.user.UserGroupDto;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.organization.OrganizationFlags;
import org.sonar.server.rule.index.RuleIndexer;
import org.sonar.server.usergroups.DefaultGroupCreator;
import org.sonar.server.usergroups.DefaultGroupFinder;

@ServerSide
public class OrganisationSupport {
    private final DbClient dbClient;
    private final DefaultOrganizationProvider defaultOrganizationProvider;
    private final OrganizationFlags organizationFlags;
    private final DefaultGroupCreator defaultGroupCreator;
    private final DefaultGroupFinder defaultGroupFinder;
    private final RuleIndexer ruleIndexer;

    public OrganisationSupport(DbClient dbClient, DefaultOrganizationProvider defaultOrganizationProvider, OrganizationFlags organizationFlags, DefaultGroupCreator defaultGroupCreator, DefaultGroupFinder defaultGroupFinder, RuleIndexer ruleIndexer) {
        this.dbClient = dbClient;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
        this.organizationFlags = organizationFlags;
        this.defaultGroupCreator = defaultGroupCreator;
        this.defaultGroupFinder = defaultGroupFinder;
        this.ruleIndexer = ruleIndexer;
    }

    public void enable(String login) {
        String defaultOrganizationUuid = this.defaultOrganizationProvider.get().getUuid();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            if (!this.organizationFlags.isEnabled(dbSession)) {
                this.flagAdminUserAsRoot(dbSession, login);
                this.createDefaultMembersGroup(dbSession, defaultOrganizationUuid);
                List<Integer> disabledTemplateAndCustomRuleIds = this.disableTemplateRulesAndCustomRules(dbSession);
                this.enableFeature(dbSession);
                this.ruleIndexer.commitAndIndex(dbSession, disabledTemplateAndCustomRuleIds);
            }
        }
    }

    private void flagAdminUserAsRoot(DbSession dbSession, String login) {
        this.dbClient.userDao().setRoot(dbSession, login, true);
    }

    private void createDefaultMembersGroup(DbSession dbSession, String defaultOrganizationUuid) {
        GroupDto sonarUsersGroupId = this.defaultGroupFinder.findDefaultGroup(dbSession, defaultOrganizationUuid);
        GroupDto members = this.defaultGroupCreator.create(dbSession, defaultOrganizationUuid);
        this.copySonarUsersGroupPermissionsToMembersGroup(dbSession, defaultOrganizationUuid, sonarUsersGroupId, members);
        this.copySonarUsersGroupPermissionTemplatesToMembersGroup(dbSession, sonarUsersGroupId, members);
        this.associateMembersOfDefaultOrganizationToGroup(dbSession, defaultOrganizationUuid, members);
    }

    private void associateMembersOfDefaultOrganizationToGroup(DbSession dbSession, String defaultOrganizationUuid, GroupDto membersGroup) {
        List organizationMembers = this.dbClient.organizationMemberDao().selectUserIdsByOrganizationUuid(dbSession, defaultOrganizationUuid);
        organizationMembers.forEach(member -> this.dbClient.userGroupDao().insert(dbSession, new UserGroupDto().setGroupId(membersGroup.getId().intValue()).setUserId(member.intValue())));
    }

    private void copySonarUsersGroupPermissionsToMembersGroup(DbSession dbSession, String defaultOrganizationUuid, GroupDto sonarUsersGroup, GroupDto membersGroup) {
        this.dbClient.groupPermissionDao().selectAllPermissionsByGroupId(dbSession, defaultOrganizationUuid, sonarUsersGroup.getId(), context -> {
            GroupPermissionDto groupPermissionDto = (GroupPermissionDto)context.getResultObject();
            this.dbClient.groupPermissionDao().insert(dbSession, new GroupPermissionDto().setOrganizationUuid(defaultOrganizationUuid).setGroupId(membersGroup.getId()).setRole(groupPermissionDto.getRole()).setResourceId(groupPermissionDto.getResourceId()));
        });
    }

    private void copySonarUsersGroupPermissionTemplatesToMembersGroup(DbSession dbSession, GroupDto sonarUsersGroup, GroupDto membersGroup) {
        List sonarUsersPermissionTemplates = this.dbClient.permissionTemplateDao().selectAllGroupPermissionTemplatesByGroupId(dbSession, (long)sonarUsersGroup.getId().intValue());
        sonarUsersPermissionTemplates.forEach(permissionTemplateGroup -> this.dbClient.permissionTemplateDao().insertGroupPermission(dbSession, permissionTemplateGroup.getTemplateId().longValue(), membersGroup.getId(), permissionTemplateGroup.getPermission()));
    }

    private List<Integer> disableTemplateRulesAndCustomRules(DbSession dbSession) {
        List rules = (List)this.dbClient.ruleDao().selectAllDefinitions(dbSession).stream().filter(r -> r.isTemplate() || r.isCustomRule()).collect(MoreCollectors.toList());
        rules.forEach(r -> {
            r.setStatus(RuleStatus.REMOVED);
            this.dbClient.ruleDao().update(dbSession, r);
        });
        return (List)rules.stream().map(RuleDefinitionDto::getId).collect(MoreCollectors.toList());
    }

    private void enableFeature(DbSession dbSession) {
        this.organizationFlags.enable(dbSession);
    }
}

