/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.server.ws.WsUtils;

public class ApplyPermissionTemplateQuery {
    private final String templateUuid;
    private List<String> componentKeys;

    private ApplyPermissionTemplateQuery(String templateUuid, List<String> componentKeys) {
        this.templateUuid = templateUuid;
        this.componentKeys = componentKeys;
        this.validate();
    }

    public static ApplyPermissionTemplateQuery create(String templateUuid, List<String> componentKeys) {
        return new ApplyPermissionTemplateQuery(templateUuid, componentKeys);
    }

    public String getTemplateUuid() {
        return this.templateUuid;
    }

    public List<String> getComponentKeys() {
        return this.componentKeys;
    }

    private void validate() {
        WsUtils.checkRequest(StringUtils.isNotBlank((String)this.templateUuid), "Permission template is mandatory", new Object[0]);
        WsUtils.checkRequest(this.componentKeys != null && !this.componentKeys.isEmpty(), "No project provided. Please provide at least one project.", new Object[0]);
    }
}

