/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.projectanalysis.ws;

import com.google.common.collect.ListMultimap;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.event.EventComponentChangeDto;
import org.sonar.db.event.EventDto;
import org.sonar.server.projectanalysis.ws.EventCategory;
import org.sonar.server.projectanalysis.ws.SearchData;
import org.sonarqube.ws.ProjectAnalyses;

class SearchResponseBuilder {
    private static final Logger LOGGER = Loggers.get(SearchResponseBuilder.class);
    private final ProjectAnalyses.Analysis.Builder wsAnalysis = ProjectAnalyses.Analysis.newBuilder();
    private final ProjectAnalyses.Event.Builder wsEvent = ProjectAnalyses.Event.newBuilder();
    private final SearchData searchData;
    private final ProjectAnalyses.QualityGate.Builder wsQualityGate = ProjectAnalyses.QualityGate.newBuilder();
    private final ProjectAnalyses.DefinitionChange.Builder wsDefinitionChange = ProjectAnalyses.DefinitionChange.newBuilder();

    SearchResponseBuilder(SearchData searchData) {
        this.searchData = searchData;
    }

    ProjectAnalyses.SearchResponse build() {
        ProjectAnalyses.SearchResponse.Builder wsResponse = ProjectAnalyses.SearchResponse.newBuilder();
        this.addAnalyses(wsResponse);
        this.addPagination(wsResponse);
        return wsResponse.build();
    }

    private void addAnalyses(ProjectAnalyses.SearchResponse.Builder wsResponse) {
        this.searchData.analyses.stream().map(this::dbToWsAnalysis).map(this::attachEvents).forEach(arg_0 -> ((ProjectAnalyses.SearchResponse.Builder)wsResponse).addAnalyses(arg_0));
    }

    private ProjectAnalyses.Analysis.Builder dbToWsAnalysis(SnapshotDto dbAnalysis) {
        ProjectAnalyses.Analysis.Builder builder = this.wsAnalysis.clear();
        builder.setKey(dbAnalysis.getUuid()).setDate(DateUtils.formatDateTime((long)dbAnalysis.getCreatedAt())).setManualNewCodePeriodBaseline(this.searchData.getManualBaseline().filter(dbAnalysis.getUuid()::equals).isPresent());
        Optional.ofNullable(dbAnalysis.getProjectVersion()).ifPresent(arg_0 -> ((ProjectAnalyses.Analysis.Builder)builder).setProjectVersion(arg_0));
        Optional.ofNullable(dbAnalysis.getBuildString()).ifPresent(arg_0 -> ((ProjectAnalyses.Analysis.Builder)builder).setBuildString(arg_0));
        Optional.ofNullable(dbAnalysis.getRevision()).ifPresent(arg_0 -> ((ProjectAnalyses.Analysis.Builder)builder).setRevision(arg_0));
        return builder;
    }

    private ProjectAnalyses.Analysis.Builder attachEvents(ProjectAnalyses.Analysis.Builder analysis) {
        this.searchData.eventsByAnalysis.get((Object)analysis.getKey()).stream().map(this::dbToWsEvent).forEach(arg_0 -> ((ProjectAnalyses.Analysis.Builder)analysis).addEvents(arg_0));
        return analysis;
    }

    private ProjectAnalyses.Event.Builder dbToWsEvent(EventDto dbEvent) {
        this.wsEvent.clear().setKey(dbEvent.getUuid());
        Optional.ofNullable(dbEvent.getName()).ifPresent(arg_0 -> ((ProjectAnalyses.Event.Builder)this.wsEvent).setName(arg_0));
        Optional.ofNullable(dbEvent.getDescription()).ifPresent(arg_0 -> ((ProjectAnalyses.Event.Builder)this.wsEvent).setDescription(arg_0));
        Optional.ofNullable(dbEvent.getCategory()).ifPresent(cat -> this.wsEvent.setCategory(EventCategory.fromLabel(cat).name()));
        if (dbEvent.getCategory() != null) {
            switch (EventCategory.fromLabel(dbEvent.getCategory())) {
                case DEFINITION_CHANGE: {
                    this.addDefinitionChange(dbEvent);
                    break;
                }
                case QUALITY_GATE: {
                    this.addQualityGateInformation(dbEvent);
                    break;
                }
            }
        }
        return this.wsEvent;
    }

    private void addQualityGateInformation(EventDto event) {
        this.wsQualityGate.clear();
        List eventComponentChangeDtos = this.searchData.componentChangesByEventUuid.get((Object)event.getUuid());
        if (eventComponentChangeDtos.isEmpty()) {
            return;
        }
        if (event.getData() != null) {
            try {
                Gson gson = new Gson();
                Data data = (Data)gson.fromJson(event.getData(), Data.class);
                this.wsQualityGate.setStillFailing(data.isStillFailing());
                this.wsQualityGate.setStatus(data.getStatus());
            }
            catch (JsonSyntaxException ex) {
                LOGGER.error("Unable to retrieve data from event uuid=" + event.getUuid(), (Throwable)ex);
                return;
            }
        }
        this.wsQualityGate.addAllFailing((Iterable)eventComponentChangeDtos.stream().map(SearchResponseBuilder::toFailing).collect(Collectors.toList()));
        this.wsEvent.setQualityGate(this.wsQualityGate.build());
    }

    private void addDefinitionChange(EventDto event) {
        this.wsDefinitionChange.clear();
        List eventComponentChangeDtos = this.searchData.componentChangesByEventUuid.get((Object)event.getUuid());
        if (eventComponentChangeDtos.isEmpty()) {
            return;
        }
        ListMultimap componentChangeByKey = (ListMultimap)eventComponentChangeDtos.stream().collect(MoreCollectors.index(EventComponentChangeDto::getComponentKey));
        try {
            this.wsDefinitionChange.addAllProjects((Iterable)componentChangeByKey.asMap().values().stream().map(SearchResponseBuilder::addChange).map(rec$ -> ((Project)rec$).toProject()).collect(Collectors.toList()));
            this.wsEvent.setDefinitionChange(this.wsDefinitionChange.build());
        }
        catch (IllegalStateException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private static Project addChange(Collection<EventComponentChangeDto> changes) {
        if (changes.size() == 1) {
            return SearchResponseBuilder.addSingleChange(changes.iterator().next());
        }
        return SearchResponseBuilder.addBranchChange(changes);
    }

    private static Project addSingleChange(EventComponentChangeDto componentChange) {
        Project project = new Project().setKey(componentChange.getComponentKey()).setName(componentChange.getComponentName()).setBranch(componentChange.getComponentBranchKey());
        switch (componentChange.getCategory()) {
            case ADDED: {
                project.setChangeType("ADDED");
                break;
            }
            case REMOVED: {
                project.setChangeType("REMOVED");
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unknown change %s for eventComponentChange uuid: %s", componentChange.getCategory(), componentChange.getUuid()));
            }
        }
        return project;
    }

    private static Project addBranchChange(Collection<EventComponentChangeDto> changes) {
        if (changes.size() != 2) {
            throw new IllegalStateException(String.format("Too many changes on same project (%d) for eventComponentChange uuids : %s", changes.size(), changes.stream().map(EventComponentChangeDto::getUuid).collect(Collectors.joining(","))));
        }
        Optional<EventComponentChangeDto> addedChange = changes.stream().filter(c -> c.getCategory().equals((Object)EventComponentChangeDto.ChangeCategory.ADDED)).findFirst();
        Optional<EventComponentChangeDto> removedChange = changes.stream().filter(c -> c.getCategory().equals((Object)EventComponentChangeDto.ChangeCategory.REMOVED)).findFirst();
        if (!addedChange.isPresent() || !removedChange.isPresent() || addedChange.equals(removedChange)) {
            Iterator<EventComponentChangeDto> iterator = changes.iterator();
            EventComponentChangeDto firstChange = iterator.next();
            EventComponentChangeDto secondChange = iterator.next();
            throw new IllegalStateException(String.format("Incorrect changes : [uuid=%s change=%s, branch=%s] and [uuid=%s, change=%s, branch=%s]", firstChange.getUuid(), firstChange.getCategory().name(), firstChange.getComponentBranchKey(), secondChange.getUuid(), secondChange.getCategory().name(), secondChange.getComponentBranchKey()));
        }
        return new Project().setName(addedChange.get().getComponentName()).setKey(addedChange.get().getComponentKey()).setChangeType("BRANCH_CHANGED").setNewBranch(addedChange.get().getComponentBranchKey()).setOldBranch(removedChange.get().getComponentBranchKey());
    }

    private void addPagination(ProjectAnalyses.SearchResponse.Builder wsResponse) {
        wsResponse.getPagingBuilder().setPageIndex(this.searchData.paging.pageIndex()).setPageSize(this.searchData.paging.pageSize()).setTotal(this.searchData.paging.total()).build();
    }

    private static ProjectAnalyses.Failing toFailing(EventComponentChangeDto change) {
        ProjectAnalyses.Failing.Builder builder = ProjectAnalyses.Failing.newBuilder().setKey(change.getComponentKey()).setName(change.getComponentName());
        if (change.getComponentBranchKey() != null) {
            builder.setBranch(change.getComponentBranchKey());
        }
        return builder.build();
    }

    private static class Project {
        private String key;
        private String name;
        private String changeType;
        private String branch;
        private String oldBranch;
        private String newBranch;

        private Project() {
        }

        public Project setKey(String key) {
            this.key = key;
            return this;
        }

        public Project setName(String name) {
            this.name = name;
            return this;
        }

        public Project setChangeType(String changeType) {
            this.changeType = changeType;
            return this;
        }

        public Project setBranch(@Nullable String branch) {
            this.branch = branch;
            return this;
        }

        public Project setOldBranch(@Nullable String oldBranch) {
            this.oldBranch = oldBranch;
            return this;
        }

        public Project setNewBranch(@Nullable String newBranch) {
            this.newBranch = newBranch;
            return this;
        }

        private ProjectAnalyses.Project toProject() {
            ProjectAnalyses.Project.Builder builder = ProjectAnalyses.Project.newBuilder();
            builder.setKey(this.key).setName(this.name).setChangeType(this.changeType);
            Optional.ofNullable(this.branch).ifPresent(arg_0 -> ((ProjectAnalyses.Project.Builder)builder).setBranch(arg_0));
            Optional.ofNullable(this.oldBranch).ifPresent(arg_0 -> ((ProjectAnalyses.Project.Builder)builder).setOldBranch(arg_0));
            Optional.ofNullable(this.newBranch).ifPresent(arg_0 -> ((ProjectAnalyses.Project.Builder)builder).setNewBranch(arg_0));
            return builder.build();
        }
    }

    private static class Data {
        private boolean stillFailing;
        private String status;

        boolean isStillFailing() {
            return this.stillFailing;
        }

        public Data setStillFailing(boolean stillFailing) {
            this.stillFailing = stillFailing;
            return this;
        }

        String getStatus() {
            return this.status;
        }

        public Data setStatus(String status) {
            this.status = status;
            return this;
        }
    }
}

