/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.property.ws;

import com.google.common.base.Splitter;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.PropertyType;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.property.PropertyDto;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsAction;

public class IndexAction
implements WsAction {
    private static final Splitter DOT_SPLITTER = Splitter.on((String)".").omitEmptyStrings();
    private static final Splitter COMMA_SPLITTER = Splitter.on((String)",");
    private static final String COMMA_ENCODED_VALUE = "%2C";
    public static final String PARAM_ID = "id";
    public static final String PARAM_COMPONENT = "resource";
    public static final String PARAM_FORMAT = "format";
    private final DbClient dbClient;
    private final UserSession userSession;
    private final PropertyDefinitions propertyDefinitions;

    public IndexAction(DbClient dbClient, UserSession userSession, PropertyDefinitions propertyDefinitions) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.propertyDefinitions = propertyDefinitions;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("index").setDescription("This web service is deprecated, please use api/settings/values instead.").setDeprecatedSince("6.3").setResponseExample(this.getClass().getResource("index-example.json")).setSince("2.6").setHandler((RequestHandler)this);
        action.createParam(PARAM_ID).setDescription("Setting key").setExampleValue((Object)"sonar.test.inclusions");
        action.createParam(PARAM_COMPONENT).setDescription("Component key or database id").setExampleValue((Object)"my_project");
        action.createParam(PARAM_FORMAT).setDescription("Only json response format is available").setPossibleValues((Object[])new String[]{"json"});
    }

    public void handle(Request request, Response response) throws Exception {
        request.param(PARAM_FORMAT);
        JsonWriter json = response.newJsonWriter();
        json.beginArray();
        this.doHandle(json, request);
        json.endArray();
        json.close();
    }

    private void doHandle(JsonWriter json, Request request) {
        try (DbSession dbSession = this.dbClient.openSession(true);){
            Optional<ComponentDto> component = this.loadComponent(dbSession, request);
            String key = request.param(PARAM_ID);
            List<PropertyDto> propertyDtos = this.loadProperties(dbSession, component, Optional.ofNullable(key));
            new ResponseBuilder(propertyDtos).build(json);
        }
    }

    private Optional<ComponentDto> loadComponent(DbSession dbSession, Request request) {
        String component = request.param(PARAM_COMPONENT);
        if (component == null) {
            return Optional.empty();
        }
        return this.loadComponent(dbSession, component);
    }

    private Optional<ComponentDto> loadComponent(DbSession dbSession, String component) {
        try {
            long componentId = Long.parseLong(component);
            return Optional.ofNullable(this.dbClient.componentDao().selectById(dbSession, componentId).orElse(null));
        }
        catch (NumberFormatException e) {
            return Optional.ofNullable(this.dbClient.componentDao().selectByKey(dbSession, component).orElse(null));
        }
    }

    private List<PropertyDto> loadProperties(DbSession dbSession, Optional<ComponentDto> component, Optional<String> key) {
        ArrayList<PropertyDto> propertyDtos = new ArrayList<PropertyDto>();
        propertyDtos.addAll(this.loadDefaultSettings(key));
        propertyDtos.addAll(this.loadGlobalSettings(dbSession, key));
        component.ifPresent(componentDto -> propertyDtos.addAll(this.loadComponentSettings(dbSession, key, (ComponentDto)componentDto).values()));
        return propertyDtos.stream().filter(this.isVisible(component)).collect(Collectors.toList());
    }

    Predicate<PropertyDto> isVisible(Optional<ComponentDto> component) {
        return propertyDto -> !propertyDto.getKey().endsWith(".secured") || this.hasAdminPermission(component);
    }

    private boolean hasAdminPermission(Optional<ComponentDto> component) {
        return component.map(c -> this.userSession.hasComponentPermission("admin", (ComponentDto)c)).orElse(this.userSession.isSystemAdministrator());
    }

    private List<PropertyDto> loadGlobalSettings(DbSession dbSession, Optional<String> key) {
        if (key.isPresent()) {
            return this.dbClient.propertiesDao().selectGlobalPropertiesByKeys(dbSession, Collections.singleton(key.get()));
        }
        return this.dbClient.propertiesDao().selectGlobalProperties(dbSession);
    }

    private Multimap<String, PropertyDto> loadComponentSettings(DbSession dbSession, Optional<String> key, ComponentDto component) {
        List componentUuids = DOT_SPLITTER.splitToList((CharSequence)component.moduleUuidPath());
        List componentDtos = this.dbClient.componentDao().selectByUuids(dbSession, (Collection)componentUuids);
        Set componentIds = componentDtos.stream().map(ComponentDto::getId).collect(Collectors.toSet());
        Map<Long, String> uuidsById = componentDtos.stream().collect(Collectors.toMap(ComponentDto::getId, ComponentDto::uuid));
        List properties = key.isPresent() ? this.dbClient.propertiesDao().selectPropertiesByKeysAndComponentIds(dbSession, Collections.singleton(key.get()), componentIds) : this.dbClient.propertiesDao().selectPropertiesByComponentIds(dbSession, componentIds);
        TreeMultimap propertyDtosByUuid = TreeMultimap.create((Comparator)Ordering.explicit((List)componentUuids), (Comparator)Ordering.arbitrary());
        for (PropertyDto propertyDto : properties) {
            Long componentId = propertyDto.getResourceId();
            String componentUuid = uuidsById.get(componentId);
            propertyDtosByUuid.put((Object)componentUuid, (Object)propertyDto);
        }
        return propertyDtosByUuid;
    }

    private List<PropertyDto> loadDefaultSettings(Optional<String> key) {
        return this.propertyDefinitions.getAll().stream().filter(definition -> !key.isPresent() || ((String)key.get()).equals(definition.key())).filter(defaultProperty -> !StringUtils.isEmpty((String)defaultProperty.defaultValue())).map(definition -> new PropertyDto().setKey(definition.key()).setValue(definition.defaultValue())).collect(Collectors.toList());
    }

    private static class Property {
        private final String key;
        private String value;
        private List<String> values = new ArrayList<String>();

        public Property(String key) {
            this.key = key;
        }

        public Property setValue(String value) {
            this.value = value;
            return this;
        }

        public Property setValues(List<String> values) {
            this.values = values;
            return this;
        }
    }

    private class ResponseBuilder {
        private final List<PropertyDto> propertyDtos;
        private final Map<String, Property> propertiesByKey = new HashMap<String, Property>();

        ResponseBuilder(List<PropertyDto> propertyDtos) {
            this.propertyDtos = propertyDtos;
        }

        void build(JsonWriter json) {
            this.processSettings();
            this.propertiesByKey.values().forEach(property -> {
                json.beginObject().prop("key", ((Property)property).key).prop("value", ((Property)property).value);
                if (!((Property)property).values.isEmpty()) {
                    json.name("values").beginArray().values((Iterable)((Property)property).values).endArray();
                }
                json.endObject();
            });
        }

        private void processSettings() {
            this.propertyDtos.forEach(setting -> {
                Property property = this.createProperty(setting.getKey());
                this.setValue((PropertyDto)setting, property);
            });
        }

        private Property createProperty(String key) {
            return this.propertiesByKey.computeIfAbsent(key, k -> new Property(key));
        }

        private void setValue(PropertyDto propertyDto, Property property) {
            String value = propertyDto.getValue();
            property.setValue(value);
            PropertyDefinition definition = IndexAction.this.propertyDefinitions.get(propertyDto.getKey());
            if (definition != null && (definition.multiValues() || definition.type().equals((Object)PropertyType.PROPERTY_SET))) {
                property.setValues(this.createValues(value));
            }
        }

        private List<String> createValues(String value) {
            return COMMA_SPLITTER.splitToList((CharSequence)value).stream().map(v -> v.replace(IndexAction.COMMA_ENCODED_VALUE, ",")).collect(Collectors.toList());
        }
    }
}

