/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.Date;
import javax.annotation.CheckForNull;
import org.sonar.api.notifications.Notification;
import org.sonar.api.platform.Server;
import org.sonar.api.utils.DateUtils;
import org.sonar.server.issue.notification.EmailMessage;
import org.sonar.server.issue.notification.EmailTemplate;
import org.sonar.server.qualityprofile.BuiltInQPChangeNotificationBuilder;

public class BuiltInQPChangeNotificationTemplate
implements EmailTemplate {
    private final Server server;

    public BuiltInQPChangeNotificationTemplate(Server server) {
        this.server = server;
    }

    @CheckForNull
    public EmailMessage format(Notification notification) {
        if (!"built-in-quality-profiles".equals(notification.getType())) {
            return null;
        }
        BuiltInQPChangeNotificationBuilder profilesNotification = BuiltInQPChangeNotificationBuilder.parse(notification);
        StringBuilder message = new StringBuilder("The following built-in profiles have been updated:\n\n");
        profilesNotification.getProfiles().stream().sorted(Comparator.comparing(BuiltInQPChangeNotificationBuilder.Profile::getLanguageName).thenComparing(BuiltInQPChangeNotificationBuilder.Profile::getProfileName)).forEach(profile -> {
            int removedRules;
            int updatedRules;
            message.append("\"").append(profile.getProfileName()).append("\" - ").append(profile.getLanguageName()).append(": ").append(this.server.getPublicRootUrl()).append("/profiles/changelog?language=").append(profile.getLanguageKey()).append("&name=").append(this.encode(profile.getProfileName())).append("&since=").append(DateUtils.formatDate((Date)new Date(profile.getStartDate()))).append("&to=").append(DateUtils.formatDate((Date)new Date(profile.getEndDate()))).append("\n");
            int newRules = profile.getNewRules();
            if (newRules > 0) {
                message.append(" ").append(newRules).append(" new rule").append(BuiltInQPChangeNotificationTemplate.plural(newRules)).append('\n');
            }
            if ((updatedRules = profile.getUpdatedRules()) > 0) {
                message.append(" ").append(updatedRules).append(" rule").append(updatedRules > 1 ? "s have been updated" : " has been updated").append("\n");
            }
            if ((removedRules = profile.getRemovedRules()) > 0) {
                message.append(" ").append(removedRules).append(" rule").append(BuiltInQPChangeNotificationTemplate.plural(removedRules)).append(" removed\n");
            }
            message.append("\n");
        });
        message.append("This is a good time to review your quality profiles and update them to benefit from the latest evolutions: ");
        message.append(this.server.getPublicRootUrl()).append("/profiles");
        return new EmailMessage().setMessageId("built-in-quality-profiles").setSubject("Built-in quality profiles have been updated").setPlainTextMessage(message.toString());
    }

    private static String plural(int count) {
        return count > 1 ? "s" : "";
    }

    public String encode(String text) {
        try {
            return URLEncoder.encode(text, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(String.format("Cannot encode %s", text), e);
        }
    }
}

