/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.RuleType;

public class NewCustomRule {
    private String ruleKey;
    private RuleKey templateKey;
    private String name;
    private String htmlDescription;
    private String markdownDescription;
    private String severity;
    private RuleStatus status;
    private RuleType type;
    private final Map<String, String> parameters = Maps.newHashMap();
    private boolean preventReactivation = false;

    private NewCustomRule() {
    }

    public String ruleKey() {
        return this.ruleKey;
    }

    @CheckForNull
    public RuleKey templateKey() {
        return this.templateKey;
    }

    @CheckForNull
    public String name() {
        return this.name;
    }

    public NewCustomRule setName(@Nullable String name) {
        this.name = name;
        return this;
    }

    @CheckForNull
    public String htmlDescription() {
        return this.htmlDescription;
    }

    public NewCustomRule setHtmlDescription(@Nullable String htmlDescription) {
        this.htmlDescription = htmlDescription;
        return this;
    }

    @CheckForNull
    public String markdownDescription() {
        return this.markdownDescription;
    }

    public NewCustomRule setMarkdownDescription(@Nullable String markdownDescription) {
        this.markdownDescription = markdownDescription;
        return this;
    }

    @CheckForNull
    public String severity() {
        return this.severity;
    }

    public NewCustomRule setSeverity(@Nullable String severity) {
        this.severity = severity;
        return this;
    }

    @CheckForNull
    public RuleStatus status() {
        return this.status;
    }

    public NewCustomRule setStatus(@Nullable RuleStatus status) {
        this.status = status;
        return this;
    }

    @CheckForNull
    public RuleType type() {
        return this.type;
    }

    public NewCustomRule setType(@Nullable RuleType type) {
        this.type = type;
        return this;
    }

    @CheckForNull
    public String parameter(String paramKey) {
        return this.parameters.get(paramKey);
    }

    public NewCustomRule setParameters(Map<String, String> params) {
        this.parameters.clear();
        this.parameters.putAll(params);
        return this;
    }

    public boolean isPreventReactivation() {
        return this.preventReactivation;
    }

    public NewCustomRule setPreventReactivation(boolean preventReactivation) {
        this.preventReactivation = preventReactivation;
        return this;
    }

    public static NewCustomRule createForCustomRule(String customKey, RuleKey templateKey) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)customKey) ? 1 : 0) != 0, (Object)"Custom key should be set");
        Preconditions.checkArgument((templateKey != null ? 1 : 0) != 0, (Object)"Template key should be set");
        NewCustomRule newRule = new NewCustomRule();
        newRule.ruleKey = customKey;
        newRule.templateKey = templateKey;
        return newRule;
    }
}

