/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ws;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;

class CacheWriter
extends Writer {
    private final StringWriter bufferWriter = new StringWriter();
    private final Writer outputWriter;
    private boolean isClosed;

    CacheWriter(Writer outputWriter) {
        this.outputWriter = outputWriter;
        this.isClosed = false;
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        this.bufferWriter.write(cbuf, off, len);
    }

    @Override
    public void flush() {
        this.bufferWriter.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        IOUtils.write((String)this.bufferWriter.toString(), (Writer)this.outputWriter);
        this.outputWriter.close();
        this.isClosed = true;
    }
}

